/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.killcommands;

import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractKillCommand<T extends Entity>
extends AbstractSingleCommand
implements IActionCommand {
    public AbstractKillCommand(@NotNull String desc) {
        super("minecolonies", "kill", desc);
    }

    public abstract String getDesc();

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        this.executeShared(server, sender);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        this.executeShared(server, sender);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender) throws CommandException {
        if (sender instanceof EntityPlayer && !AbstractKillCommand.isPlayerOpped(sender)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Must be OP to use command"));
            return;
        }
        int entitiesKilled = 0;
        for (Entity entity2 : server.func_130014_f_().func_175644_a(this.getEntityClass(), entity -> true)) {
            entity2.func_70106_y();
            ++entitiesKilled;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(entitiesKilled + " entities killed"));
    }

    public abstract Class<T> getEntityClass();

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

