/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.citizencommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jetbrains.annotations.NotNull;

public class ListCitizensCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "list";
    private static final String CITIZEN_DESCRIPTION = "\u00a72ID: \u00a7f %d \u00a72 Name: \u00a7f %s";
    private static final String COORDINATES_XYZ = "\u00a72Coordinates: \u00a7f \u00a74x=\u00a7f%s \u00a74y=\u00a7f%s \u00a74z=\u00a7f%s";
    private static final String LIST_COMMAND_SUGGESTED = "/mc citizens list colony: %d page: %d";
    private static final String COMMAND_CITIZEN_INFO = "/mc citizens info colony: %s citizen: %s";
    private static final String PAGE_TOP = "\u00a72   ------------------ page %d of %d ------------------";
    private static final String PREV_PAGE = " <- prev";
    private static final String NEXT_PAGE = "next -> ";
    private static final String PAGE_LINE = "\u00a72 ----------------";
    private static final String PAGE_LINE_DIVIDER = "\u00a72 | ";
    private static final int CITIZENS_ON_PAGE = 9;

    public ListCitizensCommand() {
        super(new String[0]);
    }

    public ListCitizensCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<colonyId>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        Colony colony = actionMenuState.getColonyForArgument("colony");
        Integer page = actionMenuState.getIntegerForArgument("page");
        this.executeShared(server, sender, colony, page);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        IColony icolony;
        int colonyId = ListCitizensCommand.getIthArgument(args, 0, ListCitizensCommand.getColonyId(sender));
        Integer page = ListCitizensCommand.getIthArgument(args, 1, 1);
        Colony colony = null;
        if (sender instanceof EntityPlayer && colonyId == -1 && (icolony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), (EntityPlayer)sender)) != null) {
            colonyId = icolony.getID();
        }
        colony = ColonyManager.getColonyByWorld(colonyId, (World)server.func_71218_a(0));
        this.executeShared(server, sender, colony, page);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, Colony colony, Integer pageProvided) throws CommandException {
        List<CitizenData> citizens;
        int citizenCount;
        int page = null != pageProvided ? pageProvided : 1;
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            if (null != colony && !this.canPlayerUseCommand(player, AbstractSingleCommand.Commands.LISTCITIZENS, colony.getID())) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Not happenin bro!!, You are not permitted to do that!"));
                return;
            }
        }
        int halfPage = (citizenCount = (citizens = colony.getCitizenManager().getCitizens()).size()) % 9 == 0 ? 0 : 1;
        int pageCount = citizenCount / 9 + halfPage;
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, citizenCount);
        List<Object> citizensPage = pageStartIndex < 0 || pageStartIndex >= citizenCount ? new ArrayList() : citizens.subList(pageStartIndex, pageStopIndex);
        TextComponentString headerLine = new TextComponentString(String.format(PAGE_TOP, page, pageCount));
        sender.func_145747_a((ITextComponent)headerLine);
        for (CitizenData citizenData : citizensPage) {
            sender.func_145747_a(new TextComponentString(String.format(CITIZEN_DESCRIPTION, citizenData.getId(), citizenData.getName())).func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(COMMAND_CITIZEN_INFO, citizenData.getColony().getID(), citizenData.getId())))));
            citizenData.getCitizenEntity().ifPresent(entityCitizen -> {
                BlockPos position = entityCitizen.func_180425_c();
                sender.func_145747_a((ITextComponent)new TextComponentString(String.format(COORDINATES_XYZ, position.func_177958_n(), position.func_177956_o(), position.func_177952_p())));
            });
        }
        ListCitizensCommand.drawPageSwitcher(sender, page, citizenCount, halfPage, null != colony ? colony.getID() : -1);
    }

    private static int getColonyId(@NotNull ICommandSender sender) {
        WorldServer world;
        Colony colony;
        IColony tempColony = ColonyManager.getIColonyByOwner(sender.func_130014_f_(), sender.func_174793_f().func_110124_au());
        if (tempColony != null && (colony = ColonyManager.getColonyByPosFromWorld((World)(world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0)), tempColony.getCenter())) != null) {
            return colony.getID();
        }
        return 1;
    }

    private static void drawPageSwitcher(@NotNull ICommandSender sender, int page, int count, int halfPage, int colonyId) {
        int prevPage = Math.max(0, page - 1);
        int nextPage = Math.min(page + 1, count / 9 + halfPage);
        ITextComponent prevButton = new TextComponentString(PREV_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, prevPage))));
        ITextComponent nextButton = new TextComponentString(NEXT_PAGE).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, nextPage))));
        TextComponentString beginLine = new TextComponentString(PAGE_LINE);
        TextComponentString endLine = new TextComponentString(PAGE_LINE);
        sender.func_145747_a(beginLine.func_150257_a(prevButton).func_150257_a((ITextComponent)new TextComponentString(PAGE_LINE_DIVIDER)).func_150257_a(nextButton).func_150257_a((ITextComponent)endLine));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

