/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutSmelter;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.FilterableListView;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import java.util.Random;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingSmeltery
extends AbstractBuildingFurnaceUser {
    private static final String SMELTERY_DESC = "Smeltery";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int STUFF_TO_KEEP = 10;

    public BuildingSmeltery(Colony c, BlockPos l) {
        super(c, l);
        this.keepX.put(ColonyManager.getCompatibilityManager()::isOre, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(TileEntityFurnace::func_145954_b, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(stack -> ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemArmor), new Tuple((Object)10, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SMELTERY_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobSmelter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SMELTERY_DESC;
    }

    public int ingotMultiplier(int citizenLevel, Random random) {
        switch (this.getBuildingLevel()) {
            case 1: {
                return random.nextInt(100 - citizenLevel) == 0 ? 2 : 1;
            }
            case 2: {
                return random.nextInt(100 - citizenLevel * 2) == 2 ? 2 : 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return random.nextInt(100 - citizenLevel) == 0 ? 3 : 2;
            }
        }
        return 1;
    }

    public static class View
    extends FilterableListView {
        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutSmelter(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.INTELLIGENCE;
        }
    }
}

