/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.blocks.ModBlocks;
import com.minecolonies.coremod.client.gui.WindowHutCrusher;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobCrusher;
import com.minecolonies.coremod.network.messages.CrusherSetModeMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class BuildingCrusher
extends AbstractBuildingCrafter {
    private static final double BUILDING_LEVEL_MULTIPLIER = 16.0;
    private static final String CRUSHER_DESC = "Crusher";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final List<ItemStack> cobbleInput = new ArrayList<ItemStack>();
    private static final List<ItemStack> gravelInput = new ArrayList<ItemStack>();
    private static final List<ItemStack> sandInput = new ArrayList<ItemStack>();
    private static final IRecipeStorage cobbleCrushing;
    private static final IRecipeStorage gravelCrushing;
    private static final IRecipeStorage sandCrushing;
    private int dailyQuantity = 0;
    private int currentDailyQuantity = 0;
    private CrusherMode crusherMode = CrusherMode.GRAVEL;

    public BuildingCrusher(Colony c, BlockPos l) {
        super(c, l);
    }

    public IRecipeStorage getCurrentRecipe() {
        switch (this.crusherMode) {
            case SAND: {
                return gravelCrushing;
            }
            case CLAY: {
                return sandCrushing;
            }
        }
        return cobbleCrushing;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CRUSHER_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public AbstractJob createJob(CitizenData citizen) {
        return new JobCrusher(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return CRUSHER_DESC;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return false;
    }

    public void setCrusherMode(CrusherMode crusherMode, int dailyQuantity) {
        this.crusherMode = crusherMode;
        this.dailyQuantity = dailyQuantity;
    }

    public Tuple<CrusherMode, Integer> getCrusherMode() {
        return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
    }

    public void setCurrentDailyQuantity(int currentDailyQuantity) {
        this.currentDailyQuantity = currentDailyQuantity;
    }

    public int getMaxDailyQuantity() {
        if (this.getBuildingLevel() >= 5) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(this.getBuildingLevel(), 2.0) * 16.0);
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.currentDailyQuantity = 0;
    }

    public int getCurrentDailyQuantity() {
        return this.currentDailyQuantity;
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.dailyQuantity = compound.func_74762_e("daily");
        this.currentDailyQuantity = compound.func_74762_e("currentDaily");
        this.crusherMode = CrusherMode.values()[compound.func_74762_e("mode")];
        if (this.recipes.isEmpty()) {
            IToken token1 = ColonyManager.getRecipeManager().checkOrAddRecipe(cobbleCrushing);
            IToken token2 = ColonyManager.getRecipeManager().checkOrAddRecipe(gravelCrushing);
            IToken token3 = ColonyManager.getRecipeManager().checkOrAddRecipe(sandCrushing);
            this.addRecipe(token1);
            this.addRecipe(token2);
            this.addRecipe(token3);
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74768_a("daily", this.dailyQuantity);
        compound.func_74768_a("currentDaily", this.currentDailyQuantity);
        compound.func_74768_a("mode", this.crusherMode.ordinal());
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.crusherMode.ordinal());
        buf.writeInt(this.dailyQuantity);
    }

    static {
        cobbleInput.add(new ItemStack(Blocks.field_150347_e, 2));
        gravelInput.add(new ItemStack(Blocks.field_150351_n, 2));
        sandInput.add(new ItemStack((Block)Blocks.field_150354_m, 2));
        cobbleCrushing = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{cobbleInput, 2, new ItemStack(Blocks.field_150351_n, 1), ModBlocks.blockHutCrusher});
        gravelCrushing = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{gravelInput, 2, new ItemStack((Block)Blocks.field_150354_m, 1), ModBlocks.blockHutCrusher});
        sandCrushing = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{sandInput, 2, new ItemStack(Blocks.field_150435_aG, 1), ModBlocks.blockHutCrusher});
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        private int dailyQuantity = 0;
        private CrusherMode crusherMode = CrusherMode.GRAVEL;

        public View(ColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.crusherMode = CrusherMode.values()[buf.readInt()];
            this.dailyQuantity = buf.readInt();
        }

        public void setCrusherMode(CrusherMode crusherMode, int dailyQuantity) {
            this.crusherMode = crusherMode;
            this.dailyQuantity = dailyQuantity;
            MineColonies.getNetwork().sendToServer((IMessage)new CrusherSetModeMessage(this, crusherMode.ordinal(), dailyQuantity));
        }

        public Tuple<CrusherMode, Integer> getCrusherMode() {
            return new Tuple((Object)this.crusherMode, (Object)this.dailyQuantity);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrusher(this);
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getPrimarySkill() {
            return AbstractBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public AbstractBuildingWorker.Skill getSecondarySkill() {
            return AbstractBuildingWorker.Skill.ENDURANCE;
        }
    }

    public static enum CrusherMode {
        GRAVEL,
        SAND,
        CLAY;

    }
}

