/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyManagerCapability {
    public Colony createColony(@NotNull World var1, @NotNull BlockPos var2);

    public void deleteColony(int var1);

    @Nullable
    public Colony getColony(int var1);

    public List<Colony> getColonies();

    public void addColony(Colony var1);

    public void setMissingChunksToLoad(int var1);

    public int getMissingChunksToLoad();

    public int getTopID();

    public static class Storage
    implements Capability.IStorage<IColonyManagerCapability> {
        public NBTBase writeNBT(@NotNull Capability<IColonyManagerCapability> capability, @NotNull IColonyManagerCapability instance, @Nullable EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("colonies", (NBTBase)instance.getColonies().stream().map(Colony::getColonyTag).collect(NBTUtils.toNBTTagList()));
            compound.func_74768_a("missingChunks", instance.getMissingChunksToLoad());
            return compound;
        }

        public void readNBT(@NotNull Capability<IColonyManagerCapability> capability, @NotNull IColonyManagerCapability instance, @Nullable EnumFacing side, @NotNull NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                NBTUtils.streamCompound(((NBTTagCompound)nbt).func_150295_c("colonies", 10)).map(colonyCompound -> Colony.loadColony(colonyCompound, null)).forEach(instance::addColony);
                instance.setMissingChunksToLoad(compound.func_74762_e("missingChunks"));
            }
        }
    }

    public static class Impl
    implements IColonyManagerCapability {
        @NotNull
        private final ColonyList<Colony> colonies = new ColonyList();
        private int missingChunksToLoad = 0;

        @Override
        public Colony createColony(@NotNull World w, @NotNull BlockPos pos) {
            return this.colonies.create(w, pos);
        }

        @Override
        public void deleteColony(int id) {
            this.colonies.remove(id);
        }

        @Override
        public Colony getColony(int id) {
            return this.colonies.get(id);
        }

        @Override
        public List<Colony> getColonies() {
            return this.colonies.getCopyAsList();
        }

        @Override
        public void addColony(Colony colony) {
            this.colonies.add(colony);
        }

        @Override
        public void setMissingChunksToLoad(int amount) {
            this.missingChunksToLoad = amount;
        }

        @Override
        public int getMissingChunksToLoad() {
            return this.missingChunksToLoad;
        }

        @Override
        public int getTopID() {
            return this.colonies.getTopID();
        }
    }
}

