/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.HappinessData;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.managers.BuildingManager;
import com.minecolonies.coremod.colony.managers.CitizenManager;
import com.minecolonies.coremod.colony.managers.ColonyHappinessManager;
import com.minecolonies.coremod.colony.managers.ColonyPackageManager;
import com.minecolonies.coremod.colony.managers.ProgressManager;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.colony.managers.StatisticAchievementManager;
import com.minecolonies.coremod.colony.managers.interfaces.IBuildingManager;
import com.minecolonies.coremod.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.coremod.colony.managers.interfaces.IColonyHappinessManager;
import com.minecolonies.coremod.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.coremod.colony.managers.interfaces.IProgressManager;
import com.minecolonies.coremod.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.coremod.colony.managers.interfaces.IStatisticAchievementManager;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.pvp.AttackingPlayer;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.colony.workorders.WorkManager;
import com.minecolonies.coremod.entity.EntityCitizen;
import com.minecolonies.coremod.entity.ai.mobs.util.MobEventsUtils;
import com.minecolonies.coremod.network.messages.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.coremod.permissions.ColonyPermissionEventHandler;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colony
implements IColony {
    private String style = "wooden";
    private final int id;
    private int dimensionId;
    private final Map<BlockPos, IBlockState> wayPoints = new HashMap<BlockPos, IBlockState>();
    private final WorkManager workManager = new WorkManager(this);
    private final IBuildingManager buildingManager = new BuildingManager(this);
    private final ICitizenManager citizenManager = new CitizenManager(this);
    private final IColonyHappinessManager colonyHappinessManager = new ColonyHappinessManager();
    private final IStatisticAchievementManager statsManager = new StatisticAchievementManager(this);
    private final IRaiderManager raidManager = new RaidManager(this);
    private final IColonyPackageManager packageManager = new ColonyPackageManager(this);
    private final IProgressManager progressManager = new ProgressManager(this);
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final ColonyPermissionEventHandler eventHandler;
    private boolean canColonyBeAutoDeleted = true;
    private boolean isDay = true;
    @Nullable
    private World world = null;
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    private boolean moveIn = true;
    private String name = "ERROR(Wasn't placed by player)";
    private BlockPos center;
    private int nightsSinceLastRaid = 0;
    @NotNull
    private Permissions permissions;
    private IRequestManager requestManager;
    private NBTTagCompound colonyTag;
    private final List<EntityPlayer> visitingPlayers = new ArrayList<EntityPlayer>();
    private final List<AttackingPlayer> attackingPlayers = new ArrayList<AttackingPlayer>();
    private final HappinessData happinessData = new HappinessData();
    private boolean needToMourn = false;
    private boolean mourning = false;
    private boolean isActive = true;
    private TextFormatting colonyTeamColor = TextFormatting.WHITE;
    private int boughtCitizenCost = 0;

    Colony(int id, @Nullable World w, BlockPos c) {
        this(id, w);
        this.center = c;
        this.world = w;
        this.permissions = new Permissions(this);
        this.requestManager = new StandardRequestManager(this);
    }

    protected Colony(int id, @Nullable World world) {
        this.id = id;
        if (world != null) {
            this.dimensionId = world.field_73011_w.getDimension();
            this.world = world;
            this.checkOrCreateTeam();
        }
        this.permissions = new Permissions(this);
        this.eventHandler = new ColonyPermissionEventHandler(this);
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        for (String s : Configurations.gameplay.freeToInteractBlocks) {
            Block block = Block.func_149684_b((String)s);
            if (block == null) {
                BlockPos pos = BlockPosUtil.getBlockPosOfString(s);
                if (pos == null) continue;
                this.freePositions.add(pos);
                continue;
            }
            this.freeBlocks.add(block);
        }
    }

    private void checkOrCreateTeam() {
        if (this.world.func_96441_U().func_96508_e("teamcolony" + this.id) == null) {
            this.world.func_96441_U().func_96527_f("teamcolony" + this.id);
            this.world.func_96441_U().func_96508_e("teamcolony" + this.id).func_96660_a(false);
        }
    }

    public void setColonyColor(TextFormatting colonyColor) {
        if (this.world != null) {
            this.checkOrCreateTeam();
            this.colonyTeamColor = colonyColor;
            this.world.func_96441_U().func_96508_e("teamcolony" + this.id).func_178774_a(colonyColor);
            this.world.func_96441_U().func_96508_e("teamcolony" + this.id).func_96666_b(colonyColor.toString());
            this.markDirty();
        }
    }

    @NotNull
    public static Colony loadColony(@NotNull NBTTagCompound compound, @Nullable World world) {
        int id = compound.func_74762_e("id");
        Colony c = new Colony(id, world);
        c.name = compound.func_74779_i("name");
        c.center = BlockPosUtil.readFromNBT(compound, "center");
        c.setRequestManager();
        c.readFromNBT(compound);
        if (c.getProgressManager().isPrintingProgress() && (c.getBuildingManager().getBuildings().size() > 10 || c.getCitizenManager().getCitizens().size() > 20)) {
            c.getProgressManager().togglePrintProgress();
        }
        return c;
    }

    private void setRequestManager() {
        this.requestManager = new StandardRequestManager(this);
    }

    public void readFromNBT(@NotNull NBTTagCompound compound) {
        this.manualHiring = compound.func_74767_n("manualHiring");
        this.dimensionId = compound.func_74762_e("dimension");
        if (compound.func_74764_b("needToMourn")) {
            this.needToMourn = compound.func_74767_n("needToMourn");
            this.mourning = compound.func_74767_n("mourning");
        } else {
            this.needToMourn = false;
            this.mourning = false;
        }
        this.boughtCitizenCost = compound.func_74762_e("bought_citizen");
        this.permissions.loadPermissions(compound);
        if (compound.func_74764_b("citizenManager")) {
            this.citizenManager.readFromNBT(compound.func_74775_l("citizenManager"));
        } else {
            this.citizenManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("buildingManager")) {
            this.buildingManager.readFromNBT(compound.func_74775_l("buildingManager"));
        } else {
            this.buildingManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("statsManager")) {
            this.statsManager.readFromNBT(compound.func_74775_l("statsManager"));
        } else {
            this.statsManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("progressManager")) {
            this.progressManager.readFromNBT(compound);
        }
        if (compound.func_74764_b("happinessModifier")) {
            this.colonyHappinessManager.setLockedHappinessModifier(Optional.of(compound.func_74769_h("happinessModifier")));
        } else {
            this.colonyHappinessManager.setLockedHappinessModifier(Optional.empty());
        }
        this.raidManager.readFromNBT(compound);
        this.workManager.readFromNBT(compound.func_74775_l("work"));
        NBTTagList wayPointTagList = compound.func_150295_c("waypoints", 10);
        for (int i = 0; i < wayPointTagList.func_74745_c(); ++i) {
            NBTTagCompound blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.readFromNBT(blockAtPos, "waypoints");
            IBlockState state = NBTUtil.func_190008_d((NBTTagCompound)blockAtPos);
            this.wayPoints.put(pos, state);
        }
        NBTTagList freeBlockTagList = compound.func_150295_c("freeBlocks", 8);
        for (int i = 0; i < freeBlockTagList.func_74745_c(); ++i) {
            this.freeBlocks.add(Block.func_149684_b((String)freeBlockTagList.func_150307_f(i)));
        }
        NBTTagList freePositionTagList = compound.func_150295_c("freePositions", 10);
        for (int i = 0; i < freePositionTagList.func_74745_c(); ++i) {
            NBTTagCompound blockTag = freePositionTagList.func_150305_b(i);
            BlockPos block = BlockPosUtil.readFromNBT(blockTag, "freePositions");
            this.freePositions.add(block);
        }
        this.happinessData.readFromNBT(compound);
        this.packageManager.setLastContactInHours(compound.func_74762_e("abandoned"));
        this.manualHousing = compound.func_74767_n("manualHousing");
        if (compound.func_74764_b("moveIn")) {
            this.moveIn = compound.func_74767_n("moveIn");
        }
        if (compound.func_74764_b("style")) {
            this.style = compound.func_74779_i("style");
        }
        if (compound.func_74764_b("raidable")) {
            this.raidManager.setCanHaveRaiderEvents(compound.func_74767_n("raidable"));
        } else {
            this.raidManager.setCanHaveRaiderEvents(true);
        }
        this.canColonyBeAutoDeleted = compound.func_74764_b("autoDelete") ? compound.func_74767_n("autoDelete") : true;
        if (compound.func_74764_b("teamcolor")) {
            this.setColonyColor(TextFormatting.values()[compound.func_74762_e("teamcolor")]);
        }
        this.requestManager.reset();
        if (compound.func_74764_b("requestManager")) {
            this.requestManager.deserializeNBT((NBTBase)compound.func_74775_l("requestManager"));
        }
        this.colonyTag = compound;
    }

    public ColonyPermissionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound compound) {
        compound.func_74768_a("id", this.id);
        compound.func_74768_a("dimension", this.dimensionId);
        compound.func_74778_a("name", this.name);
        BlockPosUtil.writeToNBT(compound, "center", this.center);
        compound.func_74757_a("manualHiring", this.manualHiring);
        compound.func_74757_a("needToMourn", this.needToMourn);
        compound.func_74757_a("mourning", this.mourning);
        compound.func_74768_a("bought_citizen", this.boughtCitizenCost);
        this.permissions.savePermissions(compound);
        NBTTagCompound buildingCompound = new NBTTagCompound();
        this.buildingManager.writeToNBT(buildingCompound);
        compound.func_74782_a("buildingManager", (NBTBase)buildingCompound);
        NBTTagCompound citizenCompound = new NBTTagCompound();
        this.citizenManager.writeToNBT(citizenCompound);
        compound.func_74782_a("citizenManager", (NBTBase)citizenCompound);
        this.colonyHappinessManager.getLockedHappinessModifier().ifPresent(d -> compound.func_74780_a("happinessModifier", d.doubleValue()));
        NBTTagCompound statsCompound = new NBTTagCompound();
        this.statsManager.writeToNBT(statsCompound);
        compound.func_74782_a("statsManager", (NBTBase)statsCompound);
        NBTTagCompound workManagerCompound = new NBTTagCompound();
        this.workManager.writeToNBT(workManagerCompound);
        compound.func_74782_a("work", (NBTBase)workManagerCompound);
        this.progressManager.writeToNBT(compound);
        this.raidManager.writeToNBT(compound);
        NBTTagList wayPointTagList = new NBTTagList();
        for (Map.Entry<BlockPos, IBlockState> entry : this.wayPoints.entrySet()) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, "waypoints", entry.getKey());
            NBTUtil.func_190009_a((NBTTagCompound)wayPointCompound, (IBlockState)entry.getValue());
            wayPointTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a("waypoints", (NBTBase)wayPointTagList);
        NBTTagList freeBlocksTagList = new NBTTagList();
        for (Block block : this.freeBlocks) {
            freeBlocksTagList.func_74742_a((NBTBase)new NBTTagString(block.getRegistryName().toString()));
        }
        compound.func_74782_a("freeBlocks", (NBTBase)freeBlocksTagList);
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos pos : this.freePositions) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, "freePositions", pos);
            nBTTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a("freePositions", (NBTBase)nBTTagList);
        this.happinessData.writeToNBT(compound);
        compound.func_74768_a("abandoned", this.packageManager.getLastContactInHours());
        compound.func_74757_a("manualHousing", this.manualHousing);
        compound.func_74757_a("moveIn", this.moveIn);
        compound.func_74782_a("requestManager", this.getRequestManager().serializeNBT());
        compound.func_74778_a("style", this.style);
        compound.func_74757_a("raidable", this.raidManager.canHaveRaiderEvents());
        compound.func_74757_a("autoDelete", this.canColonyBeAutoDeleted);
        compound.func_74768_a("teamcolor", this.colonyTeamColor.ordinal());
        this.colonyTag = compound;
        this.isActive = false;
        return compound;
    }

    @Override
    public int getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public void onWorldLoad(@NotNull World w) {
        this.world = w;
    }

    public void onWorldUnload(@NotNull World w) {
        if (!w.equals(this.world)) {
            return;
        }
        this.world = null;
    }

    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        this.packageManager.updateSubscribers();
        if (this.packageManager.getSubscribers().isEmpty()) {
            return;
        }
        this.isActive = true;
        this.buildingManager.tick(event);
        this.getRequestManager().func_73660_a();
        ArrayList<EntityPlayer> visitors = new ArrayList<EntityPlayer>(this.visitingPlayers);
        for (EntityPlayer player : visitors) {
            if (this.packageManager.getSubscribers().contains(player)) continue;
            this.visitingPlayers.remove(player);
            this.attackingPlayers.remove(new AttackingPlayer(player));
        }
    }

    @NotNull
    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public Set<BlockPos> getFreePositions() {
        return new HashSet<BlockPos>(this.freePositions);
    }

    public Set<Block> getFreeBlocks() {
        return new HashSet<Block>(this.freeBlocks);
    }

    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
        this.markDirty();
    }

    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
        this.markDirty();
    }

    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
        this.markDirty();
    }

    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
        this.markDirty();
    }

    public HappinessData getHappinessData() {
        return this.happinessData;
    }

    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.world != this.getWorld()) {
            return;
        }
        if (this.packageManager.getSubscribers().isEmpty()) {
            return;
        }
        this.isActive = true;
        this.buildingManager.cleanUpBuildings(event);
        this.citizenManager.onWorldTick(event);
        if (Colony.shallUpdate(this.world, 20) && event.world.func_175659_aa() != EnumDifficulty.PEACEFUL && Configurations.gameplay.doBarbariansSpawn && this.raidManager.canHaveRaiderEvents()) {
            if (!this.world.func_73046_m().func_184103_al().func_181057_v().stream().filter(this.permissions::isSubscriber).collect(Collectors.toList()).isEmpty() && MobEventsUtils.isItTimeToRaid(event.world, this)) {
                MobEventsUtils.raiderEvent(event.world, this);
            }
        }
        if (Colony.shallUpdate(this.world, 20)) {
            for (AttackingPlayer player : this.attackingPlayers) {
                if (player.getGuards().isEmpty()) continue;
                player.refreshList(this);
                if (!player.getGuards().isEmpty()) continue;
                LanguageHandler.sendPlayersMessage(this.getMessageEntityPlayers(), "You successfully defended your colony against, " + player.getPlayer().func_70005_c_(), new Object[0]);
            }
        }
        this.raidManager.onWorldTick(this.world);
        this.buildingManager.onWorldTick(event);
        if (this.isDay && !this.world.func_72935_r()) {
            this.isDay = false;
            ++this.nightsSinceLastRaid;
            if (!this.packageManager.getSubscribers().isEmpty()) {
                this.citizenManager.checkCitizensForHappiness();
            }
            this.happinessData.processDeathModifiers();
            if (this.mourning) {
                this.mourning = false;
                this.citizenManager.updateCitizenMourn(false);
            }
        } else if (!this.isDay && this.world.func_72935_r()) {
            this.isDay = true;
            if (this.needToMourn) {
                this.needToMourn = false;
                this.mourning = true;
                this.citizenManager.updateCitizenMourn(true);
            }
        }
        this.updateWayPoints();
        this.workManager.onWorldTick(event);
    }

    public static boolean shallUpdate(World world, int averageTicks) {
        return world.func_72820_D() % (long)(world.field_73012_v.nextInt(averageTicks * 2) + 1) == 0L;
    }

    public boolean areAllColonyChunksLoaded(@NotNull TickEvent.WorldTickEvent event) {
        int distanceFromCenter = Configurations.gameplay.workingRangeTownHallChunks * 16 + 48 + 16 - 1;
        for (int x = -distanceFromCenter; x <= distanceFromCenter; x += 16) {
            for (int z = -distanceFromCenter; z <= distanceFromCenter; z += 16) {
                if (event.world.func_175667_e(new BlockPos(this.getCenter().func_177958_n() + x, 1, this.getCenter().func_177952_p() + z))) continue;
                return false;
            }
        }
        return true;
    }

    private void updateWayPoints() {
        BlockPos key;
        int stopAt;
        Object[] entries;
        Object obj;
        if (this.world != null && this.world.field_73012_v.nextInt(100) <= 1 && !this.wayPoints.isEmpty() && (obj = (entries = this.wayPoints.entrySet().toArray())[stopAt = this.world.field_73012_v.nextInt(entries.length)]) instanceof Map.Entry && ((Map.Entry)obj).getKey() instanceof BlockPos && ((Map.Entry)obj).getValue() instanceof IBlockState && this.world.func_175667_e(key = (BlockPos)((Map.Entry)obj).getKey())) {
            IBlockState value = (IBlockState)((Map.Entry)obj).getValue();
            if (this.world.func_180495_p(key).func_177230_c() != value.func_177230_c()) {
                this.wayPoints.remove(key);
                this.markDirty();
            }
        }
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull World w, @NotNull BlockPos pos) {
        if (w.field_73011_w.getDimension() != this.dimensionId) {
            return false;
        }
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        return cap.getOwningColony() == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.buildingManager.hasTownHall();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.buildingManager.hasWarehouse();
    }

    @Override
    public int getLastContactInHours() {
        return this.packageManager.getLastContactInHours();
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nullable
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public boolean hasWillRaidTonight() {
        return this.raidManager.willRaidTonight();
    }

    @Override
    public boolean isCanHaveBarbEvents() {
        return this.raidManager.canHaveRaiderEvents();
    }

    @Override
    public boolean isHasRaidBeenCalculated() {
        return this.raidManager.hasRaidBeenCalculated();
    }

    @Override
    public void markDirty() {
        this.packageManager.setDirty();
        this.isActive = true;
    }

    @Override
    public boolean canBeAutoDeleted() {
        return this.canColonyBeAutoDeleted;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.buildingManager.getBuilding(pos);
    }

    @NotNull
    public List<EntityPlayer> getMessageEntityPlayers() {
        return ServerUtils.getPlayersFromUUID(this.world, this.getPermissions().getMessagePlayers());
    }

    public boolean isManualHiring() {
        return this.manualHiring;
    }

    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
        this.progressManager.progressEmploymentModeChange();
        this.markDirty();
    }

    public boolean isManualHousing() {
        return this.manualHousing;
    }

    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
        this.markDirty();
    }

    public boolean canMoveIn() {
        return this.moveIn;
    }

    public void setMoveIn(boolean moveIn) {
        this.moveIn = moveIn;
        this.markDirty();
    }

    public void removeWorkOrderInView(int orderId) {
        for (EntityPlayerMP player : this.packageManager.getSubscribers()) {
            MineColonies.getNetwork().sendTo((IMessage)new ColonyViewRemoveWorkOrderMessage(this, orderId), player);
        }
    }

    public void onBuildingUpgradeComplete(@Nullable AbstractBuilding building, int level) {
        if (building != null) {
            building.onUpgradeComplete(level);
            this.markDirty();
        }
    }

    public void addWayPoint(BlockPos point, IBlockState block) {
        this.wayPoints.put(point, block);
        this.markDirty();
    }

    @NotNull
    public List<BlockPos> getWayPoints(@NotNull BlockPos position, @NotNull BlockPos target) {
        ArrayList<BlockPos> tempWayPoints = new ArrayList<BlockPos>();
        tempWayPoints.addAll(this.wayPoints.keySet());
        tempWayPoints.addAll(this.buildingManager.getBuildings().keySet());
        double maxX = Math.max(position.func_177958_n(), target.func_177958_n());
        double maxZ = Math.max(position.func_177952_p(), target.func_177952_p());
        double minX = Math.min(position.func_177958_n(), target.func_177958_n());
        double minZ = Math.min(position.func_177952_p(), target.func_177952_p());
        Iterator iterator = tempWayPoints.iterator();
        while (iterator.hasNext()) {
            BlockPos p = (BlockPos)iterator.next();
            int x = p.func_177958_n();
            int z = p.func_177952_p();
            if (!((double)x < minX || (double)x > maxX || (double)z < minZ) && !((double)z > maxZ)) continue;
            iterator.remove();
        }
        return tempWayPoints;
    }

    public double getOverallHappiness() {
        double happinessTotal = 0.0;
        for (CitizenData citizen : this.citizenManager.getCitizens()) {
            happinessTotal += citizen.getCitizenHappinessHandler().getHappiness();
        }
        double happinessAverage = happinessTotal / (double)this.citizenManager.getCitizens().size();
        if ((happinessTotal = happinessAverage + this.happinessData.getTotalHappinessModifier()) > 10.0) {
            happinessTotal = 10.0;
        }
        return happinessTotal;
    }

    public Map<BlockPos, IBlockState> getWayPoints() {
        return new HashMap<BlockPos, IBlockState>(this.wayPoints);
    }

    public void setCanBeAutoDeleted(Boolean canBeDeleted) {
        this.canColonyBeAutoDeleted = canBeDeleted;
        this.markDirty();
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public IBuildingManager getBuildingManager() {
        return this.buildingManager;
    }

    public ICitizenManager getCitizenManager() {
        return this.citizenManager;
    }

    public IColonyHappinessManager getColonyHappinessManager() {
        return this.colonyHappinessManager;
    }

    public IStatisticAchievementManager getStatsManager() {
        return this.statsManager;
    }

    public IRaiderManager getRaiderManager() {
        return this.raidManager;
    }

    public IColonyPackageManager getPackageManager() {
        return this.packageManager;
    }

    public IProgressManager getProgressManager() {
        return this.progressManager;
    }

    public ImmutableList<EntityPlayer> getVisitingPlayers() {
        return ImmutableList.copyOf(this.visitingPlayers);
    }

    @Override
    public void addVisitingPlayer(EntityPlayer player) {
        Rank rank = this.getPermissions().getRank(player);
        if (rank != Rank.OWNER && rank != Rank.OFFICER && !this.visitingPlayers.contains(player) && Configurations.gameplay.sendEnteringLeavingMessages) {
            this.visitingPlayers.add(player);
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.enteringColony", this.getPermissions().getOwnerName());
            LanguageHandler.sendPlayersMessage(this.getMessageEntityPlayers(), "com.minecolonies.coremod.enteringColonyNotify", player.func_70005_c_(), this.getName());
        }
    }

    @Override
    public void removeVisitingPlayer(EntityPlayer player) {
        if (!this.getMessageEntityPlayers().contains(player) && Configurations.gameplay.sendEnteringLeavingMessages) {
            this.visitingPlayers.remove(player);
            LanguageHandler.sendPlayerMessage(player, "com.minecolonies.coremod.leavingColony", this.getPermissions().getOwnerName());
            LanguageHandler.sendPlayersMessage(this.getMessageEntityPlayers(), "com.minecolonies.coremod.leavingColonyNotify", player.func_70005_c_(), this.getName());
        }
    }

    public NBTTagCompound getColonyTag() {
        if (this.colonyTag == null || this.isActive) {
            this.writeToNBT(new NBTTagCompound());
        }
        return this.colonyTag;
    }

    public int getNightsSinceLastRaid() {
        return this.nightsSinceLastRaid;
    }

    public void setNightsSinceLastRaid(int nights) {
        this.nightsSinceLastRaid = nights;
    }

    public boolean isNeedToMourn() {
        return this.needToMourn;
    }

    public void setNeedToMourn(boolean needToMourn, String name) {
        this.needToMourn = needToMourn;
        if (needToMourn) {
            LanguageHandler.sendPlayersMessage(this.getMessageEntityPlayers(), "com.minecolonies.coremod.mourning", name);
        }
    }

    public boolean isMourning() {
        return this.mourning;
    }

    public void addGuardToAttackers(EntityCitizen entityCitizen, EntityPlayer player) {
        if (player == null) {
            return;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            if (attackingPlayer.addGuard(entityCitizen)) {
                LanguageHandler.sendPlayersMessage(this.getMessageEntityPlayers(), "Beware, " + attackingPlayer.getPlayer().func_70005_c_() + " has now: " + attackingPlayer.getGuards().size() + " guards!", new Object[0]);
            }
            return;
        }
        for (EntityPlayer visitingPlayer : this.visitingPlayers) {
            if (!visitingPlayer.equals((Object)player)) continue;
            AttackingPlayer attackingPlayer = new AttackingPlayer(visitingPlayer);
            attackingPlayer.addGuard(entityCitizen);
            this.attackingPlayers.add(attackingPlayer);
            LanguageHandler.sendPlayersMessage(this.getMessageEntityPlayers(), "Beware, " + visitingPlayer.func_70005_c_() + " is attacking you and he brought guards.", new Object[0]);
        }
    }

    public boolean isValidAttackingPlayer(EntityPlayer player) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            return attackingPlayer.isValidAttack(this);
        }
        return false;
    }

    public boolean isValidAttackingGuard(EntityCitizen entity) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        return AttackingPlayer.isValidAttack(entity, this);
    }

    public boolean isColonyUnderAttack() {
        return !this.attackingPlayers.isEmpty();
    }

    public TextFormatting getTeamColonyColor() {
        return this.colonyTeamColor;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public int getBoughtCitizenCost() {
        return this.boughtCitizenCost;
    }

    public void increaseBoughtCitizenCost() {
        this.boughtCitizenCost = 1 + (int)Math.ceil((double)this.boughtCitizenCost * 1.5);
        this.markDirty();
    }
}

