/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.Image;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.DropDownList;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowCitizen;
import com.minecolonies.coremod.client.gui.WindowTownHallHireCitizen;
import com.minecolonies.coremod.client.gui.WindowTownHallNameEntry;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.HappinessData;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.permissions.PermissionEvent;
import com.minecolonies.coremod.colony.workorders.WorkOrderView;
import com.minecolonies.coremod.network.messages.ChangeFreeToInteractBlockMessage;
import com.minecolonies.coremod.network.messages.PermissionsMessage;
import com.minecolonies.coremod.network.messages.RecallSingleCitizenMessage;
import com.minecolonies.coremod.network.messages.RecallTownhallMessage;
import com.minecolonies.coremod.network.messages.TeamColonyColorChangeMessage;
import com.minecolonies.coremod.network.messages.ToggleHelpMessage;
import com.minecolonies.coremod.network.messages.ToggleHousingMessage;
import com.minecolonies.coremod.network.messages.ToggleJobMessage;
import com.minecolonies.coremod.network.messages.ToggleMoveInMessage;
import com.minecolonies.coremod.network.messages.WorkOrderChangeMessage;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowTownHall
extends AbstractWindowBuilding<BuildingTownHall.View> {
    public static final int BLACK = Color.getByName("black", 0);
    private static final int MIN_TH_LEVEL_TO_TELEPORT = 3;
    private final List<WorkOrderView> workOrders = new ArrayList<WorkOrderView>();
    private final BuildingTownHall.View townHall;
    @NotNull
    private final List<Player> users = new ArrayList<Player>();
    @NotNull
    private final List<ColonyView> allies = new ArrayList<ColonyView>();
    @NotNull
    private final List<ColonyView> feuds = new ArrayList<ColonyView>();
    @NotNull
    private final List<CitizenDataView> citizens = new ArrayList<CitizenDataView>();
    @NotNull
    private final Map<String, String> tabsToPages = new HashMap<String, String>();
    private DropDownList colorDropDownList;
    private Button lastTabButton;
    private ScrollingList permEventList;
    private ScrollingList userList;
    private ScrollingList actionsList;
    private ScrollingList freeBlocksList;
    private final ScrollingList alliesList;
    private final ScrollingList feudsList;

    public WindowTownHall(BuildingTownHall.View townHall) {
        super(townHall, "minecolonies:gui/townhall/windowtownhall.xml");
        this.townHall = townHall;
        this.alliesList = this.findPaneOfTypeByID("allies", ScrollingList.class);
        this.feudsList = this.findPaneOfTypeByID("feuds", ScrollingList.class);
        this.initColorPicker();
        this.updateUsers();
        this.updateCitizens();
        this.updateWorkOrders();
        this.updateAllies();
        this.updateFeuds();
        this.tabsToPages.put("actions", "pageActions");
        this.tabsToPages.put("info", "pageInfo");
        this.tabsToPages.put("settings", "pageSettings");
        this.tabsToPages.put("permissions", "pagePermissions");
        this.tabsToPages.put("citizens", "pageCitizens");
        this.tabsToPages.put("workOrder", "pageWorkOrder");
        this.tabsToPages.put("happiness", "pageHappiness");
        this.tabsToPages.keySet().forEach(key -> this.registerButton((String)key, this::onTabClicked));
        this.registerButton("addPlayer", this::addPlayerCLicked);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("removePlayer", this::removePlayerClicked);
        this.registerButton("promote", this::promoteDemoteClicked);
        this.registerButton("demote", this::promoteDemoteClicked);
        this.registerButton("recall", this::recallClicked);
        this.registerButton("hire", this::hireClicked);
        this.registerButton("changeSpec", this::doNothing);
        this.registerButton("toggleJob", this::toggleHiring);
        this.registerButton("toggleHousing", this::toggleHousing);
        this.registerButton("toggleMoveIn", this::toggleMoveIn);
        this.registerButton("togglePrintProgress", this::togglePrintProgress);
        this.registerButton("name", this::fillCitizenInfo);
        this.registerButton("recallone", this::recallOneClicked);
        this.registerButton("officerPage", this::editOfficer);
        this.registerButton("friendPage", this::editFriend);
        this.registerButton("neutralPage", this::editNeutral);
        this.registerButton("hostilePage", this::editHostile);
        this.registerButton("addfakeplayer", this::addPlayerToColonyClicked);
        this.registerButton("tp", this::teleportToColony);
        this.registerButton("plus", this::updatePriority);
        this.registerButton("minus", this::updatePriority);
        this.registerButton("delete", this::deleteWorkOrder);
        this.registerButton("trigger", this::trigger);
        this.registerButton("addBlock", this::addBlock);
        this.registerButton("removeBlock", this::removeBlock);
        this.findPaneOfTypeByID("officerPage", Button.class).setEnabled(false);
        this.colorDropDownList.setSelectedIndex(townHall.getColony().getTeamColonyColor().ordinal());
    }

    private void initColorPicker() {
        this.registerButton("previousColor", this::previousStyle);
        this.registerButton("nextColor", this::nextStyle);
        this.findPaneOfTypeByID("colorPicker", DropDownList.class).setEnabled(this.enabled);
        this.colorDropDownList = this.findPaneOfTypeByID("colorPicker", DropDownList.class);
        this.colorDropDownList.setHandler(this::onDropDownListChanged);
        final List textColors = Arrays.stream(TextFormatting.values()).filter(TextFormatting::func_96302_c).collect(Collectors.toList());
        this.colorDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return textColors.size();
            }

            @Override
            public String getLabel(int index) {
                if (index >= 0 && index < textColors.size()) {
                    return ((TextFormatting)textColors.get(index)).func_96297_d();
                }
                return "";
            }
        });
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        MineColonies.getNetwork().sendToServer((IMessage)new TeamColonyColorChangeMessage(dropDownList.getSelectedIndex(), this.townHall));
    }

    private void nextStyle() {
        this.colorDropDownList.selectNext();
    }

    private void previousStyle() {
        this.colorDropDownList.selectPrevious();
    }

    private void updateUsers() {
        this.users.clear();
        this.users.addAll(this.townHall.getColony().getPlayers().values());
        this.users.sort(Comparator.comparing(Player::getRank, Enum::compareTo));
    }

    private void updateAllies() {
        this.allies.clear();
        ColonyView colony = ((BuildingTownHall.View)this.building).getColony();
        for (Player player : colony.getPermissions().getPlayersByRank(Rank.OFFICER)) {
            IColony col = ColonyManager.getIColonyByOwner((World)Minecraft.func_71410_x().field_71441_e, player.getID());
            if (!(col instanceof ColonyView)) continue;
            for (Player owner : colony.getPermissions().getPlayersByRank(Rank.OWNER)) {
                if (col.getPermissions().getRank(owner.getID()) != Rank.OFFICER) continue;
                this.allies.add((ColonyView)col);
            }
        }
    }

    private void updateFeuds() {
        this.feuds.clear();
        ColonyView colony = ((BuildingTownHall.View)this.building).getColony();
        for (Player player : colony.getPermissions().getPlayersByRank(Rank.HOSTILE)) {
            IColony col = ColonyManager.getIColonyByOwner((World)Minecraft.func_71410_x().field_71441_e, player.getID());
            if (!(col instanceof ColonyView)) continue;
            for (Player owner : colony.getPermissions().getPlayersByRank(Rank.OWNER)) {
                if (col.getPermissions().getRank(owner.getID()) != Rank.HOSTILE) continue;
                this.feuds.add((ColonyView)col);
            }
        }
    }

    private void teleportToColony(@NotNull Button button) {
        int row = this.alliesList.getListElementIndexByPane(button);
        ColonyView ally = this.allies.get(row);
        ITextComponent teleport = new TextComponentString(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.tp", ally.getName())).func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.GOLD).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mc colony teleport colony: " + ally.getID())));
        Minecraft.func_71410_x().field_71439_g.func_145747_a(teleport);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (this.lastTabButton != null) {
            return;
        }
        this.createAndSetStatistics();
        this.findPaneOfTypeByID("pages", SwitchView.class).setView("pageActions");
        this.lastTabButton = this.findPaneOfTypeByID("actions", Button.class);
        this.lastTabButton.off();
        this.findPaneOfTypeByID(this.lastTabButton.getID() + "0", Image.class).hide();
        this.findPaneOfTypeByID(this.lastTabButton.getID() + "1", ButtonImage.class).show();
        this.fillUserList();
        this.fillCitizensList();
        this.fillWorkOrderList();
        this.fillFreeBlockList();
        this.fillAlliesAndFeudsList();
        this.fillPermEventsList();
        this.updateHappiness();
        if (this.townHall.getColony().isManualHiring()) {
            this.findPaneOfTypeByID("toggleJob", Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
        }
        if (!this.townHall.getColony().isPrintingProgress()) {
            this.findPaneOfTypeByID("togglePrintProgress", Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.off", new Object[0]));
        }
        if (this.townHall.getColony().isManualHousing()) {
            this.findPaneOfTypeByID("toggleHousing", Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
        }
        if (this.townHall.getColony().canMoveIn()) {
            this.findPaneOfTypeByID("toggleMoveIn", Button.class).setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.on", new Object[0]));
        }
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.townHall.getColony().getCitizens().values());
    }

    private void updateWorkOrders() {
        this.workOrders.clear();
        this.workOrders.addAll(this.townHall.getColony().getWorkOrders());
        this.sortWorkOrders();
    }

    private void sortWorkOrders() {
        this.workOrders.sort(Comparator.comparing(WorkOrderView::getPriority, Comparator.reverseOrder()));
    }

    private void removeBlock(Button button) {
        int row = this.freeBlocksList.getListElementIndexByPane(button);
        if (row >= 0) {
            List<Block> freeBlocks = this.townHall.getColony().getFreeBlocks();
            List<BlockPos> freePositions = this.townHall.getColony().getFreePositions();
            if (row < freeBlocks.size()) {
                MineColonies.getNetwork().sendToServer((IMessage)new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), freeBlocks.get(row), ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                this.townHall.getColony().removeFreeBlock(freeBlocks.get(row));
            } else if (row < freeBlocks.size() + freePositions.size()) {
                BlockPos freePos = freePositions.get(row - freeBlocks.size());
                MineColonies.getNetwork().sendToServer((IMessage)new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), freePos, ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK));
                this.townHall.getColony().removeFreePosition(freePos);
            }
            this.fillFreeBlockList();
        }
    }

    private void fillFreeBlockList() {
        final List<Block> freeBlocks = this.townHall.getColony().getFreeBlocks();
        final List<BlockPos> freePositions = this.townHall.getColony().getFreePositions();
        this.freeBlocksList = this.findPaneOfTypeByID("blocks", ScrollingList.class);
        this.freeBlocksList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return freeBlocks.size() + freePositions.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index < freeBlocks.size()) {
                    rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(((Block)freeBlocks.get(index)).getRegistryName().toString());
                } else {
                    BlockPos pos = (BlockPos)freePositions.get(index - freeBlocks.size());
                    rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            }
        });
    }

    private void addBlock() {
        BlockPos pos;
        TextField input = this.findPaneOfTypeByID("addBlockName", TextField.class);
        String inputText = input.getText();
        Block block = Block.func_149684_b((String)inputText);
        if (block != null) {
            this.townHall.getColony().addFreeBlock(block);
            MineColonies.getNetwork().sendToServer((IMessage)new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
        }
        if ((pos = BlockPosUtil.getBlockPosOfString(inputText)) != null) {
            MineColonies.getNetwork().sendToServer((IMessage)new ChangeFreeToInteractBlockMessage(this.townHall.getColony(), pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK));
            this.townHall.getColony().addFreePosition(pos);
        }
        this.fillFreeBlockList();
        input.setText("");
    }

    private void trigger(@NotNull Button button) {
        Pane pane = button.getParent().getChildren().get(2);
        int index = 0;
        if (pane instanceof Label) {
            index = Integer.valueOf(((Label)pane).getLabelText());
        }
        boolean trigger = LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOn", new Object[0]).equals(button.getLabel());
        Action action = Action.values()[index];
        Rank rank = Rank.valueOf(this.actionsList.getParent().getID().toUpperCase(Locale.ENGLISH));
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.Permission(this.townHall.getColony(), PermissionsMessage.MessageType.TOGGLE_PERMISSION, rank, action));
        this.townHall.getColony().getPermissions().togglePermission(rank, action);
        if (trigger) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOff", new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOn", new Object[0]));
        }
    }

    private void fillPermissionList(@NotNull String category) {
        this.actionsList = this.findPaneOfTypeByID("actions" + category, ScrollingList.class);
        this.actionsList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return Action.values().length - 3;
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                int actionIndex = index <= 3 ? index : index + 3;
                Action action = Action.values()[actionIndex];
                String name = LanguageHandler.format("com.minecolonies.coremod.permission." + action.toString().toLowerCase(Locale.US), new Object[0]);
                if (name.contains("com.minecolonies.coremod.permission.")) {
                    Log.getLogger().warn("Didn't work for:" + name);
                    return;
                }
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(name);
                boolean isTriggered = WindowTownHall.this.townHall.getColony().getPermissions().hasPermission(Rank.valueOf(WindowTownHall.this.actionsList.getParent().getID().toUpperCase(Locale.ENGLISH)), action);
                rowPane.findPaneOfTypeByID("trigger", Button.class).setLabel(isTriggered ? LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOn", new Object[0]) : LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.retrieveOff", new Object[0]));
                rowPane.findPaneOfTypeByID("index", Label.class).setLabelText(Integer.toString(actionIndex));
            }
        });
    }

    private void editOfficer() {
        this.findPaneOfTypeByID("userGroups", SwitchView.class).setView("officer");
        this.findPaneOfTypeByID("officerPage", Button.class).setEnabled(false);
        this.findPaneOfTypeByID("friendPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("neutralPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("hostilePage", Button.class).setEnabled(true);
        this.fillPermissionList("officer");
    }

    private void editFriend() {
        this.findPaneOfTypeByID("userGroups", SwitchView.class).setView("friend");
        this.findPaneOfTypeByID("officerPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("friendPage", Button.class).setEnabled(false);
        this.findPaneOfTypeByID("neutralPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("hostilePage", Button.class).setEnabled(true);
        this.fillPermissionList("friend");
    }

    private void editNeutral() {
        this.findPaneOfTypeByID("userGroups", SwitchView.class).setView("neutral");
        this.findPaneOfTypeByID("officerPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("friendPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("neutralPage", Button.class).setEnabled(false);
        this.findPaneOfTypeByID("hostilePage", Button.class).setEnabled(true);
        this.fillPermissionList("neutral");
    }

    private void editHostile() {
        this.findPaneOfTypeByID("userGroups", SwitchView.class).setView("hostile");
        this.findPaneOfTypeByID("officerPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("friendPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("neutralPage", Button.class).setEnabled(true);
        this.findPaneOfTypeByID("hostilePage", Button.class).setEnabled(false);
        this.fillPermissionList("hostile");
    }

    private void createAndSetStatistics() {
        int citizensSize = this.townHall.getColony().getCitizens().size();
        final HashMap<String, Integer> jobCountMap = new HashMap<String, Integer>();
        for (CitizenDataView citizen : this.citizens) {
            String job;
            int length = citizen.getJob().split("\\.").length;
            jobCountMap.put(job, jobCountMap.get(job = citizen.getJob().split("\\.")[length - 1].toLowerCase(Locale.ENGLISH)) == null ? 1 : (Integer)jobCountMap.get(job) + 1);
        }
        DecimalFormat df = new DecimalFormat("#.#");
        df.setRoundingMode(RoundingMode.CEILING);
        String roundedHappiness = df.format(((BuildingTownHall.View)this.building).getColony().getOverallHappiness());
        this.findPaneOfTypeByID("happinessLevel", Label.class).setLabelText(roundedHappiness);
        ScrollingList list = this.findPaneOfTypeByID("citizen-stats", ScrollingList.class);
        if (list == null) {
            return;
        }
        String numberOfCitizens = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.population.totalCitizens", citizensSize, this.townHall.getColony().getCitizenCount());
        this.findPaneOfTypeByID("totalCitizens", Label.class).setLabelText(numberOfCitizens);
        Integer unemployed = jobCountMap.get("") == null ? Integer.valueOf(0) : (Integer)jobCountMap.get("");
        final String numberOfUnemployed = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.population.unemployed", unemployed);
        jobCountMap.remove("");
        final Integer maxJobs = jobCountMap.size();
        final Integer preJobsHeaders = 1;
        list.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return maxJobs + preJobsHeaders;
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                if (jobCountMap.isEmpty()) {
                    return;
                }
                Label label = rowPane.findPaneOfTypeByID("citizensAmount", Label.class);
                if (index == 0) {
                    label.setLabelText(numberOfUnemployed);
                }
                if (index < preJobsHeaders) {
                    return;
                }
                Map.Entry entry = jobCountMap.entrySet().iterator().next();
                String job = (String)entry.getKey();
                String labelJobKey = job.endsWith("man") ? job.replace("man", "men") : job + "s";
                String numberOfWorkers = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.population." + labelJobKey, entry.getValue());
                label.setLabelText(numberOfWorkers);
                jobCountMap.remove(entry.getKey());
            }
        });
    }

    private void fillUserList() {
        this.userList = this.findPaneOfTypeByID("users", ScrollingList.class);
        this.userList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.users.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                Player player = (Player)WindowTownHall.this.users.get(index);
                String rank = player.getRank().name();
                rank = Character.toUpperCase(rank.charAt(0)) + rank.toLowerCase(Locale.ENGLISH).substring(1);
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(player.getName());
                rowPane.findPaneOfTypeByID("rank", Label.class).setLabelText(rank);
            }
        });
    }

    private void fillAlliesAndFeudsList() {
        this.alliesList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.allies.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyView colonyView = (ColonyView)WindowTownHall.this.allies.get(index);
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(colonyView.getName());
                long distance = BlockPosUtil.getDistance2D(colonyView.getCenter(), ((BuildingTownHall.View)WindowTownHall.this.building).getLocation());
                rowPane.findPaneOfTypeByID("dist", Label.class).setLabelText((int)distance + "b");
                Button button = rowPane.findPaneOfTypeByID("tp", Button.class);
                if (WindowTownHall.this.townHall.getBuildingLevel() < 3 || Configurations.gameplay.canPlayerUseColonyTPCommand) {
                    button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.tooLow", new Object[0]));
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
        this.feudsList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.feuds.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyView colonyView = (ColonyView)WindowTownHall.this.feuds.get(index);
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(colonyView.getName());
                long distance = BlockPosUtil.getDistance2D(colonyView.getCenter(), ((BuildingTownHall.View)WindowTownHall.this.building).getLocation());
                rowPane.findPaneOfTypeByID("dist", Label.class).setLabelText(String.valueOf((int)distance));
            }
        });
    }

    private void fillPermEventsList() {
        this.permEventList = this.findPaneOfTypeByID("permeventslist", ScrollingList.class);
        this.permEventList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return ((BuildingTownHall.View)WindowTownHall.this.building).getPermissionEvents().size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                String name;
                PermissionEvent event = ((BuildingTownHall.View)WindowTownHall.this.building).getPermissionEvents().get(index);
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(event.getName() + (event.getId() == null ? " <fake>" : ""));
                rowPane.findPaneOfTypeByID("pos", Label.class).setLabelText(event.getPosition().func_177958_n() + " " + event.getPosition().func_177956_o() + " " + event.getPosition().func_177952_p());
                if (event.getId() == null) {
                    rowPane.findPaneOfTypeByID("addfakeplayer", Button.class).hide();
                }
                if ((name = LanguageHandler.format("com.minecolonies.coremod.permission." + event.getAction().toString().toLowerCase(Locale.US), new Object[0])).contains("com.minecolonies.coremod.permission.")) {
                    Log.getLogger().warn("Didn't work for:" + name);
                    return;
                }
                rowPane.findPaneOfTypeByID("action", Label.class).setLabelText(name);
            }
        });
    }

    private void updateHappiness() {
        HappinessData happiness = ((BuildingTownHall.View)this.building).getColony().getHappinessData();
        String[] imagesIds = new String[]{"guardsLevel", "houseLevel", "saturationLevel"};
        int[] levels = new int[]{happiness.getGuards(), happiness.getHousing(), happiness.getSaturation()};
        block5: for (int i = 0; i < imagesIds.length; ++i) {
            Image image = this.findPaneOfTypeByID(imagesIds[i], Image.class);
            switch (levels[i]) {
                case 1: {
                    image.setImage("minecolonies:textures/gui/green_icon.png");
                    continue block5;
                }
                case 0: {
                    image.setImage("minecolonies:textures/gui/yellow_icon.png");
                    continue block5;
                }
                case -1: {
                    image.setImage("minecolonies:textures/gui/red_icon.png");
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(imagesIds[i] + "isn't in [" + 1 + "," + 0 + "," + -1 + "] range.");
                }
            }
        }
    }

    private void updatePriority(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(5);
        int id = Integer.parseInt(idLabel.getLabelText());
        String buttonLabel = button.getID();
        for (int i = 0; i < this.workOrders.size(); ++i) {
            WorkOrderView workOrder = this.workOrders.get(i);
            if (workOrder.getId() != id) continue;
            if (buttonLabel.equals("plus") && i > 0) {
                workOrder.setPriority(this.workOrders.get(i - 1).getPriority() + 1);
                MineColonies.getNetwork().sendToServer((IMessage)new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            } else if (buttonLabel.equals("minus") && i <= this.workOrders.size()) {
                workOrder.setPriority(this.workOrders.get(i + 1).getPriority() - 1);
                MineColonies.getNetwork().sendToServer((IMessage)new WorkOrderChangeMessage(this.building, id, false, workOrder.getPriority()));
            }
            this.sortWorkOrders();
            this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class).refreshElementPanes();
            return;
        }
    }

    private void deleteWorkOrder(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(5);
        int id = Integer.parseInt(idLabel.getLabelText());
        for (int i = 0; i < this.workOrders.size(); ++i) {
            if (this.workOrders.get(i).getId() != id) continue;
            this.workOrders.remove(i);
            break;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new WorkOrderChangeMessage(this.building, id, true, 0));
        this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class).refreshElementPanes();
    }

    private void fillCitizenInfo(Button button) {
        ScrollingList citizenList = this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        for (Pane pane : citizenList.getContainer().getChildren()) {
            pane.findPaneOfTypeByID("name", ButtonImage.class).enable();
        }
        int row = citizenList.getListElementIndexByPane(button);
        this.findPaneByID("citizenInfoBox").show();
        button.disable();
        CitizenDataView view = this.citizens.get(row);
        WindowCitizen.createXpBar(view, this);
        WindowCitizen.createHappinessBar(view, this);
        WindowCitizen.createSkillContent(view, this);
        this.findPaneOfTypeByID("job", Label.class).setLabelText("\u00a7l" + LanguageHandler.format(view.getJob().trim().isEmpty() ? "com.minecolonies.coremod.gui.townHall.citizens.unemployed" : view.getJob(), new Object[0]));
        this.findPaneOfTypeByID("hiddenCitizenId", Label.class).setLabelText(String.valueOf(view.getId()));
    }

    private void recallOneClicked(Button button) {
        String citizenidLabel = button.getParent().findPaneOfTypeByID("hiddenCitizenId", Label.class).getLabelText();
        int citizenid = Integer.parseInt(citizenidLabel);
        MineColonies.getNetwork().sendToServer((IMessage)new RecallSingleCitizenMessage(this.townHall, citizenid));
    }

    private void fillCitizensList() {
        ScrollingList citizenList = this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.citizens.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                CitizenDataView citizen = (CitizenDataView)WindowTownHall.this.citizens.get(index);
                rowPane.findPaneOfTypeByID("name", ButtonImage.class).setLabel(citizen.getName());
            }
        });
    }

    private void fillWorkOrderList() {
        ScrollingList workOrderList = this.findPaneOfTypeByID("workOrderList", ScrollingList.class);
        workOrderList.enable();
        workOrderList.show();
        workOrderList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowTownHall.this.workOrders.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                WorkOrderView workOrder = (WorkOrderView)WindowTownHall.this.workOrders.get(index);
                String claimingCitizen = "";
                int numElements = this.getElementCount();
                if (index == 0) {
                    if (numElements == 1) {
                        rowPane.findPaneOfTypeByID("minus", Button.class).hide();
                    } else {
                        rowPane.findPaneOfTypeByID("minus", Button.class).show();
                    }
                    rowPane.findPaneOfTypeByID("plus", Button.class).hide();
                } else if (index == numElements - 1) {
                    rowPane.findPaneOfTypeByID("minus", Button.class).hide();
                }
                for (AbstractBuildingView buildingView : ((BuildingTownHall.View)WindowTownHall.this.building).getColony().getBuildings()) {
                    if (!buildingView.getLocation().equals((Object)workOrder.getClaimedBy()) || !(buildingView instanceof AbstractBuildingBuilderView)) continue;
                    claimingCitizen = ((AbstractBuildingBuilderView)buildingView).getWorkerName();
                    break;
                }
                rowPane.findPaneOfTypeByID("work", Label.class).setLabelText(workOrder.getValue());
                rowPane.findPaneOfTypeByID("assignee", Label.class).setLabelText(claimingCitizen);
                rowPane.findPaneOfTypeByID("hiddenId", Label.class).setLabelText(Integer.toString(workOrder.getId()));
            }
        });
    }

    private void toggleHiring(@NotNull Button button) {
        boolean toggle;
        if (button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]))) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
            toggle = true;
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]));
            toggle = false;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new ToggleJobMessage(((BuildingTownHall.View)this.building).getColony(), toggle));
    }

    private void toggleHousing(@NotNull Button button) {
        boolean toggle;
        if (button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]))) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.on", new Object[0]));
            toggle = true;
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.hiring.off", new Object[0]));
            toggle = false;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new ToggleHousingMessage(((BuildingTownHall.View)this.building).getColony(), toggle));
    }

    private void toggleMoveIn(@NotNull Button button) {
        boolean toggle;
        if (button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.off", new Object[0]))) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.on", new Object[0]));
            toggle = true;
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.off", new Object[0]));
            toggle = false;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new ToggleMoveInMessage(((BuildingTownHall.View)this.building).getColony(), toggle));
    }

    private void togglePrintProgress(@NotNull Button button) {
        if (button.getLabel().equals(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.off", new Object[0]))) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.on", new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.townHall.off", new Object[0]));
        }
        MineColonies.getNetwork().sendToServer((IMessage)new ToggleHelpMessage(((BuildingTownHall.View)this.building).getColony()));
    }

    private void onTabClicked(@NotNull Button button) {
        String oldId = this.lastTabButton.getID();
        String newId = button.getID();
        this.findPaneOfTypeByID("pages", SwitchView.class).setView(this.tabsToPages.get(newId));
        this.findPaneOfTypeByID(oldId + "0", Image.class).show();
        this.findPaneOfTypeByID(oldId + "1", ButtonImage.class).hide();
        this.findPaneOfTypeByID(newId + "0", Image.class).hide();
        this.findPaneOfTypeByID(newId + "1", ButtonImage.class).show();
        this.lastTabButton.on();
        button.off();
        this.lastTabButton = button;
        this.setPage("");
    }

    @Override
    public String getBuildingName() {
        return this.townHall.getColony().getName();
    }

    @Override
    public void onUpdate() {
        String currentPage;
        super.onUpdate();
        switch (currentPage = this.findPaneOfTypeByID("pages", SwitchView.class).getCurrentView().getID()) {
            case "pagePermissions": {
                this.updateUsers();
                this.window.findPaneOfTypeByID("users", ScrollingList.class).refreshElementPanes();
                break;
            }
            case "pageCitizens": {
                this.updateCitizens();
                this.window.findPaneOfTypeByID("citizenList", ScrollingList.class).refreshElementPanes();
                break;
            }
            case "pageHappiness": {
                this.updateHappiness();
                break;
            }
            case "pageWorkOrder": {
                this.updateWorkOrders();
                this.window.findPaneOfTypeByID("workOrderList", ScrollingList.class).refreshElementPanes();
            }
        }
    }

    private void renameClicked() {
        WindowTownHallNameEntry window = new WindowTownHallNameEntry(this.townHall.getColony());
        window.open();
    }

    private void addPlayerCLicked() {
        TextField input = this.findPaneOfTypeByID("addPlayerName", TextField.class);
        MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.AddPlayer(this.townHall.getColony(), input.getText()));
        input.setText("");
    }

    private void removePlayerClicked(Button button) {
        Player user;
        int row = this.userList.getListElementIndexByPane(button);
        if (row >= 0 && row < this.users.size() && (user = this.users.get(row)).getRank() != Rank.OWNER) {
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.RemovePlayer(this.townHall.getColony(), user.getID()));
        }
    }

    private void addPlayerToColonyClicked(@NotNull Button button) {
        int row = this.permEventList.getListElementIndexByPane(button);
        if (row >= 0 && row < ((BuildingTownHall.View)this.building).getPermissionEvents().size()) {
            PermissionEvent user = ((BuildingTownHall.View)this.building).getPermissionEvents().get(row);
            MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.AddPlayerOrFakePlayer(this.townHall.getColony(), user.getName(), user.getId()));
        }
    }

    private void promoteDemoteClicked(@NotNull Button button) {
        int row = this.userList.getListElementIndexByPane(button);
        if (row >= 0 && row < this.users.size()) {
            Player user = this.users.get(row);
            if (button.getID().equals("promote")) {
                MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.ChangePlayerRank(this.townHall.getColony(), user.getID(), PermissionsMessage.ChangePlayerRank.Type.PROMOTE));
            } else {
                MineColonies.getNetwork().sendToServer((IMessage)new PermissionsMessage.ChangePlayerRank(this.townHall.getColony(), user.getID(), PermissionsMessage.ChangePlayerRank.Type.DEMOTE));
            }
        }
    }

    private void recallClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new RecallTownhallMessage(this.townHall));
    }

    private void hireClicked() {
        WindowTownHallHireCitizen window = new WindowTownHallHireCitizen(this.townHall.getColony());
        window.open();
    }

    @Override
    public void setPage(@NotNull String button) {
        String curSwitch = this.lastTabButton == null ? this.findPaneOfTypeByID("actions", Button.class).getID() : this.lastTabButton.getID();
        this.switchView = this.findPaneOfTypeByID("switch" + this.tabsToPages.get(curSwitch), SwitchView.class);
        this.pageNum.on();
        super.setPage(button);
        if (this.switchView.getCurrentView().getID().equals("managePermissions")) {
            this.editOfficer();
        }
    }
}

