/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowFilterableList;
import com.minecolonies.coremod.client.gui.WindowTownHall;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.network.messages.LumberjackReplantSaplingToggleMessage;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutLumberjack
extends WindowFilterableList<BuildingLumberjack.View> {
    private static final String BUTTON_TOGGLE_REPLANT = "saplingReplant";
    private static final String PAGE_ITEMS_VIEW = "pageItems";
    private final BuildingLumberjack.View ownBuilding;

    public WindowHutLumberjack(BuildingLumberjack.View building) {
        super(building, stack -> true, LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.saplingList", new Object[0]));
        this.ownBuilding = building;
    }

    @Override
    public Collection<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate) {
        return ColonyManager.getCompatibilityManager().getCopyOfSaplings().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ButtonImage button = new ButtonImage();
        button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium.png"));
        button.setPosition(50, 193);
        button.setSize(86, 17);
        button.setID(BUTTON_TOGGLE_REPLANT);
        button.setTextColor(WindowTownHall.BLACK);
        this.setupReplantButton(button);
        this.findPaneOfTypeByID(PAGE_ITEMS_VIEW, View.class).addChild(button);
        this.registerButton(BUTTON_TOGGLE_REPLANT, this::switchReplant);
        this.isInverted = true;
    }

    private void setupReplantButton(Button button) {
        if (this.ownBuilding.shouldReplant) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOn", new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOff", new Object[0]));
        }
    }

    private void switchReplant(Button replant) {
        this.ownBuilding.shouldReplant = !this.ownBuilding.shouldReplant;
        this.setupReplantButton(replant);
        MineColonies.getNetwork().sendToServer((IMessage)new LumberjackReplantSaplingToggleMessage(this.ownBuilding, this.ownBuilding.shouldReplant));
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.job.Lumberjack";
    }
}

