/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCrusher;
import net.minecraft.init.Blocks;
import org.jetbrains.annotations.NotNull;

public class WindowHutCrusher
extends AbstractWindowWorkerBuilding<BuildingCrusher.View> {
    private static final String BLOCK_BUTTON = "block";
    private static final String BUTTON_SAVE = "save";
    private static final String QTY_INPUT = "qty";
    private static final String CRUSHER_RESOURCE_SUFFIX = ":gui/windowhutcrusher.xml";
    private BuildingCrusher.CrusherMode mode;

    public WindowHutCrusher(BuildingCrusher.View building) {
        super(building, "minecolonies:gui/windowhutcrusher.xml");
        Button crushingSettingsButton = this.findPaneOfTypeByID(BLOCK_BUTTON, Button.class);
        TextField crushingSettingsInput = this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        this.registerButton(BLOCK_BUTTON, this::switchCrushingMode);
        this.registerButton(BUTTON_SAVE, this::saveCrushingMode);
        this.mode = (BuildingCrusher.CrusherMode)((Object)building.getCrusherMode().func_76341_a());
        crushingSettingsInput.setText(((Integer)building.getCrusherMode().func_76340_b()).toString());
        this.setupSettings(crushingSettingsButton);
    }

    private void saveCrushingMode() {
        TextField crushingSettingsInput = this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        try {
            int qty = Integer.parseInt(crushingSettingsInput.getText());
            ((BuildingCrusher.View)this.building).setCrusherMode(this.mode, qty);
        }
        catch (NumberFormatException ex) {
            Log.getLogger().warn("Wrong input!");
        }
    }

    private void switchCrushingMode(Button crushingSettingsButton) {
        this.mode = crushingSettingsButton.getLabel().equals(Blocks.field_150351_n.func_149732_F()) ? BuildingCrusher.CrusherMode.SAND : (crushingSettingsButton.getLabel().equals(Blocks.field_150354_m.func_149732_F()) ? BuildingCrusher.CrusherMode.CLAY : BuildingCrusher.CrusherMode.GRAVEL);
        this.setupSettings(crushingSettingsButton);
    }

    private void setupSettings(Button crushingSettingsButton) {
        if (this.mode == BuildingCrusher.CrusherMode.GRAVEL) {
            crushingSettingsButton.setLabel(Blocks.field_150351_n.func_149732_F());
        } else if (this.mode == BuildingCrusher.CrusherMode.SAND) {
            crushingSettingsButton.setLabel(Blocks.field_150354_m.func_149732_F());
        } else {
            crushingSettingsButton.setLabel(Blocks.field_150435_aG.func_149732_F());
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.Crusher";
    }
}

