/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowFilterableList;
import com.minecolonies.coremod.client.gui.WindowTownHall;
import com.minecolonies.coremod.colony.ColonyManager;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingComposter;
import com.minecolonies.coremod.items.ModItems;
import com.minecolonies.coremod.network.messages.ComposterRetrievalMessage;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WindowHutComposter
extends WindowFilterableList<BuildingComposter.View> {
    private static final String BUTTON_TOGGLE_RETRIEVE_DIRT = "retrieveDirt";
    private static final String PAGE_ITEMS_VIEW = "pageItems";

    public WindowHutComposter(BuildingComposter.View building) {
        super(building, stack -> true, LanguageHandler.format("com.minecolonies.gui.workerHuts.composter.compostables", new Object[0]));
    }

    @Override
    public Collection<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate) {
        return ColonyManager.getCompatibilityManager().getCopyOfCompostableItems().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList());
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ButtonImage button = new ButtonImage();
        button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium.png"));
        button.setPosition(50, 193);
        button.setSize(86, 17);
        button.setID(BUTTON_TOGGLE_RETRIEVE_DIRT);
        button.setTextColor(WindowTownHall.BLACK);
        this.setupRetrieveDirtButton(button);
        this.findPaneOfTypeByID(PAGE_ITEMS_VIEW, View.class).addChild(button);
        this.registerButton(BUTTON_TOGGLE_RETRIEVE_DIRT, this::switchReplant);
    }

    private void setupRetrieveDirtButton(Button button) {
        if (((BuildingComposter.View)this.building).retrieveDirtFromCompostBin) {
            button.setLabel(LanguageHandler.format(Blocks.field_150346_d.func_149732_F(), new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format(ModItems.compost.func_77653_i(new ItemStack(ModItems.compost)), new Object[0]));
        }
    }

    private void switchReplant(Button retrieve) {
        BuildingComposter.View composter = (BuildingComposter.View)this.building;
        composter.retrieveDirtFromCompostBin = !composter.retrieveDirtFromCompostBin;
        this.setupRetrieveDirtButton(retrieve);
        MineColonies.getNetwork().sendToServer((IMessage)new ComposterRetrievalMessage(composter, composter.retrieveDirtFromCompostBin));
    }

    @Override
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.composter";
    }
}

