/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructurePlacementUtils;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.blockout.Color;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.DropDownList;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowMoveBuilding;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructure;
import com.minecolonies.coremod.network.messages.BuildRequestMessage;
import com.minecolonies.coremod.network.messages.BuildingSetStyleMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildBuilding
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowbuildbuilding.xml";
    private final AbstractBuildingView building;
    private final Map<String, ItemStorage> resources = new HashMap<String, ItemStorage>();
    private DropDownList stylesDropDownList;
    private DropDownList buildersDropDownList;
    private static final int WHITE = Color.getByName("white", 0);
    @NotNull
    private List<String> styles = new ArrayList<String>();
    @NotNull
    private List<Tuple<String, BlockPos>> builders = new ArrayList<Tuple<String, BlockPos>>();

    public WindowBuildBuilding(ColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowbuildbuilding.xml");
        this.building = c.getBuilding(buildingId);
        this.initStyleNavigation();
        this.registerButton("build", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("reposition", this::moveBuildingClicked);
        Button buttonBuild = this.findPaneOfTypeByID("build", Button.class);
        if (this.building.getBuildingLevel() == 0) {
            buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.build", new Object[0]));
            this.findPaneOfTypeByID("reposition", Button.class).hide();
        } else if (this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) {
            buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.switchStyle", new Object[0]));
        } else {
            buttonBuild.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.upgrade", new Object[0]));
        }
    }

    private void moveBuildingClicked() {
        WindowMoveBuilding window = new WindowMoveBuilding(this.building.getLocation(), this.building, this.styles.get(this.stylesDropDownList.getSelectedIndex()));
        window.open();
    }

    private void cancelClicked() {
        this.building.openGui(false);
    }

    private void confirmClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.field_177992_a : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).func_76340_b();
        MineColonies.getNetwork().sendToServer((IMessage)new BuildingSetStyleMessage(this.building, this.styles.get(this.stylesDropDownList.getSelectedIndex())));
        if (this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage(this.building, 1, builder));
        } else {
            MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage(this.building, 0, builder));
        }
        this.cancelClicked();
    }

    private void repairClicked() {
        BlockPos builder = this.buildersDropDownList.getSelectedIndex() == 0 ? BlockPos.field_177992_a : (BlockPos)this.builders.get(this.buildersDropDownList.getSelectedIndex()).func_76340_b();
        MineColonies.getNetwork().sendToServer((IMessage)new BuildRequestMessage(this.building, 1, builder));
        this.cancelClicked();
    }

    private void updateBuilders() {
        this.builders.clear();
        this.builders.add((Tuple<String, BlockPos>)new Tuple((Object)(LanguageHandler.format("com.minecolonies.coremod.job.Builder", new Object[0]) + ":"), (Object)BlockPos.field_177992_a));
        this.builders.addAll(this.building.getColony().getBuildings().stream().filter(build -> build instanceof AbstractBuildingBuilderView && !((AbstractBuildingBuilderView)build).getWorkerName().isEmpty() && !(build instanceof BuildingMiner.View)).map(build -> new Tuple((Object)((AbstractBuildingBuilderView)build).getWorkerName(), (Object)build.getLocation())).collect(Collectors.toList()));
        this.initBuilderNavigation();
    }

    private void updateStyles() {
        this.styles = Structures.getStylesFor((String)this.building.getSchematicName());
        int newIndex = this.styles.indexOf(this.building.getStyle());
        if (newIndex == -1) {
            newIndex = 0;
        }
        boolean enabled = Settings.instance.isStaticSchematicMode() ? false : this.styles.size() > 1;
        this.findPaneOfTypeByID("previousStyle", Button.class).setEnabled(enabled);
        this.findPaneOfTypeByID("style", DropDownList.class).setEnabled(enabled);
        this.findPaneOfTypeByID("nextStyle", Button.class).setEnabled(enabled);
        this.stylesDropDownList.setSelectedIndex(newIndex);
    }

    private void updateResources() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        this.resources.clear();
        int nextLevel = this.building.getBuildingLevel() == this.building.getBuildingMaxLevel() ? this.building.getBuildingMaxLevel() : this.building.getBuildingLevel() + 1;
        StructureName sn = new StructureName("schematics", this.styles.get(this.stylesDropDownList.getSelectedIndex()), this.building.getSchematicName() + nextLevel);
        Structure structure = new Structure((World)world, sn.toString(), new PlacementSettings());
        String md5 = Structures.getMD5((String)sn.toString());
        if (structure.isBluePrintMissing() || !structure.isCorrectMD5(md5)) {
            if (structure.isBluePrintMissing()) {
                Log.getLogger().info("Template structure " + sn + " missing");
            } else {
                Log.getLogger().info("structure " + sn + " md5 error");
            }
            Log.getLogger().info("Request To Server for structure " + sn);
            if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                Structurize.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(sn.toString()));
                return;
            }
            Log.getLogger().error("WindowMinecoloniesBuildTool: Need to download schematic on a standalone client/server. This should never happen");
        }
        structure.setPosition(this.building.getLocation());
        structure.rotate(BlockPosUtil.getRotationFromRotations(this.building.getRotation()), (World)world, this.building.getLocation(), this.building.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE);
        while (structure.findNextBlock()) {
            IBlockState blockState;
            BlockInfo blockInfo = structure.getBlockInfo();
            NBTTagCompound entityInfo = structure.getEntityData();
            if (entityInfo != null) {
                for (ItemStorage stack : ItemStackUtils.getListOfStackForEntityInfo(entityInfo, (World)world, (Entity)Minecraft.func_71410_x().field_71439_g)) {
                    if (ItemStackUtils.isEmpty(stack.getItemStack()).booleanValue()) continue;
                    this.addNeededResource(stack.getItemStack(), 1);
                }
            }
            if ((blockState = blockInfo.getState()) == null) continue;
            Block block = blockState.func_177230_c();
            if (StructurePlacementUtils.isStructureBlockEqualWorldBlock((World)world, (BlockPos)structure.getBlockPosition(), (IBlockState)blockState) || blockState.func_177230_c() instanceof BlockBed && ((BlockBed.EnumPartType)blockState.func_177229_b((IProperty)BlockBed.field_176472_a)).equals((Object)BlockBed.EnumPartType.FOOT) || blockState.func_177230_c() instanceof BlockDoor && ((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER) || block == Blocks.field_150350_a || AbstractEntityAIStructure.isBlockFree(block, 0) || block == ModBlocks.blockSolidSubstitution || block == ModBlocks.blockSubstitution) continue;
            if (structure.getBlockInfo().getTileEntityData() != null) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                if (structure.getBlockInfo().getState() != null && structure.getBlockInfo().getTileEntityData() != null) {
                    itemList.addAll(ItemStackUtils.getItemStacksOfTileEntity(structure.getBlockInfo().getTileEntityData(), (World)world));
                }
                for (ItemStack stack : itemList) {
                    this.addNeededResource(stack, 1);
                }
            }
            this.addNeededResource(BlockUtils.getItemStackFromBlockState(blockState), 1);
        }
        this.window.findPaneOfTypeByID("resources", ScrollingList.class).refreshElementPanes();
        this.updateResourceList();
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        ItemStorage resource = this.resources.get(res.func_77977_a());
        if (resource == null) {
            resource = new ItemStorage(res);
            resource.setAmount(amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.resources.put(res.func_77977_a(), resource);
    }

    private void initStyleNavigation() {
        this.registerButton("previousStyle", this::previousStyle);
        this.registerButton("nextStyle", this::nextStyle);
        this.stylesDropDownList = this.findPaneOfTypeByID("style", DropDownList.class);
        this.stylesDropDownList.setHandler(this::onStyleDropDownChanged);
        this.stylesDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowBuildBuilding.this.styles.size();
            }

            @Override
            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildBuilding.this.styles.size()) {
                    return (String)WindowBuildBuilding.this.styles.get(index);
                }
                return "";
            }
        });
    }

    private void initBuilderNavigation() {
        this.buildersDropDownList = this.findPaneOfTypeByID("worker", DropDownList.class);
        this.buildersDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowBuildBuilding.this.builders.size();
            }

            @Override
            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildBuilding.this.builders.size()) {
                    return (String)((Tuple)WindowBuildBuilding.this.builders.get(index)).func_76341_a();
                }
                return "";
            }
        });
        this.buildersDropDownList.setSelectedIndex(0);
    }

    private void onStyleDropDownChanged(DropDownList list) {
        this.updateResources();
    }

    private void nextStyle() {
        this.stylesDropDownList.selectNext();
    }

    private void previousStyle() {
        this.stylesDropDownList.selectPrevious();
    }

    @Override
    public void onOpened() {
        this.updateStyles();
        this.updateBuilders();
        this.updateResources();
    }

    public void updateResourceList() {
        ScrollingList recourseList = this.findPaneOfTypeByID("resources", ScrollingList.class);
        recourseList.enable();
        recourseList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.resources.values());
        recourseList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return tempRes.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = (ItemStorage)tempRes.get(index);
                Label resourceLabel = rowPane.findPaneOfTypeByID("resourceName", Label.class);
                Label quantityLabel = rowPane.findPaneOfTypeByID("resourceQuantity", Label.class);
                resourceLabel.setLabelText(resource.getItemStack().func_82833_r());
                quantityLabel.setLabelText(Integer.toString(resource.getAmount()));
                resourceLabel.setColor(WHITE, WHITE);
                quantityLabel.setColor(WHITE, WHITE);
                rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class).setItem(new ItemStack(resource.getItem(), 1, resource.getDamageValue()));
            }
        });
    }
}

