/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.crafting.irecipies;

import com.teamwizardry.librarianlib.features.helpers.ItemNBTHelper;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItem;
import com.teamwizardry.wizardry.api.item.halo.HaloInfusionItemRegistry;
import com.teamwizardry.wizardry.init.ModItems;
import java.util.ArrayDeque;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeCrudeHaloInfusion
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
        ItemStack foundHalo = ItemStack.field_190927_a;
        boolean foundGlueStick = false;
        int availableItems = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() == Items.field_151123_aH) {
                if (foundGlueStick) {
                    return false;
                }
                foundGlueStick = true;
                continue;
            }
            if (stack.func_77973_b() == ModItems.FAKE_HALO) {
                if (!foundHalo.func_190926_b()) {
                    return false;
                }
                foundHalo = stack;
                continue;
            }
            if (HaloInfusionItemRegistry.isHaloInfusionItem(stack)) {
                ++availableItems;
                continue;
            }
            if (stack.func_190926_b()) continue;
            return false;
        }
        if (!foundGlueStick || foundHalo.func_190926_b() || availableItems <= 0) {
            return false;
        }
        NBTTagList slots = ItemNBTHelper.getList((ItemStack)foundHalo, (String)"slots", NBTTagString.class);
        if (slots == null) {
            return availableItems <= 7;
        }
        int freeSlots = 0;
        for (int j = 0; j < slots.func_74745_c() && freeSlots < 7; ++j) {
            String string = slots.func_150307_f(j);
            HaloInfusionItem infusionItem = HaloInfusionItemRegistry.getItemFromName(string);
            if (infusionItem != HaloInfusionItemRegistry.EMPTY) continue;
            ++freeSlots;
        }
        return freeSlots >= availableItems;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        ItemStack foundHalo = ItemStack.field_190927_a;
        ItemStack foundGlueStick = ItemStack.field_190927_a;
        ArrayDeque<HaloInfusionItem> infusionItems = new ArrayDeque<HaloInfusionItem>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() == Items.field_151123_aH) {
                foundGlueStick = stack;
                continue;
            }
            if (stack.func_77973_b() == ModItems.FAKE_HALO) {
                foundHalo = stack;
                continue;
            }
            if (!HaloInfusionItemRegistry.isHaloInfusionItem(stack)) continue;
            infusionItems.add(HaloInfusionItemRegistry.getInfusionItemFromStack(stack));
        }
        if (foundHalo.func_190926_b() || foundGlueStick.func_190926_b() || infusionItems.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        NBTTagList slots = ItemNBTHelper.getList((ItemStack)foundHalo, (String)"slots", NBTTagString.class);
        if (slots == null) {
            slots = new NBTTagList();
            for (int i = 0; i < 7; ++i) {
                slots.func_74742_a((NBTBase)new NBTTagString(HaloInfusionItemRegistry.EMPTY.getNbtName()));
            }
        } else {
            slots = slots.func_74737_b();
        }
        int count = slots.func_74745_c();
        for (int i = 0; i < count && !infusionItems.isEmpty(); ++i) {
            String string = slots.func_150307_f(i);
            HaloInfusionItem infusionItem = HaloInfusionItemRegistry.getItemFromName(string);
            if (infusionItem != HaloInfusionItemRegistry.EMPTY) continue;
            slots.func_150304_a(i, (NBTBase)new NBTTagString(((HaloInfusionItem)infusionItems.pop()).getNbtName()));
        }
        ItemStack haloCopy = foundHalo.func_77946_l();
        ItemNBTHelper.setList((ItemStack)haloCopy, (String)"slots", (NBTTagList)slots);
        return haloCopy;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
        NonNullList remainingItems = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151123_aH) continue;
            ItemStack gluestick = stack.func_77946_l();
            remainingItems.set(i, (Object)gluestick);
            break;
        }
        return remainingItems;
    }
}

