/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.potion;

import com.teamwizardry.wizardry.common.potion.PotionBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PotionCrash
extends PotionBase {
    public PotionCrash() {
        super("crash", false, 9201679);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public DamageSource damageSourceEarthquake(EntityLivingBase player) {
        return new EntityDamageSource("wizardry.crash", (Entity)player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void fall(LivingFallEvent e) {
        EntityLivingBase entitySource = e.getEntityLiving();
        PotionEffect crash = entitySource.func_70660_b((Potion)this);
        if (crash == null) {
            return;
        }
        PotionEffect jump = entitySource.func_70660_b(MobEffects.field_76430_j);
        float f = jump == null ? 0.0f : (float)(jump.func_76458_c() + 1);
        float damage = MathHelper.func_76131_a((float)((e.getDistance() - 3.0f - f) * e.getDamageMultiplier() * 2.0f), (float)0.0f, (float)10.0f);
        float range = damage / 10.0f + (float)Math.max(crash.func_76458_c(), 5);
        if (damage > 0.0f) {
            e.setDamageMultiplier(e.getDamageMultiplier() / (float)(crash.func_76458_c() + 2));
            List entities = entitySource.field_70170_p.func_72872_a(EntityLivingBase.class, entitySource.func_174813_aQ().func_186662_g((double)(range * 2.0f)));
            entities.stream().filter(entity -> entity != entitySource && entity.field_70122_E).forEach(entity -> {
                entity.func_70097_a(this.damageSourceEarthquake(entitySource), range);
                entity.field_70181_x = (double)range / 10.0;
                entity.field_70133_I = true;
            });
            if (!entitySource.field_70170_p.field_72995_K) {
                for (BlockPos pos : BlockPos.func_177975_b((BlockPos)new BlockPos(entitySource.func_174791_d()).func_177963_a((double)(-range), -2.0, (double)(-range)), (BlockPos)new BlockPos(entitySource.func_174791_d()).func_177963_a((double)range, 0.0, (double)range))) {
                    IBlockState state = entitySource.field_70170_p.func_180495_p(pos);
                    if (!state.func_185917_h()) continue;
                    entitySource.field_70170_p.func_175718_b(2001, pos.func_185334_h(), Block.func_176210_f((IBlockState)state));
                }
            }
        }
    }
}

