/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_thrive")
public class ModuleEffectThrive
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        BlockPos targetPos = spell.getTargetPos();
        Entity targetEntity = spell.getVictim();
        Entity caster = spell.getCaster();
        Vec3d pos = spell.getTarget();
        if (pos != null) {
            spell.world.func_184133_a(null, new BlockPos(pos), (SoundEvent)ModSounds.HEAL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        if (targetEntity instanceof EntityLivingBase) {
            double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell) / 2.0;
            if (!spellRing.taxCaster(spell, true)) {
                return false;
            }
            ((EntityLivingBase)targetEntity).func_70691_i((float)potency);
        }
        if (targetPos != null) {
            if (world.func_180495_p(targetPos).func_177230_c() instanceof IGrowable) {
                if (!spellRing.taxCaster(spell, true)) {
                    return false;
                }
                if (caster == null || caster instanceof EntityPlayer && BlockUtils.hasEditPermission(targetPos, (EntityPlayerMP)caster)) {
                    ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR), (World)world, (BlockPos)targetPos);
                }
            } else if (world.func_180495_p(targetPos).func_177230_c() instanceof IPlantable) {
                IBlockState state = world.func_180495_p(targetPos);
                Block block = state.func_177230_c();
                if (!spellRing.taxCaster(spell, true)) {
                    return false;
                }
                if (caster == null || caster instanceof EntityPlayer && BlockUtils.hasEditPermission(targetPos, (EntityPlayerMP)caster)) {
                    while (world.func_180495_p(targetPos.func_177984_a()).func_177230_c() == block) {
                        targetPos = targetPos.func_177984_a();
                        state = world.func_180495_p(targetPos);
                        block = state.func_177230_c();
                    }
                    world.func_189507_a(targetPos, state, RandUtil.random);
                }
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        LibParticles.EFFECT_REGENERATE(world, position, instance.getPrimaryColor());
    }
}

