/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpCircle;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_sonic")
public class ModuleEffectSonic
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency", "modifier_increase_aoe"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim();
        Entity caster = spell.getCaster();
        World world = spell.world;
        BlockPos pos = spell.getTargetPos();
        if (pos == null) {
            return false;
        }
        double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell) / 2.0;
        double area = spellRing.getAttributeValue(AttributeRegistry.AREA, spell) / 2.0;
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        if (targetEntity instanceof EntityLivingBase) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(potency + " - " + area);
            world.func_184133_a(null, pos, (SoundEvent)ModSounds.SOUND_BOMB, SoundCategory.NEUTRAL, 1.0f, RandUtil.nextFloat(0.8f, 1.2f));
            this.damageEntity((EntityLivingBase)targetEntity, caster, (float)potency);
            if (((EntityLivingBase)targetEntity).func_110143_aJ() <= 0.0f) {
                Vec3d targetPos = targetEntity.func_174791_d();
                double sqArea = area * area;
                AxisAlignedBB aabb = new AxisAlignedBB(targetEntity.func_180425_c()).func_186662_g(area);
                world.func_72872_a(EntityLivingBase.class, aabb).stream().filter(entity -> entity.func_174791_d().func_72436_e(targetPos) < sqArea).forEach(entity -> this.damageEntity((EntityLivingBase)entity, caster, (float)potency));
            }
        }
        return true;
    }

    private void damageEntity(EntityLivingBase target, Entity caster, float damage) {
        int invTime = target.field_70172_ad;
        target.field_70172_ad = 0;
        if (caster instanceof EntityLivingBase) {
            ((EntityLivingBase)caster).func_130011_c((Entity)target);
            if (caster instanceof EntityPlayer) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)caster)).func_82726_p(), damage);
            } else {
                target.func_70097_a(new DamageSource("generic").func_82726_p(), damage);
            }
        } else {
            target.func_70097_a(new DamageSource("generic").func_82726_p(), damage);
        }
        target.field_70172_ad = invTime;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Entity target = spell.getVictim();
        Vec3d look = spell.getData(SpellData.DefaultKeys.LOOK);
        if (target == null || look == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(30);
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        glitter.setRender(new ResourceLocation("wizardry", "particles/diamond"));
        glitter.setDeceleration(new Vec3d(0.5, 0.5, 0.5));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        glitter.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.01, 0.01), 0.0));
        Vec3d entityOrigin = target.func_174791_d().func_72441_c((double)target.field_70130_N / 2.0, (double)target.field_70131_O / 2.0, (double)target.field_70130_N / 2.0);
        InterpCircle circle = new InterpCircle(Vec3d.field_186680_a, new Vec3d(0.0, 1.0, 0.0), target.field_70130_N);
        double area = spellRing.getAttributeValue(AttributeRegistry.AREA, spell) / 2.0;
        for (Vec3d origin : circle.list(50)) {
            ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)entityOrigin.func_178787_e(origin)), (int)5, (int)0, (aFloat, particleBuilder) -> {
                particleBuilder.setLifetime(RandUtil.nextInt(50, 100));
                particleBuilder.setScale(RandUtil.nextFloat(0.25f, 1.0f));
                particleBuilder.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.1f, 0.5f));
                particleBuilder.setAcceleration(new Vec3d(0.0, RandUtil.nextDouble(-0.01, 0.01), 0.0));
                particleBuilder.setMotion(origin.func_72432_b().func_186678_a(RandUtil.nextDouble(0.0, area / 2.0)));
                particleBuilder.setJitter(1, new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.01, 0.01)));
            });
        }
    }
}

