/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_low_gravity")
public class ModuleEffectLowGravity
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_potency", "modifier_extend_time"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Entity targetEntity = spell.getVictim();
        BlockPos targetPos = spell.getTargetPos();
        Entity caster = spell.getCaster();
        double potency = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell);
        double duration = spellRing.getAttributeValue(AttributeRegistry.DURATION, spell) * 10.0;
        if (!spellRing.taxCaster(spell, true)) {
            return false;
        }
        if (targetEntity != null) {
            spell.world.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.TELEPORT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect((Potion)ModPotions.LOW_GRAVITY, (int)duration, (int)potency, true, false));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(1);
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.enableMotionCalculation();
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)RandUtil.nextInt(5, 15), (int)0, (aFloat, particleBuilder) -> {
            double radius = 2.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setScale(RandUtil.nextFloat());
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-2.0, 2.0), z));
            glitter.setLifetime(RandUtil.nextInt(30, 40));
            Vec3d direction = position.func_178787_e(glitter.getPositionOffset()).func_178788_d(position).func_72432_b();
            glitter.setMotion(direction.func_186678_a(RandUtil.nextDouble(0.5, 1.3)));
        });
    }
}

