/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.math.interpolate.position.InterpHelix;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.particle.functions.InterpColorHSV;
import com.teamwizardry.wizardry.api.spell.ILingeringModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@RegisterModule(ID="effect_anti_gravity_well")
public class ModuleEffectAntiGravityWell
implements IModuleEffect,
ILingeringModule {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_increase_potency", "modifier_extend_time"};
    }

    @Override
    public boolean run(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        World world = spell.world;
        Vec3d position = spell.getTarget();
        if (position == null) {
            return false;
        }
        double area = spellRing.getAttributeValue(AttributeRegistry.AREA, spell);
        for (Entity entity : world.func_72839_b(null, new AxisAlignedBB(new BlockPos(position)).func_72314_b(area, area, area))) {
            double dist;
            if (entity == null || (dist = entity.func_174791_d().func_72438_d(position)) < 2.0 || dist > area) continue;
            if (!spellRing.taxCaster(spell, false)) {
                return false;
            }
            double upperMag = spellRing.getAttributeValue(AttributeRegistry.POTENCY, spell) / 50.0;
            double scale = 1.5;
            double mag = upperMag * (1.5 * dist / (-1.5 * dist - 1.0) + 1.0);
            Vec3d dir = position.func_178788_d(entity.func_174791_d()).func_72432_b().func_186678_a(-mag);
            entity.field_70159_w += dir.field_72450_a;
            entity.field_70181_x += dir.field_72448_b;
            entity.field_70179_y += dir.field_72449_c;
            entity.field_70143_R = 0.0f;
            entity.field_70133_I = true;
            spell.addData(SpellData.DefaultKeys.ENTITY_HIT, entity);
            if (!(entity instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getData(SpellData.DefaultKeys.ORIGIN);
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(0);
        glitter.setColorFunction((InterpFunction)new InterpColorHSV(instance.getPrimaryColor(), instance.getSecondaryColor()));
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)spell.world, (InterpFunction)new StaticInterp((Object)position), (int)10, (int)10, (aFloat, particleBuilder) -> {
            glitter.setScale((float)RandUtil.nextDouble(0.3, 1.0));
            glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.3f, (float)RandUtil.nextDouble(0.6, 1.0)));
            glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
            glitter.setLifetime(RandUtil.nextInt(20, 40));
            glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
            if (RandUtil.nextBoolean()) {
                glitter.setPositionFunction((InterpFunction)new InterpHelix(new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 2.0, 0.0), 0.5f, 0.0f, 1.0f, RandUtil.nextFloat()));
            } else {
                glitter.setPositionFunction((InterpFunction)new InterpHelix(new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, -2.0, 0.0), 0.5f, 0.0f, 1.0f, RandUtil.nextFloat()));
            }
        });
    }

    @Override
    public int getLingeringTime(SpellData spell, SpellRing spellRing) {
        return (int)(spellRing.getAttributeValue(AttributeRegistry.DURATION, spell) * 10.0);
    }
}

