/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorld;
import com.teamwizardry.wizardry.api.capability.world.WizardryWorldCapability;
import com.teamwizardry.wizardry.api.spell.IDelayedModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.SpellRingCache;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.common.network.PacketSyncWizardryWorld;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="wizardry")
public class SpellTicker {
    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        WizardryWorld cap = WizardryWorldCapability.get(event.player.field_70170_p);
        if (cap == null) {
            return;
        }
        PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld((NBTTagCompound)cap.serializeNBT()), event.player.field_70170_p.field_73011_w.getDimension());
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        World world = event.world;
        WizardryWorld worldCap = WizardryWorldCapability.get(world);
        if (worldCap == null) {
            return;
        }
        if (worldCap.getLingeringObjects() == null) {
            return;
        }
        boolean change = false;
        Iterator<LingeringObject> lingering = worldCap.getLingeringObjects().iterator();
        while (lingering.hasNext()) {
            LingeringObject lingeringObject = lingering.next();
            if (lingeringObject == null) continue;
            long fromWorldTime = lingeringObject.getWorldTime();
            long currentWorldTime = event.world.func_82737_E();
            long subtract = currentWorldTime - fromWorldTime;
            if (subtract > (long)lingeringObject.getExpiry()) {
                lingering.remove();
                change = true;
                continue;
            }
            lingeringObject.getSpellRing().runSpellRing(lingeringObject.getSpellData().copy());
        }
        Iterator<DelayedObject> delayed = worldCap.getDelayedObjects().iterator();
        while (delayed.hasNext()) {
            DelayedObject delayedObject = delayed.next();
            long fromWorldTime = delayedObject.getWorldTime();
            long currentWorldTime = event.world.func_82737_E();
            long subtract = currentWorldTime - fromWorldTime;
            if (subtract <= (long)delayedObject.getExpiry()) continue;
            ((IDelayedModule)((Object)delayedObject.getModule().getModuleClass())).runDelayedEffect(delayedObject.getSpellData(), delayedObject.getSpellRing());
            delayed.remove();
            change = true;
        }
        if (change) {
            PacketHandler.NETWORK.sendToDimension((IMessage)new PacketSyncWizardryWorld((NBTTagCompound)worldCap.serializeNBT()), world.field_73011_w.getDimension());
        }
    }

    public static class DelayedObject
    implements INBTSerializable<NBTTagCompound> {
        private ModuleInstance module;
        private SpellRing spellRing;
        private SpellData spellData;
        private long worldTime;
        private int expiry;
        @NotNull
        private final World world;

        public DelayedObject(ModuleInstance module, SpellRing spellRing, SpellData spellData, long worldTime, int expiry) {
            this.module = module;
            this.spellRing = spellRing;
            this.spellData = spellData;
            this.worldTime = worldTime;
            this.expiry = expiry;
            this.world = spellData.world;
        }

        private DelayedObject(@NotNull World world) {
            this.world = world;
        }

        public SpellRing getSpellRing() {
            return this.spellRing;
        }

        public SpellData getSpellData() {
            return this.spellData;
        }

        public long getWorldTime() {
            return this.worldTime;
        }

        public int getExpiry() {
            return this.expiry;
        }

        public static DelayedObject deserialize(World world, NBTTagCompound compound) {
            DelayedObject object = new DelayedObject(world);
            object.deserializeNBT(compound);
            return object;
        }

        public ModuleInstance getModule() {
            return this.module;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.spellRing != null) {
                compound.func_74782_a("spell_ring", (NBTBase)this.spellRing.serializeNBT());
            }
            if (this.spellData != null) {
                compound.func_74782_a("spell_data", (NBTBase)this.spellData.serializeNBT());
            }
            compound.func_74772_a("world_time", this.worldTime);
            compound.func_74768_a("expiry", this.expiry);
            if (this.module != null) {
                compound.func_74782_a("module", (NBTBase)this.module.serialize());
            }
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("spell_ring")) {
                this.spellRing = SpellRingCache.INSTANCE.getSpellRingByNBT(nbt.func_74775_l("spell_ring"));
            }
            if (nbt.func_74764_b("spell_data")) {
                this.spellData = SpellData.deserializeData(this.world, nbt.func_74775_l("spell_data"));
            }
            if (nbt.func_74764_b("world_time")) {
                this.worldTime = nbt.func_74763_f("world_time");
            }
            if (nbt.func_74764_b("expiry")) {
                this.expiry = nbt.func_74762_e("expiry");
            }
            if (nbt.func_74764_b("module")) {
                this.module = ModuleInstance.deserialize(nbt.func_74779_i("module"));
            }
        }
    }

    public static class LingeringObject
    implements INBTSerializable<NBTTagCompound> {
        private SpellRing spellRing;
        private SpellData spellData;
        private long worldTime;
        private int expiry;
        @NotNull
        private final World world;

        public LingeringObject(SpellRing spellRing, SpellData spellData, long worldTime, int expiry) {
            this.spellRing = spellRing;
            this.spellData = spellData;
            this.worldTime = worldTime;
            this.expiry = expiry;
            this.world = spellData.world;
        }

        LingeringObject(@NotNull World world) {
            this.world = world;
        }

        public SpellRing getSpellRing() {
            return this.spellRing;
        }

        public SpellData getSpellData() {
            return this.spellData;
        }

        public long getWorldTime() {
            return this.worldTime;
        }

        public int getExpiry() {
            return this.expiry;
        }

        public static LingeringObject deserialize(World world, NBTTagCompound compound) {
            LingeringObject object = new LingeringObject(world);
            object.deserializeNBT(compound);
            return object;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.spellRing != null) {
                compound.func_74782_a("spell_ring", (NBTBase)this.spellRing.serializeNBT());
            }
            if (this.spellData != null) {
                compound.func_74782_a("spell_data", (NBTBase)this.spellData.serializeNBT());
            }
            compound.func_74772_a("world_time", this.worldTime);
            compound.func_74768_a("expiry", this.expiry);
            compound.func_74768_a("world", this.world.field_73011_w.getDimension());
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.spellRing = SpellRingCache.INSTANCE.getSpellRingByNBT(nbt.func_74775_l("spell_ring"));
            this.spellData = SpellData.deserializeData(this.world, nbt.func_74775_l("spell_data"));
            this.worldTime = nbt.func_74763_f("world_time");
            this.expiry = nbt.func_74762_e("expiry");
        }
    }
}

