/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.render;

import com.teamwizardry.librarianlib.features.kotlin.ClientUtilMethods;
import com.teamwizardry.librarianlib.features.shader.ShaderHelper;
import com.teamwizardry.wizardry.api.capability.mana.EnumBloodType;
import com.teamwizardry.wizardry.api.capability.mana.IWizardryCapability;
import com.teamwizardry.wizardry.api.capability.mana.WizardryCapabilityProvider;
import com.teamwizardry.wizardry.client.fx.Shaders;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;

public class BloodRenderLayer
implements LayerRenderer<AbstractClientPlayer> {
    private final RenderPlayer render;

    public BloodRenderLayer(RenderPlayer renderIn) {
        this.render = renderIn;
    }

    public void doRenderLayer(@Nonnull AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        EnumBloodType type;
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        IWizardryCapability cap = WizardryCapabilityProvider.getCap((Entity)entity);
        if (cap != null && (type = cap.getBloodType()) != null && type != EnumBloodType.NONE) {
            this.render.func_110776_a(EnumBloodType.getResourceLocation(type));
            ClientUtilMethods.glColor((Color)type.color);
            this.setModelVisibilities(entity);
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            GlStateManager.func_179140_f();
            ShaderHelper.INSTANCE.useShader(Shaders.rawColor);
            this.render.func_177087_b().func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179145_e();
            ShaderHelper.INSTANCE.releaseShader();
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void setModelVisibilities(AbstractClientPlayer clientPlayer) {
        ModelPlayer modelplayer = this.render.func_177087_b();
        if (clientPlayer.func_175149_v()) {
            modelplayer.func_178719_a(true);
            modelplayer.field_78116_c.field_78806_j = true;
            modelplayer.field_178720_f.field_78806_j = true;
        } else {
            ItemStack stackMain = clientPlayer.func_184614_ca();
            ItemStack stackOff = clientPlayer.func_184592_cb();
            modelplayer.func_178719_a(false);
            modelplayer.field_178720_f.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.HAT);
            modelplayer.field_178730_v.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.JACKET);
            modelplayer.field_178733_c.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_PANTS_LEG);
            modelplayer.field_178731_d.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_PANTS_LEG);
            modelplayer.field_178734_a.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.LEFT_SLEEVE);
            modelplayer.field_178732_b.field_78806_j = clientPlayer.func_175148_a(EnumPlayerModelParts.RIGHT_SLEEVE);
            modelplayer.field_78117_n = clientPlayer.func_70093_af();
            ModelBiped.ArmPose poseMain = ModelBiped.ArmPose.EMPTY;
            if (!stackMain.func_190926_b()) {
                poseMain = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0) {
                    EnumAction enumaction = stackMain.func_77975_n();
                    if (enumaction == EnumAction.BLOCK) {
                        poseMain = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        poseMain = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            ModelBiped.ArmPose poseOff = ModelBiped.ArmPose.EMPTY;
            if (!stackOff.func_190926_b()) {
                EnumAction enumaction1;
                poseOff = ModelBiped.ArmPose.ITEM;
                if (clientPlayer.func_184605_cv() > 0 && (enumaction1 = stackOff.func_77975_n()) == EnumAction.BLOCK) {
                    poseOff = ModelBiped.ArmPose.BLOCK;
                }
            }
            if (clientPlayer.func_184591_cq() == EnumHandSide.RIGHT) {
                modelplayer.field_187076_m = poseMain;
                modelplayer.field_187075_l = poseOff;
            } else {
                modelplayer.field_187076_m = poseOff;
                modelplayer.field_187075_l = poseMain;
            }
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

