/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.core.renderer;

import com.teamwizardry.librarianlib.features.sprite.Sprite;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="wizardry", value={Side.CLIENT})
public class StructureErrorRenderer {
    private static final Sprite particle = new Sprite(new ResourceLocation("wizardry", "textures/particles/sparkle_blurred.png"));
    private static ArrayList<ParticleError> errors = new ArrayList();

    public static void addError(BlockPos pos) {
        for (ParticleError error : errors) {
            if (error == null || error.pos.field_72450_a != (double)pos.func_177958_n() + 0.5 || error.pos.field_72448_b != (double)pos.func_177956_o() + 0.5 || error.pos.field_72449_c != (double)pos.func_177952_p() + 0.5) continue;
            return;
        }
        errors.add(new ParticleError(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), 100));
    }

    public static void addError(Vec3d pos) {
        for (ParticleError error : errors) {
            if (error == null || error.pos.field_72450_a != pos.field_72450_a && error.pos.field_72448_b != pos.field_72448_b && error.pos.field_72449_c != pos.field_72449_c) continue;
            return;
        }
        errors.add(new ParticleError(pos, 100));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void render(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (Minecraft.func_71410_x().func_175598_ae().field_78733_k == null) {
            return;
        }
        ArrayList<ParticleError> tmp = new ArrayList<ParticleError>(errors);
        for (ParticleError error : tmp) {
            --error.tick;
            if (error.tick <= 0) {
                errors.remove(error);
            }
            GlStateManager.func_179094_E();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
            GlStateManager.func_179137_b((double)error.pos.field_72450_a, (double)error.pos.field_72448_b, (double)error.pos.field_72449_c);
            GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(Minecraft.func_71410_x().func_175598_ae().field_78733_k.field_74320_O == 2 ? -1 : 1) * Minecraft.func_71410_x().func_175598_ae().field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)-0.25, (double)-0.25, (double)-0.25);
            GlStateManager.func_179097_i();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)((float)((double)error.tick / 100.0)));
            particle.getTex().bind();
            particle.draw((int)event.getPartialTicks(), 0.0f, 0.0f, 0.5f, 0.5f);
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
    }

    private static class ParticleError {
        public final Vec3d pos;
        public int tick;

        public ParticleError(Vec3d pos, int maxTick) {
            this.pos = pos;
            this.tick = maxTick;
        }
    }
}

