/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.asm;

import com.teamwizardry.wizardry.asm.SafeClassWriter;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WizardryTransformer
implements IClassTransformer {
    private static final String CLASS_BLOCK = "net/minecraft/block/Block";
    private static final String CLASS_BLOCK_POS = "net/minecraft/util/math/BlockPos";
    private static final String CLASS_BLOCK_STATE = "net/minecraft/block/state/IBlockState";
    private static final String CLASS_BLOCK_ACCESS = "net/minecraft/world/IBlockAccess";
    private static final String CLASS_ENTITY_PLAYER = "net/minecraft/entity/player/EntityPlayer";
    private static final String CLASS_ENTITY = "net/minecraft/entity/Entity";
    private static final String CLASS_ENTITY_LIVING_BASE = "net/minecraft/entity/EntityLivingBase";
    private static final String CLASS_MOVER_TYPE = "net/minecraft/entity/MoverType";
    private static final String CLASS_EVENT = "net/minecraftforge/fml/common/eventhandler/Event";
    private static final String CLASS_MOVE_EVENT = "com/teamwizardry/wizardry/api/events/EntityMoveEvent";
    private static final String CLASS_TRAVEL_EVENT = "com/teamwizardry/wizardry/api/events/EntityTravelEvent";
    private static final String ASM_HOOKS = "com/teamwizardry/wizardry/asm/WizardryASMHooks";

    private static void log(String str) {
        System.out.println("[wizardry ASM] " + str);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.client.renderer.entity.Render": {
                return this.transformSingleMethod(basicClass, "func_76979_b", "doRenderShadowAndFire", "(Lnet/minecraft/entity/Entity;DDDFF)V", methodNode -> {
                    LabelNode node1 = new LabelNode();
                    InsnList newInstructions = new InsnList();
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "entityRenderShadowAndFire", "(Lnet/minecraft/entity/Entity;)Z", false));
                    newInstructions.add((AbstractInsnNode)new JumpInsnNode(154, node1));
                    newInstructions.add((AbstractInsnNode)new InsnNode(177));
                    newInstructions.add((AbstractInsnNode)node1);
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), newInstructions);
                    methodNode.instructions.resetLabels();
                    return true;
                });
            }
            case "net.minecraft.entity.Entity": {
                return this.transformSingleMethod(basicClass, "func_70091_d", "move", "(Lnet/minecraft/entity/MoverType;DDD)V", methodNode -> {
                    InsnList newInstructions = new InsnList();
                    LabelNode node1 = new LabelNode();
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 2));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 4));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(24, 6));
                    newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "entityPreMoveHook", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/MoverType;DDD)Lcom/teamwizardry/wizardry/api/events/EntityMoveEvent;", false));
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, CLASS_EVENT, "isCanceled", "()Z", false));
                    newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, node1));
                    newInstructions.add((AbstractInsnNode)new InsnNode(87));
                    newInstructions.add((AbstractInsnNode)new InsnNode(177));
                    newInstructions.add((AbstractInsnNode)node1);
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, CLASS_MOVE_EVENT, "type", "Lnet/minecraft/entity/MoverType;"));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, CLASS_MOVE_EVENT, "x", "D"));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(57, 2));
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, CLASS_MOVE_EVENT, "y", "D"));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(57, 4));
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, CLASS_MOVE_EVENT, "z", "D"));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(57, 6));
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), newInstructions);
                    methodNode.instructions.resetLabels();
                    return true;
                });
            }
            case "net.minecraft.entity.EntityLivingBase": {
                return this.transformSingleMethod(basicClass, "func_191986_a", "travel", "(FFF)V", methodNode -> {
                    LabelNode node1 = new LabelNode();
                    InsnList newInstructions = new InsnList();
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(23, 3));
                    newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "travel", "(Lnet/minecraft/entity/EntityLivingBase;FFF)Lcom/teamwizardry/wizardry/api/events/EntityTravelEvent;", false));
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, CLASS_EVENT, "isCanceled", "()Z", false));
                    newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, node1));
                    newInstructions.add((AbstractInsnNode)new InsnNode(87));
                    newInstructions.add((AbstractInsnNode)new InsnNode(177));
                    newInstructions.add((AbstractInsnNode)node1);
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    newInstructions.add((AbstractInsnNode)new InsnNode(89));
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, CLASS_TRAVEL_EVENT, "strafe", "F"));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(56, 1));
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, CLASS_TRAVEL_EVENT, "vertical", "F"));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(56, 2));
                    newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, CLASS_TRAVEL_EVENT, "forward", "F"));
                    newInstructions.add((AbstractInsnNode)new VarInsnNode(56, 3));
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), newInstructions);
                    for (int i = 0; i < methodNode.instructions.size(); ++i) {
                        MethodInsnNode node;
                        AbstractInsnNode insnNode = methodNode.instructions.get(i);
                        if (!(insnNode instanceof MethodInsnNode) || (node = (MethodInsnNode)insnNode).getOpcode() != 182 || !node.owner.equals(CLASS_BLOCK) || !node.name.equals("getSlipperiness") || !node.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)F")) continue;
                        InsnList afterInstructions = new InsnList();
                        afterInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        afterInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "slipperyHook", "(FLnet/minecraft/entity/Entity;)F", false));
                        methodNode.instructions.insert(insnNode, afterInstructions);
                    }
                    methodNode.instructions.resetLabels();
                    return true;
                });
            }
            case "net.minecraft.entity.player.EntityPlayer": {
                return this.transformSingleMethod(basicClass, "func_70071_h_", "onUpdate", "()V", methodNode -> {
                    for (int i = 0; i < methodNode.instructions.size(); ++i) {
                        FieldInsnNode fInsnNode;
                        AbstractInsnNode insnNode = methodNode.instructions.get(i);
                        if (!(insnNode instanceof FieldInsnNode) || (fInsnNode = (FieldInsnNode)insnNode).getOpcode() != 181 || !fInsnNode.owner.equals(CLASS_ENTITY_PLAYER) || !this.equalsEither(fInsnNode.name, "field_70145_X", "noClip") || !fInsnNode.desc.equals("Z")) continue;
                        InsnList newInstructions = new InsnList();
                        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "playerClipEventHook", "(ZLnet/minecraft/entity/player/EntityPlayer;)Z", false));
                        methodNode.instructions.insertBefore(insnNode, newInstructions);
                        methodNode.instructions.resetLabels();
                        return true;
                    }
                    return false;
                });
            }
        }
        return basicClass;
    }

    private boolean equalsEither(String name, String srgName, String mcpName) {
        return name.equals(srgName) || name.equals(mcpName);
    }

    private byte[] transformSingleMethod(byte[] basicClass, String srgName, String mcpName, String desc, Predicate<MethodNode> transformer) {
        return this.transformClass(basicClass, classNode -> {
            for (MethodNode methodNode : classNode.methods) {
                if (!this.equalsEither(methodNode.name, srgName, mcpName) || !methodNode.desc.equals(desc)) continue;
                if (transformer.test(methodNode)) {
                    WizardryTransformer.log("Successfully patched -> '" + srgName + "', '" + mcpName + "' with '" + desc + "'");
                    continue;
                }
                WizardryTransformer.log("Failed to patch      -> '" + srgName + "', '" + mcpName + "' with '" + desc + "'");
            }
        });
    }

    private byte[] transformClass(byte[] basicClass, Consumer<ClassNode> transformer) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        reader.accept((ClassVisitor)classNode, 0);
        transformer.accept(classNode);
        SafeClassWriter writer = new SafeClassWriter(3){

            @Override
            protected String getCommonSuperClass(String type1, String type2) {
                return "java/lang/Object";
            }
        };
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

