/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import com.google.common.collect.Iterables;
import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LightEffectUtil {
    public static void renderBall(Vec3d cetner, Color color, double radius, double resolution) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)ClientTickHandler.getPartialTicks();
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)ClientTickHandler.getPartialTicks();
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)ClientTickHandler.getPartialTicks();
        GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        float px = (float)cetner.field_72450_a;
        float py = (float)cetner.field_72448_b;
        int i = 0;
        while ((double)i <= resolution) {
            float angle = (float)((double)i * Math.PI * 2.0 / resolution);
            float x1 = (float)(cetner.field_72450_a + (double)MathHelper.func_76134_b((float)angle) * radius);
            float y1 = (float)(cetner.field_72448_b + (double)MathHelper.func_76126_a((float)angle) * radius);
            LightEffectUtil.pos(vb, cetner).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
            LightEffectUtil.pos(vb, new Vec3d((double)px, (double)py, cetner.field_72449_c)).func_181669_b(0, 0, 0, 0).func_181675_d();
            LightEffectUtil.pos(vb, new Vec3d((double)x1, (double)y1, cetner.field_72449_c)).func_181669_b(0, 0, 0, 0).func_181675_d();
            px = x1;
            py = y1;
            ++i;
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static void renderBilinearGradient(List<Vec3d> points, Color color, double thickness, Vec3d normal) {
        List<Vec3d> derivative = LightEffectUtil.derivative(points);
        List<Vec3d> concave = LightEffectUtil.derivative(derivative);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)ClientTickHandler.getPartialTicks();
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)ClientTickHandler.getPartialTicks();
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)ClientTickHandler.getPartialTicks();
        GlStateManager.func_179137_b((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179129_p();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        Vec3d playerEyes = Minecraft.func_71410_x().field_71439_g.func_174824_e(ClientTickHandler.getPartialTicks());
        Vec3d normal1 = points.get(points.size() - 1).func_178788_d(points.get(0)).func_72431_c(playerEyes.func_178788_d(points.get(0))).func_72432_b();
        if (normal1.field_72448_b < 0.0) {
            normal1 = normal.func_186678_a(-1.0);
        }
        int a = color.getAlpha();
        for (int i = 1; i < points.size(); ++i) {
            Vec3d to = points.get(i);
            Vec3d from = points.get(i - 1);
            if (derivative.size() <= i) continue;
            Vec3d der = derivative.get(i);
            Vec3d norm = new Vec3d(der.field_72448_b, -der.field_72450_a, der.field_72449_c).func_72432_b().func_186678_a(thickness).func_186678_a(concave.size() < i ? concave.get(i).func_72433_c() : 1.0);
            Vec3d midpoint = new Vec3d((from.field_72450_a + to.field_72450_a) / 2.0, (from.field_72448_b + to.field_72448_b) / 2.0, (from.field_72449_c + to.field_72449_c) / 2.0);
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            LightEffectUtil.pos(vb, from).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
            LightEffectUtil.pos(vb, midpoint.func_178788_d(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
            LightEffectUtil.pos(vb, to).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
            tessellator.func_78381_a();
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            LightEffectUtil.pos(vb, from).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
            LightEffectUtil.pos(vb, midpoint.func_178787_e(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
            LightEffectUtil.pos(vb, to).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
            tessellator.func_78381_a();
            if (points.size() > i + 1 && derivative.size() > i + 1) {
                Vec3d nextPoint = points.get(i + 1);
                Vec3d nextDer = derivative.get(i + 1);
                Vec3d nextDerNorm = new Vec3d(nextDer.field_72448_b, -nextDer.field_72450_a, nextDer.field_72449_c).func_72432_b().func_186678_a(thickness).func_186678_a(concave.size() < i ? concave.get(i).func_72433_c() : 1.0);
                Vec3d nextMidPoint = new Vec3d((to.field_72450_a + nextPoint.field_72450_a) / 2.0, (to.field_72448_b + nextPoint.field_72448_b) / 2.0, (to.field_72449_c + nextPoint.field_72449_c) / 2.0);
                vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                LightEffectUtil.pos(vb, midpoint.func_178788_d(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
                LightEffectUtil.pos(vb, nextMidPoint.func_178788_d(nextDerNorm)).func_181669_b(0, 0, 0, 0).func_181675_d();
                LightEffectUtil.pos(vb, to).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                tessellator.func_78381_a();
                vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                LightEffectUtil.pos(vb, midpoint.func_178787_e(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
                LightEffectUtil.pos(vb, nextMidPoint.func_178787_e(nextDerNorm)).func_181669_b(0, 0, 0, 0).func_181675_d();
                LightEffectUtil.pos(vb, to).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
                tessellator.func_78381_a();
                continue;
            }
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            LightEffectUtil.pos(vb, midpoint.func_178788_d(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
            LightEffectUtil.pos(vb, to.func_178788_d(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
            LightEffectUtil.pos(vb, to).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
            tessellator.func_78381_a();
            vb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            LightEffectUtil.pos(vb, midpoint.func_178787_e(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
            LightEffectUtil.pos(vb, to.func_178787_e(norm)).func_181669_b(0, 0, 0, 0).func_181675_d();
            LightEffectUtil.pos(vb, to).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), a).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private static BufferBuilder pos(BufferBuilder vb, Vec3d pos) {
        return vb.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    private static List<Vec3d> derivative(List<Vec3d> controlPoints) {
        if (controlPoints.isEmpty()) {
            throw new IllegalArgumentException("controlPoints must not be empty");
        }
        int size = controlPoints.size() - 1;
        ArrayList<Vec3d> derivative = new ArrayList<Vec3d>(size);
        Vec3d prev = controlPoints.get(0);
        for (Vec3d vec : Iterables.skip(controlPoints, (int)1)) {
            derivative.add(prev.func_178788_d(vec).func_186678_a((double)size));
            prev = vec;
        }
        return derivative;
    }
}

