/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.mana;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.librarianlib.features.saving.Savable;
import com.teamwizardry.librarianlib.features.saving.Save;
import com.teamwizardry.wizardry.api.capability.mana.EnumBloodType;
import com.teamwizardry.wizardry.api.capability.mana.IWizardryCapability;
import com.teamwizardry.wizardry.api.capability.mana.WizardryCapabilityProvider;
import com.teamwizardry.wizardry.api.capability.mana.WizardryCapabilityStorage;
import com.teamwizardry.wizardry.common.network.PacketUpdateCaps;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Savable
public class CustomWizardryCapability
implements IWizardryCapability {
    @Save
    double mana = 0.0;
    @Save
    double maxMana = 100.0;
    @Save
    double burnout = 100.0;
    @Save
    double maxBurnout = 100.0;
    @Save
    EnumBloodType bloodType;

    CustomWizardryCapability() {
    }

    public CustomWizardryCapability(double maxMana, double maxBurnout) {
        this.maxMana = maxMana;
        this.maxBurnout = maxBurnout;
    }

    public CustomWizardryCapability(double maxMana, double maxBurnout, double mana, double burnout) {
        this.maxMana = maxMana;
        this.maxBurnout = maxBurnout;
        this.mana = mana;
        this.burnout = burnout;
    }

    @Override
    public double getMana() {
        return this.mana;
    }

    @Override
    public void setMana(double mana) {
        this.mana = mana;
        if (mana < 0.0) {
            this.mana = 0.0;
        }
        if (mana > this.maxMana) {
            this.mana = this.maxMana;
        }
    }

    @Override
    public double getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMaxMana(double maxMana) {
        this.maxMana = maxMana;
    }

    @Override
    public double getBurnout() {
        return this.burnout;
    }

    @Override
    public void setBurnout(double burnout) {
        this.burnout = burnout;
        if (burnout < 0.0) {
            this.burnout = 0.0;
        }
        if (burnout > this.maxBurnout) {
            this.burnout = this.maxBurnout;
        }
    }

    @Override
    public double getMaxBurnout() {
        return this.maxBurnout;
    }

    @Override
    public void setMaxBurnout(double maxBurnout) {
        this.maxBurnout = maxBurnout;
    }

    @Override
    @Nullable
    public EnumBloodType getBloodType() {
        return this.bloodType;
    }

    @Override
    public void setBloodType(EnumBloodType bloodType) {
        this.bloodType = bloodType;
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)WizardryCapabilityStorage.INSTANCE.writeNBT(WizardryCapabilityProvider.wizardryCapability, this, null);
    }

    public void deserializeNBT(NBTTagCompound compound) {
        WizardryCapabilityStorage.INSTANCE.readNBT(WizardryCapabilityProvider.wizardryCapability, this, null, (NBTBase)compound);
    }

    @Override
    public void dataChanged(Entity entity) {
        if (entity != null && entity instanceof EntityPlayer && !entity.func_130014_f_().field_72995_K) {
            PacketHandler.NETWORK.sendTo((IMessage)new PacketUpdateCaps(this.serializeNBT()), (EntityPlayerMP)entity);
        }
    }
}

