/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.world;

import aroma1997.core.item.AromicCreativeTab;
import aroma1997.core.log.LogHelper;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.PacketHandler;
import aroma1997.core.util.registry.AromaAutoRegistry;
import aroma1997.world.CommonProxy;
import aroma1997.world.Config;
import aroma1997.world.DimensionalWorldCommand;
import aroma1997.world.DimensionalWorldItems;
import aroma1997.world.dimension.WorldProviderMining;
import aroma1997.world.gen.WorldGenEventHandler;
import aroma1997.world.item.BlockMiningOre;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="aroma1997sdimension", name="Aroma1997sDimension", certificateFingerprint="dfbfe4c473253d8c5652417689848f650b2cbe32", dependencies="required-after:aroma1997core", acceptedMinecraftVersions="[1.12]")
public class DimensionalWorld {
    @Mod.Instance
    public static DimensionalWorld instance;
    @SidedProxy(serverSide="aroma1997.world.CommonProxy", clientSide="aroma1997.world.client.ClientProxy")
    public static CommonProxy proxy;
    public PacketHandler ph;
    public Logger log;
    public static final CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.log = LogHelper.genNewLogger((String)"aroma1997sdimension");
        Config.INSTANCE.loadFromDisc();
        DimensionalWorldItems.dimensionType = DimensionType.register((String)"MINING_WORLD", (String)"_mining_world", (int)Config.INSTANCE.dimensionid, WorldProviderMining.class, (boolean)false);
        AromaAutoRegistry.INSTANCE.registerClassWrapper(DimensionalWorldItems.class, null);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.ph = NetworkHelper.getPacketHandler((String)"aroma1997sdimension");
        this.ph.registerMessage(Config.PacketHandler.class, Config.class, 0, Side.CLIENT);
        proxy.setConfig(Config.INSTANCE);
        new WorldGenEventHandler();
        Config.INSTANCE.loadReloadablesFromDisc();
        for (BlockMiningOre.MiningOreType type : BlockMiningOre.MiningOreType.values()) {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack((Block)DimensionalWorldItems.miningOre, 1, type.ordinal()), type.drop.get(), 0.5f);
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        proxy.serverStarted();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new DimensionalWorldCommand());
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LogHelper.log((Level)Level.WARN, (String)"Invalid fingerprint detected! The version of the mod is most likely modified and an inofficial release.");
        LogHelper.log((Level)Level.WARN, (String)"Use with caution.");
    }

    static {
        creativeTab = new AromicCreativeTab("aroma1997sdimension:creativeTabDW", () -> new ItemStack((Item)DimensionalWorldItems.miningMultitool));
    }
}

