/*
 * Decompiled with CFR 0.152.
 */
package teamroots.roots.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;

public class ShaderUtil {
    public static int currentProgram = 0;
    public static int lightProgram = 0;
    public static int lightEntitiesProgram = 0;

    public static void init() {
        lightProgram = ShaderUtil.loadProgram("/assets/roots/shaders/light.vs", "/assets/roots/shaders/light.fs");
        lightEntitiesProgram = ShaderUtil.loadProgram("/assets/roots/shaders/light_entity.vs", "/assets/roots/shaders/light_entity.fs");
    }

    public static int loadProgram(String vsh, String fsh) {
        int vertexShader = ShaderUtil.createShader(vsh, OpenGlHelper.field_153209_q);
        int fragmentShader = ShaderUtil.createShader(fsh, OpenGlHelper.field_153210_r);
        int program = OpenGlHelper.func_153183_d();
        OpenGlHelper.func_153178_b((int)program, (int)vertexShader);
        OpenGlHelper.func_153178_b((int)program, (int)fragmentShader);
        OpenGlHelper.func_153179_f((int)program);
        return program;
    }

    public static void useProgram(int program) {
        OpenGlHelper.func_153161_d((int)program);
        currentProgram = program;
    }

    public static int createShader(String filename, int shaderType) {
        int shader = OpenGlHelper.func_153195_b((int)shaderType);
        if (shader == 0) {
            return 0;
        }
        try {
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)ShaderUtil.readFileAsString(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OpenGlHelper.func_153170_c((int)shader);
        OpenGlHelper.func_153170_c((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)OpenGlHelper.field_153208_p) == 0) {
            throw new RuntimeException("Error creating shader: " + ShaderUtil.getLogInfo(shader));
        }
        return shader;
    }

    public static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public static String readFileAsString(String filename) throws Exception {
        StringBuilder source = new StringBuilder();
        InputStream in = ShaderUtil.class.getResourceAsStream(filename);
        String s = "";
        if (in != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                s = reader.lines().collect(Collectors.joining("\n"));
            }
        }
        return s;
    }
}

