/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.command;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.arl.network.NetworkHandler;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.network.message.MessageChangeConfig;

public class CommandConfig
extends CommandBase {
    private static final Pattern TOKENIZER = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");

    public String func_71517_b() {
        return "quarkconfig";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "<module> <category> <key> <value> [save?] [player]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String player;
        String fullInput = String.join((CharSequence)" ", args);
        Matcher m = TOKENIZER.matcher(fullInput);
        ArrayList<String> matches = new ArrayList<String>();
        while (m.find()) {
            String s = m.group(0);
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.replaceAll("\"$", "");
                s = s.replaceAll("^\"", "");
            }
            matches.add(s);
        }
        if (matches.size() < 4) {
            throw new SyntaxErrorException();
        }
        String fileStr = (String)matches.get(0);
        if (fileStr.contains("\\.\\.")) {
            throw new WrongUsageException("I know the game you're playing.", new Object[0]);
        }
        boolean save = matches.size() > 4 && ((String)matches.get(4)).equals("save");
        String moduleName = (String)matches.get(0);
        String category = (String)matches.get(1);
        String key = (String)matches.get(2);
        String value = (String)matches.get(3);
        GlobalConfig.changeConfig(moduleName, category, key, value, save);
        String string = player = matches.size() > 5 ? (player = (String)matches.get(5)) : null;
        if (player != null) {
            EntityPlayerMP playermp = CommandConfig.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)player);
            NetworkHandler.INSTANCE.sendTo((IMessage)new MessageChangeConfig(moduleName, category, key, value, save), playermp);
        } else {
            NetworkHandler.INSTANCE.sendToAll((IMessage)new MessageChangeConfig(moduleName, category, key, value, save));
        }
    }
}

