/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.gui.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.translation.I18n;
import vazkii.quark.base.client.gui.config.GuiButtonConfigSetting;
import vazkii.quark.base.client.gui.config.GuiButtonFeatureSettings;
import vazkii.quark.base.client.gui.config.GuiConfigBase;
import vazkii.quark.base.client.gui.config.GuiConfigCategory;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleLoader;

public class GuiConfigModule
extends GuiConfigBase {
    private static final int FEATURES_PER_PAGE = 12;
    final Module module;
    final List<Feature> features;
    int page = 0;
    int totalPages;
    private GuiButton left;
    private GuiButton right;

    public GuiConfigModule(GuiScreen parent, Module module) {
        super(parent);
        this.module = module;
        this.features = new ArrayList<Feature>();
        module.forEachFeature(this.features::add);
        Collections.sort(this.features);
        this.totalPages = (this.features.size() - 1) / 12 + 1;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.title = this.title + " - " + I18n.func_74838_a((String)("quark.config.module." + this.module.name)) + " (" + this.features.size() + ")";
        int x = this.field_146294_l / 2 - 100;
        int y = this.field_146295_m / 6 + 167;
        this.backButton = new GuiButton(0, x, y, 200, 20, I18n.func_74838_a((String)"gui.done"));
        this.field_146292_n.add(this.backButton);
        if (this.totalPages > 1) {
            x = this.field_146294_l / 2;
            y = this.field_146295_m / 6 - 12;
            this.left = new GuiButton(0, x - 40, y, 20, 20, "<");
            this.field_146292_n.add(this.left);
            this.right = new GuiButton(0, x + 20, y, 20, 20, ">");
            this.field_146292_n.add(this.right);
        }
        this.addFeatureButtons();
    }

    void addFeatureButtons() {
        int start;
        int startX = this.field_146294_l / 2 - 195;
        int startY = this.field_146295_m / 6 + 20;
        this.field_146292_n.removeIf(b -> b instanceof GuiButtonConfigSetting || b instanceof GuiButtonFeatureSettings);
        int x = 0;
        int y = 0;
        for (int i = start = this.page * 12; i < Math.min(start + 12, this.features.size()); ++i) {
            int j = i - start;
            x = startX + j % 2 * 200;
            y = startY + j / 2 * 22;
            Feature feature = this.features.get(i);
            this.field_146292_n.add(new GuiButtonConfigSetting(x + 150, y, feature.prop, true, feature.getFeatureIngameConfigName()));
            if (!ModuleLoader.config.hasCategory(feature.configCategory)) continue;
            this.field_146292_n.add(new GuiButtonFeatureSettings(x + 170, y, feature.configCategory));
        }
        if (this.left != null) {
            this.left.field_146124_l = this.page > 0;
            this.right.field_146124_l = this.page < this.totalPages - 1;
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiButtonFeatureSettings) {
            GuiButtonFeatureSettings featureButton = (GuiButtonFeatureSettings)button;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiConfigCategory(this, featureButton.category));
        } else if (button == this.left || button == this.right) {
            this.page = button == this.left ? Math.max(this.page - 1, 0) : Math.min(this.page + 1, this.totalPages - 1);
            this.addFeatureButtons();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.totalPages > 1) {
            int x = this.field_146294_l / 2;
            int y = this.field_146295_m / 6 - 7;
            this.func_73732_a(this.field_146297_k.field_71466_p, this.page + 1 + "/" + this.totalPages, x, y, 0xFFFFFF);
        }
        if (mayRequireRestart) {
            String s = I18n.func_74838_a((String)"quark.config.needrestart");
            this.func_73732_a(this.field_146297_k.field_71466_p, s, this.field_146294_l / 2, this.backButton.field_146129_i + 22, 0xFFFF00);
        }
    }
}

