/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.IPagedVariants;
import biomesoplenty.common.block.BlockBOPGrass;
import biomesoplenty.common.block.IBOPBlock;
import biomesoplenty.common.block.ISustainsPlantType;
import biomesoplenty.common.item.ItemBOPBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBOPDirt
extends Block
implements IBOPBlock,
ISustainsPlantType {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", BOPDirtType.class);
    public static final PropertyBool COARSE = PropertyBool.func_177716_a((String)"coarse");

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COARSE, VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemBOPBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{COARSE, VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return (Boolean.TRUE.equals(state.func_177229_b((IProperty)COARSE)) ? "coarse_" : "") + ((BOPDirtType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l() + "_dirt";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return null;
    }

    public BlockBOPDirt() {
        super(Material.field_151578_c);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)COARSE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPDirtType.LOAMY)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)COARSE, (Comparable)Boolean.valueOf((meta & 8) > 0)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)BOPDirtType.values()[Math.min(2, meta & 7)]));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean.TRUE.equals(state.func_177229_b((IProperty)COARSE)) ? 8 : 0) | ((BOPDirtType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public boolean canSustainPlantType(IBlockAccess world, BlockPos pos, EnumPlantType plantType) {
        if (plantType == EnumPlantType.Desert || plantType == EnumPlantType.Plains || plantType == EnumPlantType.Cave) {
            return true;
        }
        if (plantType == EnumPlantType.Beach) {
            return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (plantable == Blocks.field_150394_bc || plantable == Blocks.field_150393_bb) {
            return true;
        }
        return this.canSustainPlantType(world, pos, plantable.getPlantType(world, pos.func_177972_a(direction)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        IBlockState grassState = BlockBOPDirt.getGrassBlockState(state);
        if (grassState != null) {
            this.pullGrassFromNeighbors(world, pos, grassState, rand, 4, 1, 3, 1);
        }
    }

    public void pullGrassFromNeighbors(World world, BlockPos pos, IBlockState grassState, Random rand, int tries, int xzSpread, int downSpread, int upSpread) {
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        if (world.func_175671_l(pos.func_177984_a()) < 4 || upState.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
            return;
        }
        int numNearbyGrassSpreadingBlocks = 0;
        for (int dy = -downSpread; dy <= upSpread; ++dy) {
            for (int dx = -xzSpread; dx <= xzSpread; ++dx) {
                for (int dz = -xzSpread; dz <= xzSpread; ++dz) {
                    BlockPos pos1 = pos.func_177982_a(dx, dy, dz);
                    if (world.func_180495_p(pos1).func_177230_c() != Blocks.field_150349_c || world.func_175671_l(pos1.func_177984_a()) < 9) continue;
                    ++numNearbyGrassSpreadingBlocks;
                }
            }
        }
        if (numNearbyGrassSpreadingBlocks == 0) {
            return;
        }
        int vol = (xzSpread * 2 + 1) * (xzSpread * 2 + 1) * (upSpread + downSpread + 1);
        double chanceOfSpread = 1.0 - Math.pow(1.0 - 1.0 / (double)vol, tries * numNearbyGrassSpreadingBlocks);
        if (rand.nextDouble() < chanceOfSpread) {
            world.func_175656_a(pos, grassState);
        }
    }

    public static IBlockState getGrassBlockState(IBlockState state) {
        if (Boolean.TRUE.equals(state.func_177229_b((IProperty)COARSE))) {
            return null;
        }
        switch ((BOPDirtType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case LOAMY: {
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.LOAMY));
            }
            case SANDY: {
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SANDY));
            }
            case SILTY: {
                return BOPBlocks.grass.func_176223_P().func_177226_a((IProperty)BlockBOPGrass.VARIANT, (Comparable)((Object)BlockBOPGrass.BOPGrassType.SILTY));
            }
        }
        return Blocks.field_150349_c.func_176223_P();
    }

    public Block getGrassBlock(IBlockState state) {
        return BlockBOPDirt.getGrassBlockState(state).func_177230_c();
    }

    public int getGrassBlockMeta(IBlockState state) {
        return this.getGrassBlock(state).func_176201_c(BlockBOPDirt.getGrassBlockState(state));
    }

    public static enum BOPDirtType implements IStringSerializable,
    IPagedVariants
    {
        LOAMY,
        SANDY,
        SILTY;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

