/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize;

import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.compat.optifine.OptifineCompat;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.BuildToolPasteMessage;
import com.ldtteam.structurize.network.messages.GenerateAndPasteMessage;
import com.ldtteam.structurize.network.messages.MultiBlockChangeMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.network.messages.SchematicSaveMessage;
import com.ldtteam.structurize.network.messages.ServerUUIDMessage;
import com.ldtteam.structurize.network.messages.StructurizeStylesMessage;
import com.ldtteam.structurize.network.messages.UndoMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.proxy.IProxy;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
@Mod(modid="structurize", name="Structurize", version="1.12.2-0.10.63-ALPHA", dependencies="after:gbook", acceptedMinecraftVersions="[1.12,1.13]")
public class Structurize {
    private static final Logger logger = LogManager.getLogger((String)"structurize");
    @Mod.Instance(value="structurize")
    public static Structurize instance;
    @SidedProxy(clientSide="com.ldtteam.structurize.proxy.ClientProxy", serverSide="com.ldtteam.structurize.proxy.ServerProxy")
    public static IProxy proxy;
    private static SimpleNetworkWrapper network;

    public static boolean isClient() {
        return proxy.isClient() && FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean isServer() {
        return !proxy.isClient() && FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static Logger getLogger() {
        return logger;
    }

    @Mod.EventHandler
    public void preInit(@NotNull FMLPreInitializationEvent event) {
        StructureLoadingUtils.originFolders.add("structurize");
        proxy.registerEntities();
        proxy.registerEntityRendering();
        proxy.registerEvents();
        Configuration configuration = new Configuration(event.getSuggestedConfigurationFile());
        configuration.load();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Structurize.initializeNetwork();
        proxy.registerTileEntities();
        proxy.registerTileEntityRendering();
        proxy.registerRenderer();
        OreDictionary.registerOre((String)"plankWood", (Block)ModBlocks.blockCactusPlank);
        OreDictionary.registerOre((String)"slabWood", (Block)ModBlocks.blockCactusSlabHalf);
        OreDictionary.registerOre((String)"stairWood", (Block)ModBlocks.blockCactusStair);
        OreDictionary.registerOre((String)"fenceWood", (Block)ModBlocks.blockCactusFence);
        OreDictionary.registerOre((String)"fenceGateWood", (Block)ModBlocks.blockCactusFenceGate);
        OptifineCompat.getInstance().intialize();
    }

    private static synchronized void initializeNetwork() {
        int id = 0;
        network = NetworkRegistry.INSTANCE.newSimpleChannel("Structurize");
        Structurize.getNetwork().registerMessage(ServerUUIDMessage.class, ServerUUIDMessage.class, ++id, Side.CLIENT);
        Structurize.getNetwork().registerMessage(BuildToolPasteMessage.class, BuildToolPasteMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(ScanOnServerMessage.class, ScanOnServerMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(RemoveBlockMessage.class, RemoveBlockMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(RemoveEntityMessage.class, RemoveEntityMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(ReplaceBlockMessage.class, ReplaceBlockMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(GenerateAndPasteMessage.class, GenerateAndPasteMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(UpdateScanToolMessage.class, UpdateScanToolMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(SchematicRequestMessage.class, SchematicRequestMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(SchematicSaveMessage.class, SchematicSaveMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(UndoMessage.class, UndoMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(StructurizeStylesMessage.class, StructurizeStylesMessage.class, ++id, Side.CLIENT);
        Structurize.getNetwork().registerMessage(MultiBlockChangeMessage.class, MultiBlockChangeMessage.class, ++id, Side.SERVER);
        Structurize.getNetwork().registerMessage(SaveScanMessage.class, SaveScanMessage.class, ++id, Side.CLIENT);
        Structurize.getNetwork().registerMessage(SchematicSaveMessage.class, SchematicSaveMessage.class, ++id, Side.CLIENT);
    }

    @Mod.EventHandler
    public void serverAboutLoad(FMLServerAboutToStartEvent event) {
        Structures.init();
    }

    public static SimpleNetworkWrapper getNetwork() {
        return network;
    }
}

