/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.helpers;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.api.util.Shape;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Mirror;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    public static final Settings instance = new Settings();
    private final BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
    private BlockPos pos = null;
    private boolean isMirrored = false;
    @Nullable
    private Structure structure = null;
    private int rotation = 0;
    private String structureName = null;
    private int width = 1;
    private int height = 1;
    private int length = 1;
    private int frequency = 1;
    private boolean hollow = false;
    private Shape shape = Shape.CUBE;
    private Tuple<BlockPos, BlockPos> box = null;
    private boolean staticSchematicMode = false;
    private String staticSchematicName = "";
    private Tuple<ItemStack, ItemStack> stack = new Tuple((Object)new ItemStack(Blocks.field_150340_R), (Object)new ItemStack(Blocks.field_150340_R));
    private WindowBuildTool.FreeMode freeMode;

    private Settings() {
    }

    public void setupStaticMode(String name, WindowBuildTool.FreeMode freeMode) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
        this.freeMode = freeMode;
    }

    public void setupStaticMode(String name) {
        this.staticSchematicMode = true;
        this.staticSchematicName = name;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public Tuple<BlockPos, BlockPos> getBox() {
        return this.box;
    }

    @NotNull
    public void setBox(Tuple<BlockPos, BlockPos> box) {
        this.box = box;
    }

    public void setPosition(BlockPos position) {
        this.pos = position;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void moveTo(BlockPos pos) {
        if (this.structure == null) {
            return;
        }
        this.pos = this.pos.func_177971_a((Vec3i)pos);
    }

    @Nullable
    public Structure getActiveStructure() {
        if (this.structure != null && this.structure.isBluePrintMissing()) {
            this.structure = null;
        }
        return this.structure;
    }

    public void setActiveSchematic(Structure structure) {
        if (structure == null) {
            this.reset();
        } else {
            this.structure = structure;
        }
    }

    public void reset() {
        this.structure = null;
        this.offset.func_181079_c(0, 0, 0);
        this.rotation = 0;
        this.isMirrored = false;
        this.staticSchematicMode = false;
        this.staticSchematicName = "";
    }

    public void setSchematicInfo(String structureName, int rotation) {
        this.structureName = structureName;
        this.rotation = rotation;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void mirror() {
        if (this.structure == null) {
            return;
        }
        this.isMirrored = !this.isMirrored;
        this.structure.getSettings().setMirror(this.getMirror());
        this.structure.setPlacementSettings(this.structure.getSettings());
    }

    public Mirror getMirror() {
        if (this.isMirrored) {
            return Mirror.FRONT_BACK;
        }
        return Mirror.NONE;
    }

    public boolean isStaticSchematicMode() {
        return this.staticSchematicMode;
    }

    public String getStaticSchematicName() {
        return this.staticSchematicName;
    }

    public WindowBuildTool.FreeMode getFreeMode() {
        return this.freeMode;
    }

    public void setShape(String s) {
        this.shape = Shape.valueOf(s);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setBlock(ItemStack s, boolean mainBlock) {
        this.stack = mainBlock ? new Tuple((Object)s, this.stack.func_76340_b()) : new Tuple(this.stack.func_76341_a(), (Object)s);
    }

    public ItemStack getBlock(boolean main) {
        return main ? (ItemStack)this.stack.func_76341_a() : (ItemStack)this.stack.func_76340_b();
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
    }
}

