/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.nbt.mbt;

import code.elix_x.excore.utils.nbt.mbt.MBT;
import code.elix_x.excore.utils.nbt.mbt.encoders.NBTClassEncoder;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.ArrayUtils;

public interface NBTEncoder<T, NT extends NBTBase> {
    public static final NBTEncoder<Boolean, NBTTagByte> booleanEncoder = new NBTEncoder<Boolean, NBTTagByte>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Boolean;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagByte && (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz));
        }

        @Override
        public NBTTagByte toNBT(MBT mbt, Boolean b) {
            return new NBTTagByte((byte)(b != false ? 1 : 0));
        }

        @Override
        public Boolean fromNBT(MBT mbt, NBTTagByte nbt, Class<Boolean> clazz, Class ... tsclasses) {
            return nbt.func_150290_f() == 1;
        }
    };
    public static final NBTEncoder<Byte, NBTTagByte> byteEncoder = new NBTEncoder<Byte, NBTTagByte>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Byte;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagByte;
        }

        @Override
        public NBTTagByte toNBT(MBT mbt, Byte b) {
            return new NBTTagByte(b.byteValue());
        }

        @Override
        public Byte fromNBT(MBT mbt, NBTTagByte nbt, Class<Byte> clazz, Class ... tsclasses) {
            return nbt.func_150290_f();
        }
    };
    public static final NBTEncoder<Short, NBTTagShort> shortEncoder = new NBTEncoder<Short, NBTTagShort>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Short;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagShort;
        }

        @Override
        public NBTTagShort toNBT(MBT mbt, Short s) {
            return new NBTTagShort(s.shortValue());
        }

        @Override
        public Short fromNBT(MBT mbt, NBTTagShort nbt, Class<Short> clazz, Class ... tsclasses) {
            return nbt.func_150289_e();
        }
    };
    public static final NBTEncoder<Integer, NBTTagInt> intEncoder = new NBTEncoder<Integer, NBTTagInt>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Integer;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagInt;
        }

        @Override
        public NBTTagInt toNBT(MBT mbt, Integer i) {
            return new NBTTagInt(i.intValue());
        }

        @Override
        public Integer fromNBT(MBT mbt, NBTTagInt nbt, Class<Integer> clazz, Class ... tsclasses) {
            return nbt.func_150287_d();
        }
    };
    public static final NBTEncoder<Long, NBTTagLong> longEncoder = new NBTEncoder<Long, NBTTagLong>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Long;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagLong;
        }

        @Override
        public NBTTagLong toNBT(MBT mbt, Long l) {
            return new NBTTagLong(l.longValue());
        }

        @Override
        public Long fromNBT(MBT mbt, NBTTagLong nbt, Class<Long> clazz, Class ... tsclasses) {
            return nbt.func_150291_c();
        }
    };
    public static final NBTEncoder<Float, NBTTagFloat> floatEncoder = new NBTEncoder<Float, NBTTagFloat>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Float;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagFloat;
        }

        @Override
        public NBTTagFloat toNBT(MBT mbt, Float f) {
            return new NBTTagFloat(f.floatValue());
        }

        @Override
        public Float fromNBT(MBT mbt, NBTTagFloat nbt, Class<Float> clazz, Class ... tsclasses) {
            return Float.valueOf(nbt.func_150288_h());
        }
    };
    public static final NBTEncoder<Double, NBTTagDouble> doubleEncoder = new NBTEncoder<Double, NBTTagDouble>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Double;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagDouble;
        }

        @Override
        public NBTTagDouble toNBT(MBT mbt, Double d) {
            return new NBTTagDouble(d.doubleValue());
        }

        @Override
        public Double fromNBT(MBT mbt, NBTTagDouble nbt, Class<Double> clazz, Class ... tsclasses) {
            return nbt.func_150286_g();
        }
    };
    public static final NBTEncoder<byte[], NBTTagByteArray> byteArrayEncoder = new NBTEncoder<byte[], NBTTagByteArray>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof byte[];
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagByteArray;
        }

        @Override
        public NBTTagByteArray toNBT(MBT mbt, byte[] bs) {
            return new NBTTagByteArray(bs);
        }

        @Override
        public byte[] fromNBT(MBT mbt, NBTTagByteArray nbt, Class<byte[]> clazz, Class ... tsclasses) {
            return nbt.func_150292_c();
        }
    };
    public static final NBTEncoder<int[], NBTTagIntArray> intArrayEncoder = new NBTEncoder<int[], NBTTagIntArray>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof int[];
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagIntArray;
        }

        @Override
        public NBTTagIntArray toNBT(MBT mbt, int[] is) {
            return new NBTTagIntArray(is);
        }

        @Override
        public int[] fromNBT(MBT mbt, NBTTagIntArray nbt, Class<int[]> clazz, Class ... tsclasses) {
            return nbt.func_150302_c();
        }
    };
    public static final NBTEncoder<String, NBTTagString> stringEncoder = new NBTEncoder<String, NBTTagString>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof String;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagString && String.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTTagString toNBT(MBT mbt, String s) {
            return new NBTTagString(s);
        }

        @Override
        public String fromNBT(MBT mbt, NBTTagString nbt, Class<String> clazz, Class ... tsclasses) {
            return nbt.func_150285_a_();
        }
    };
    public static final NBTEncoder<NBTBase, NBTBase> nbtEncoder = new NBTEncoder<NBTBase, NBTBase>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof NBTBase;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return NBTBase.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTBase toNBT(MBT mbt, NBTBase nbt) {
            return nbt;
        }

        @Override
        public NBTBase fromNBT(MBT mbt, NBTBase nbt, Class<NBTBase> clazz, Class ... tsclasses) {
            return nbt;
        }
    };
    public static final NBTEncoder<ItemStack, NBTTagCompound> itemStackEncoder = new NBTEncoder<ItemStack, NBTTagCompound>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof ItemStack;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return ItemStack.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTTagCompound toNBT(MBT mbt, ItemStack itemstack) {
            return itemstack.func_77955_b(new NBTTagCompound());
        }

        @Override
        public ItemStack fromNBT(MBT mbt, NBTTagCompound nbt, Class<ItemStack> clazz, Class ... tsclasses) {
            return new ItemStack(nbt);
        }
    };
    public static final NBTEncoder<UUID, NBTTagString> uuidEncoder = new NBTEncoder<UUID, NBTTagString>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof UUID;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagString && UUID.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTTagString toNBT(MBT mbt, UUID uuid) {
            return new NBTTagString(uuid.toString());
        }

        @Override
        public UUID fromNBT(MBT mbt, NBTTagString nbt, Class<UUID> clazz, Class ... tsclasses) {
            return UUID.fromString(nbt.func_150285_a_());
        }
    };
    public static final NBTEncoder<Enum, NBTTagString> enumEncoder = new NBTEncoder<Enum, NBTTagString>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Enum;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagString && clazz.isEnum();
        }

        @Override
        public NBTTagString toNBT(MBT mbt, Enum e) {
            return new NBTTagString(e.name());
        }

        @Override
        public Enum fromNBT(MBT mbt, NBTTagString nbt, Class<Enum> clazz, Class ... tsclasses) {
            return Enum.valueOf(clazz, nbt.func_150285_a_());
        }
    };
    public static final NBTEncoder<Object, NBTTagCompound> nullEncoder = new NBTEncoder<Object, NBTTagCompound>(){
        public static final String NULL = "#NULL";

        @Override
        public boolean canEncode(Object o) {
            return o == null;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b(NULL) && ((NBTTagCompound)nbt).func_74779_i(NULL).equals(NULL);
        }

        @Override
        public NBTTagCompound toNBT(MBT mbt, Object t) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a(NULL, NULL);
            return nbt;
        }

        @Override
        public Object fromNBT(MBT mbt, NBTTagCompound nbt, Class<Object> clazz, Class ... tsclasses) {
            return null;
        }
    };
    public static final NBTEncoder<Object[], NBTTagList> arrayEncoder = new NBTEncoder<Object[], NBTTagList>(){

        @Override
        public boolean canEncode(Object o) {
            return o.getClass().isArray();
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagList && clazz.isArray();
        }

        @Override
        public NBTTagList toNBT(MBT mbt, Object[] os) {
            NBTTagList nlist = new NBTTagList();
            for (Object o : os) {
                nlist.func_74742_a(mbt.toNBT(o));
            }
            return nlist;
        }

        @Override
        public Object[] fromNBT(MBT mbt, NBTTagList list, Class<Object[]> clazz, Class ... tsclasses) {
            Object[] os = (Object[])Array.newInstance(clazz.getComponentType(), 0);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                os = ArrayUtils.add((Object[])os, mbt.fromNBT(list.func_179238_g(i), clazz.getComponentType(), new Class[0]));
            }
            return os;
        }
    };
    public static final NBTEncoder<List<?>, NBTTagList> listEncoder = new NBTEncoder<List<?>, NBTTagList>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof List;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagList && List.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTTagList toNBT(MBT mbt, List<?> list) {
            NBTTagList nlist = new NBTTagList();
            for (Object o : list) {
                nlist.func_74742_a(mbt.toNBT(o));
            }
            return nlist;
        }

        @Override
        public List<Object> fromNBT(MBT mbt, NBTTagList nlist, Class<List<?>> clazz, Class ... tsclasses) {
            try {
                List<Object> list;
                try {
                    list = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    list = new ArrayList();
                }
                for (int i = 0; i < nlist.func_74745_c(); ++i) {
                    list.add(mbt.fromNBT(nlist.func_179238_g(i), tsclasses[0], new Class[0]));
                }
                return list;
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static final NBTEncoder<Set<?>, NBTTagList> setEncoder = new NBTEncoder<Set<?>, NBTTagList>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Set;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagList && Set.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTTagList toNBT(MBT mbt, Set<?> set) {
            NBTTagList list = new NBTTagList();
            for (Object o : set) {
                list.func_74742_a(mbt.toNBT(o));
            }
            return list;
        }

        @Override
        public Set<Object> fromNBT(MBT mbt, NBTTagList list, Class<Set<?>> clazz, Class ... tsclasses) {
            try {
                Set<Object> set;
                try {
                    set = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    set = new HashSet();
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    set.add(mbt.fromNBT(list.func_179238_g(i), tsclasses[0], new Class[0]));
                }
                return set;
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static final NBTEncoder<Map<?, ?>, NBTTagList> mapEncoder = new NBTEncoder<Map<?, ?>, NBTTagList>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Map;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagList && Map.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTTagList toNBT(MBT mbt, Map<?, ?> map) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry<?, ?> e : map.entrySet()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("key", mbt.toNBT(e.getKey()));
                tag.func_74782_a("value", mbt.toNBT(e.getValue()));
                list.func_74742_a((NBTBase)tag);
            }
            return list;
        }

        @Override
        public Map<?, ?> fromNBT(MBT mbt, NBTTagList list, Class<Map<?, ?>> clazz, Class ... tsclasses) {
            try {
                Map<?, ?> map;
                try {
                    map = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    map = new HashMap();
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    map.put(mbt.fromNBT(tag.func_74781_a("key"), tsclasses[0], new Class[0]), mbt.fromNBT(tag.func_74781_a("value"), tsclasses[1], new Class[0]));
                }
                return map;
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static final NBTEncoder<Multimap<?, ?>, NBTTagList> multimapEncoder = new NBTEncoder<Multimap<?, ?>, NBTTagList>(){

        @Override
        public boolean canEncode(Object o) {
            return o instanceof Multimap;
        }

        @Override
        public boolean canDecode(NBTBase nbt, Class clazz) {
            return nbt instanceof NBTTagList && Multimap.class.isAssignableFrom(clazz);
        }

        @Override
        public NBTTagList toNBT(MBT mbt, Multimap<?, ?> map) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry e : map.entries()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("key", mbt.toNBT(e.getKey()));
                tag.func_74782_a("value", mbt.toNBT(e.getValue()));
                list.func_74742_a((NBTBase)tag);
            }
            return list;
        }

        @Override
        public Multimap<?, ?> fromNBT(MBT mbt, NBTTagList list, Class<Multimap<?, ?>> clazz, Class ... tsclasses) {
            try {
                HashMultimap map;
                try {
                    map = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    map = HashMultimap.create();
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    map.put(mbt.fromNBT(tag.func_74781_a("key"), tsclasses[0], new Class[0]), mbt.fromNBT(tag.func_74781_a("value"), tsclasses[1], new Class[0]));
                }
                return map;
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static final NBTEncoder<? extends Object, NBTTagCompound> classEncoder = new NBTClassEncoder(false, false, false, false);
    @Deprecated
    public static final NBTEncoder<? extends Object, NBTTagCompound> classEncoderSt = new NBTClassEncoder(false, false, true, false);
    @Deprecated
    public static final NBTEncoder<? extends Object, NBTTagCompound> classEncoderSu = new NBTClassEncoder(false, false, false, true);
    @Deprecated
    public static final NBTEncoder<? extends Object, NBTTagCompound> classEncoderStSu = new NBTClassEncoder(false, false, true, true);

    public boolean canEncode(Object var1);

    public boolean canDecode(NBTBase var1, Class var2);

    public NT toNBT(MBT var1, T var2);

    public T fromNBT(MBT var1, NT var2, Class<T> var3, Class ... var4);
}

