/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.client.debug;

import code.elix_x.excomms.reflection.ReflectionHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.lwjgl.input.Keyboard;

public class AdvancedDebugTools {
    private static Map<Integer, DebugTool> debugTools = new HashMap<Integer, DebugTool>();
    private static Map<Integer, DebugTool> guiDebugTools = new HashMap<Integer, DebugTool>();

    public static void register(int key, DebugTool tool) {
        assert (!debugTools.containsKey(key)) : "Tool already registered for key " + key + "!";
        debugTools.put(key, tool);
    }

    public static void registerGUI(int key, DebugTool tool) {
        assert (!guiDebugTools.containsKey(key)) : "Tool already registered for key " + key + "!";
        guiDebugTools.put(key, tool);
    }

    public static void clinit() {
    }

    @SubscribeEvent
    public static void keyPressed(InputEvent.KeyInputEvent event) {
        if (Keyboard.getEventKey() == 61 && GuiScreen.func_175283_s()) {
            for (Map.Entry<Integer, DebugTool> e : debugTools.entrySet()) {
                if (!Keyboard.isKeyDown((int)e.getKey())) continue;
                e.getValue().toggle();
            }
        }
    }

    @SubscribeEvent
    public static void guiKeyPressed(GuiScreenEvent.KeyboardInputEvent event) {
        if (Keyboard.getEventKey() == 61 && GuiScreen.func_175283_s()) {
            for (Map.Entry<Integer, DebugTool> e : guiDebugTools.entrySet()) {
                if (!Keyboard.isKeyDown((int)e.getKey())) continue;
                e.getValue().toggle();
            }
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(AdvancedDebugTools.class);
        AdvancedDebugTools.register(25, new VanillaDebugTool("Path Finding", "pathfindingEnabled", "field_190080_f"));
        AdvancedDebugTools.register(17, new VanillaDebugTool("Water", "waterEnabled", "field_190081_g"));
        AdvancedDebugTools.register(36, new VanillaDebugTool("Height Map", "heightMapEnabled", "field_190082_h"));
        AdvancedDebugTools.register(47, new VanillaDebugTool("Collision Box", "collisionBoxEnabled", "field_191326_j"));
        AdvancedDebugTools.register(50, new VanillaDebugTool("Neighbors Update", "neighborsUpdateEnabled", "field_191558_l"));
        AdvancedDebugTools.register(44, new VanillaDebugTool("Solid Face", "solidFaceEnabled", "field_193853_n"));
    }

    public static class VanillaDebugTool
    implements DebugTool {
        private final String name;
        private final ReflectionHelper.AField<DebugRenderer, Boolean> field;

        public VanillaDebugTool(String name, String ... names) {
            this.name = name;
            this.field = (ReflectionHelper.AField)new ReflectionHelper.AClass<DebugRenderer>(DebugRenderer.class).getDeclaredField(names).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to initialize vanilla debug tool for %s using following field names: %s", name, names))).setAccessible(true);
        }

        @Override
        public void toggle() {
            boolean b = this.field.get(Minecraft.func_71410_x().field_184132_p).get() == false;
            this.field.set(Minecraft.func_71410_x().field_184132_p, (Object)b);
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(new TextComponentString("").func_150257_a(new TextComponentString("[Advanced Debug]: ").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD).func_150227_a(Boolean.valueOf(true)))).func_150258_a(String.format("%s: %s", this.name, b ? "shown" : "hidden")));
        }
    }

    public static interface DebugTool {
        public void toggle();
    }
}

