/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import blusunrize.immersiveengineering.common.util.Utils;
import malte0811.industrialwires.util.LocalSidedWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public enum Material {
    COPPER(8.96, 220.0, "blocks/storage_copper"),
    ALUMINUM(2.7, 45.0, "blocks/storage_aluminum"),
    LEAD(11.34, 12.0, "blocks/storage_lead"),
    SILVER(10.49, 170.0, "blocks/storage_silver"),
    NICKEL(8.908, 165.0, "blocks/storage_nickel"),
    GOLD(19.3, 100.0, new ResourceLocation("minecraft", "blocks/gold_block")),
    URANIUM(19.1, 400.0, "blocks/storage_uranium_side"),
    CONSTANTAN(8.885, 600.0, "blocks/storage_constantan"),
    ELECTRUM((Material.SILVER.density + Material.GOLD.density) / 2000.0, (Material.SILVER.tensileStrength + Material.GOLD.tensileStrength) / 2000000.0, "blocks/storage_electrum"),
    STEEL(7.874, 1250.0, "blocks/storage_steel"),
    IRON(7.874, 350.0, new ResourceLocation("minecraft", "blocks/iron_block")),
    DIAMOND(3.5, 2800.0, new ResourceLocation("minecraft", "blocks/diamond_block"));

    public final double density;
    public final double tensileStrength;
    public final ResourceLocation blockTexture;

    private Material(double density, double tensileStrength, String path) {
        this.density = density * 1000.0;
        this.tensileStrength = tensileStrength * 1000000.0;
        this.blockTexture = new ResourceLocation("immersiveengineering", path);
    }

    private Material(double density, double tensileStrength, ResourceLocation loc) {
        this.density = density * 1000.0;
        this.tensileStrength = tensileStrength * 1000000.0;
        this.blockTexture = loc;
    }

    public boolean matchesBlock(ItemStack block, String prefix) {
        int[] ids;
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)block)) {
            if (!OreDictionary.getOreName((int)i).equalsIgnoreCase(prefix + this.oreName())) continue;
            return true;
        }
        return false;
    }

    public String oreName() {
        return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
    }

    public boolean matchesBlock(LocalSidedWorld w, BlockPos relative, String prefix) {
        return Utils.isOreBlockAt((World)w.getWorld(), (BlockPos)w.getRealPos(relative), (String)(prefix + this.oreName()));
    }
}

