/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class SevenSegDisplay
extends PanelComponent
implements IConfigurableComponent {
    public static final String NAME = "7seg";
    private static final float sizeX = 0.09375f;
    private static final float sizeY = 0.1875f;
    private static final boolean[][] numbers = new boolean[][]{{true, true, true, false, true, true, true}, {false, false, true, false, false, true, false}, {true, false, true, true, true, false, true}, {true, false, true, true, false, true, true}, {false, true, true, true, false, true, false}, {true, true, false, true, false, true, true}, {true, true, false, true, true, true, true}, {true, false, true, false, false, true, false}, {true, true, true, true, true, true, true}, {true, true, true, true, false, true, true}, {true, true, true, true, true, true, false}, {false, true, false, true, true, true, true}, {true, true, false, false, true, false, true}, {false, false, true, true, true, true, true}, {true, true, false, true, true, false, true}, {true, true, false, true, true, false, false}};
    @SideOnly(value=Side.CLIENT)
    private static Vec2f[][] positions;
    private int color = 65280;
    private byte input = 0;
    @Nonnull
    private ControlPanelNetwork.RSChannel inputChannel = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;

    public SevenSegDisplay() {
        super(NAME);
    }

    public SevenSegDisplay(@Nonnull ControlPanelNetwork.RSChannel in, int color) {
        this();
        this.color = color;
        this.inputChannel = in;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        nbt.func_74768_a("rsId", this.inputChannel.getController());
        nbt.func_74774_a("rsChannel", this.inputChannel.getColor());
        nbt.func_74768_a("color", this.color);
        if (!toItem) {
            nbt.func_74768_a("rsInput", (int)this.input);
        }
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        int rsController = nbt.func_74762_e("rsId");
        byte rsColor = nbt.func_74771_c("rsChannel");
        this.inputChannel = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        this.color = nbt.func_74762_e("color");
        this.input = nbt.func_74771_c("rsInput");
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        Consumer<ControlPanelNetwork.RSChannelState> handler = inputNew -> {
            if (inputNew.getStrength() != this.input) {
                this.input = inputNew.getStrength();
                this.panel.func_70296_d();
                this.panel.triggerRenderUpdate();
            }
        };
        net.addListener(this, handler, this.inputChannel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        if (positions == null) {
            positions = new Vec2f[7][6];
            Vec2f[][] startAndEnd = new Vec2f[][]{{new Vec2f(0.0234375f, 0.046875f), new Vec2f(0.0703125f, 0.046875f)}, {new Vec2f(0.0234375f, 0.046875f), new Vec2f(0.0234375f, 0.09375f)}, {new Vec2f(0.0703125f, 0.046875f), new Vec2f(0.0703125f, 0.09375f)}, {new Vec2f(0.0234375f, 0.09375f), new Vec2f(0.0703125f, 0.09375f)}, {new Vec2f(0.0234375f, 0.09375f), new Vec2f(0.0234375f, 0.140625f)}, {new Vec2f(0.0703125f, 0.09375f), new Vec2f(0.0703125f, 0.140625f)}, {new Vec2f(0.0234375f, 0.140625f), new Vec2f(0.0703125f, 0.140625f)}};
            for (int i = 0; i < 7; ++i) {
                SevenSegDisplay.positions[i][2] = startAndEnd[i][0];
                SevenSegDisplay.positions[i][3] = startAndEnd[i][1];
                Vec2f dir = MiscUtils.scale(MiscUtils.subtract(startAndEnd[i][0], startAndEnd[i][1]), 0.125f);
                Vec2f perpend = MiscUtils.rotate90(dir);
                SevenSegDisplay.positions[i][1] = MiscUtils.add(MiscUtils.add(startAndEnd[i][1], perpend), dir);
                SevenSegDisplay.positions[i][5] = MiscUtils.add(MiscUtils.subtract(startAndEnd[i][1], perpend), dir);
                SevenSegDisplay.positions[i][0] = MiscUtils.subtract(MiscUtils.add(startAndEnd[i][0], perpend), dir);
                SevenSegDisplay.positions[i][4] = MiscUtils.subtract(MiscUtils.subtract(startAndEnd[i][0], perpend), dir);
            }
        }
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>();
        PanelUtils.addColoredQuad(ret, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.1875f), new Vector3f(0.09375f, 0.0f, 0.1875f), new Vector3f(0.09375f, 0.0f, 0.0f), EnumFacing.UP, BLACK);
        float[] colorOn = PanelUtils.getFloatColor(true, this.color);
        float[] colorOff = PanelUtils.getFloatColor(false, this.color);
        for (int i = 0; i < 7; ++i) {
            float[] colorToUse = numbers[this.input][i] ? colorOn : colorOff;
            Vec2f[] pointsForSegment = positions[i];
            PanelUtils.addColoredQuad(ret, MiscUtils.withNewY(pointsForSegment[1], 0.001f), MiscUtils.withNewY(pointsForSegment[0], 0.001f), MiscUtils.withNewY(pointsForSegment[2], 0.001f), MiscUtils.withNewY(pointsForSegment[3], 0.001f), EnumFacing.UP, colorToUse);
            PanelUtils.addColoredQuad(ret, MiscUtils.withNewY(pointsForSegment[3], 0.001f), MiscUtils.withNewY(pointsForSegment[2], 0.001f), MiscUtils.withNewY(pointsForSegment[4], 0.001f), MiscUtils.withNewY(pointsForSegment[5], 0.001f), EnumFacing.UP, colorToUse);
        }
        return ret;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        SevenSegDisplay ret = new SevenSegDisplay(this.inputChannel, this.color);
        ret.input = this.input;
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + 0.09375f), 0.0, (double)(this.y + 0.1875f));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRelative, EntityPlayerMP player) {
    }

    @Override
    public void update() {
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public float getHeight() {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        this.color |= 0xFF000000;
        this.renderInGUIDefault(gui, -16777216);
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        int left = (int)((double)gui.getX0() + (aabb.field_72340_a + 0.0234375) * (double)gui.panelSize);
        int top = (int)((double)gui.getY0() + (aabb.field_72339_c + 0.046875) * (double)gui.panelSize);
        int sizeX = (int)(0.046875f * (float)gui.panelSize);
        int sizeY = (int)(0.09375f * (float)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)(left + sizeX), (int)(top + sizeY), (int)this.color);
        boolean width = true;
        Gui.func_73734_a((int)(left + 1), (int)(top + 1), (int)(left + sizeX - 1), (int)(top + sizeY / 2 - 1), (int)-16777216);
        Gui.func_73734_a((int)(left + 1), (int)(top + sizeY / 2 + 1), (int)(left + sizeX - 1), (int)(top + sizeY - 1), (int)-16777216);
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case RS_CHANNEL: {
                this.inputChannel = this.inputChannel.withColor(value);
                break;
            }
            case INT: {
                this.inputChannel = this.inputChannel.withController(value);
                break;
            }
            case FLOAT: {
                this.color = PanelUtils.setColor(this.color, id, value);
            }
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return null;
            }
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)"industrialwires.desc.rschannel_info", (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)"industrialwires.desc.rsid_info", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.inputChannel.getColor())};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 45, this.inputChannel.getController(), 2, false)};
    }

    @Override
    public IConfigurableComponent.FloatConfig[] getFloatOptions() {
        float[] color = PanelUtils.getFloatColor(true, this.color);
        int x = 70;
        int yOffset = 10;
        return new IConfigurableComponent.FloatConfig[]{new IConfigurableComponent.FloatConfig("red", x, yOffset, Float.valueOf(color[0]), 60), new IConfigurableComponent.FloatConfig("green", x, yOffset + 20, Float.valueOf(color[1]), 60), new IConfigurableComponent.FloatConfig("blue", x, yOffset + 40, Float.valueOf(color[2]), 60)};
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SevenSegDisplay that = (SevenSegDisplay)o;
        if (this.color != that.color) {
            return false;
        }
        return this.input == that.input;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.color;
        result = 31 * result + this.input;
        return result;
    }
}

