/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.controlpanel.TileEntityPanel;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.CoveredToggleSwitch;
import malte0811.industrialwires.controlpanel.IndicatorLight;
import malte0811.industrialwires.controlpanel.Label;
import malte0811.industrialwires.controlpanel.LightedButton;
import malte0811.industrialwires.controlpanel.Lock;
import malte0811.industrialwires.controlpanel.PanelMeter;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.controlpanel.RGBIndicator;
import malte0811.industrialwires.controlpanel.SevenSegDisplay;
import malte0811.industrialwires.controlpanel.Slider;
import malte0811.industrialwires.controlpanel.ToggleSwitch;
import malte0811.industrialwires.controlpanel.Variac;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PanelComponent
implements ControlPanelNetwork.IOwner {
    public static final float Y_DELTA = 0.001f;
    protected static final float[] GRAY = new float[]{0.8f, 0.8f, 0.8f};
    protected static final int GRAY_INT = -3092272;
    protected static final float[] BLACK = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected float panelHeight;
    protected AxisAlignedBB aabb = null;
    protected float x;
    protected float y;
    private final String type;
    protected TileEntityPanel panel;
    protected ControlPanelNetwork network;
    public static final Map<String, Supplier<PanelComponent>> baseCreaters = new HashMap<String, Supplier<PanelComponent>>();

    protected PanelComponent(String type) {
        this.type = type;
    }

    public static void init() {
        baseCreaters.put("lighted_button", LightedButton::new);
        baseCreaters.put("label", Label::new);
        baseCreaters.put("indicator_light", IndicatorLight::new);
        baseCreaters.put("slider", Slider::new);
        baseCreaters.put("variac", Variac::new);
        baseCreaters.put("toggle_switch", ToggleSwitch::new);
        baseCreaters.put("toggle_switch_covered", CoveredToggleSwitch::new);
        baseCreaters.put("lock", Lock::new);
        baseCreaters.put("panel_meter", PanelMeter::new);
        baseCreaters.put("7seg", SevenSegDisplay::new);
        baseCreaters.put("rgb_led", RGBIndicator::new);
        boolean isDevEnv = "NBTTagCompound".equals(NBTTagCompound.class.getSimpleName());
        if (isDevEnv) {
            for (Supplier<PanelComponent> sup : baseCreaters.values()) {
                PanelComponent comp = sup.get();
                try {
                    comp.getClass().getDeclaredMethod("equals", Object.class);
                    comp.getClass().getDeclaredMethod("hashCode", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(comp.getClass() + " lacks equals or hasCode! This will break the cache!", e);
                }
            }
        }
    }

    protected abstract void writeCustomNBT(NBTTagCompound var1, boolean var2);

    protected abstract void readCustomNBT(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public abstract List<RawQuad> getQuads();

    @Nonnull
    public abstract PanelComponent copyOf();

    @Nonnull
    public abstract AxisAlignedBB getBlockRelativeAABB();

    public abstract void interactWith(Vec3d var1, EntityPlayerMP var2);

    public abstract void update();

    public abstract int getColor();

    public abstract float getHeight();

    public void setNetwork(ControlPanelNetwork net) {
        this.network = net;
    }

    public void dropItems() {
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
        this.aabb = null;
    }

    public void setY(float y) {
        this.y = y;
        this.aabb = null;
    }

    public void setPanelHeight(float panelHeight) {
        this.panelHeight = panelHeight;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.panel.func_174877_v();
    }

    public void writeToNBT(NBTTagCompound nbt, boolean toItem) {
        this.writeCustomNBT(nbt, toItem);
        nbt.func_74776_a("x", this.getX());
        nbt.func_74776_a("y", this.getY());
        nbt.func_74776_a("panelHeight", this.panelHeight);
        nbt.func_74778_a("type", this.type);
    }

    public static PanelComponent read(NBTTagCompound nbt) {
        String type = nbt.func_74779_i("type");
        if (baseCreaters.containsKey(type)) {
            PanelComponent ret = baseCreaters.get(type).get();
            ret.readFromNBT(nbt);
            return ret;
        }
        IndustrialWires.logger.warn("Unknown panel component: " + type);
        return null;
    }

    public final void readFromNBT(NBTTagCompound nbt) {
        this.readCustomNBT(nbt);
        this.setX(nbt.func_74760_g("x"));
        this.setY(nbt.func_74760_g("y"));
        this.setPanelHeight(nbt.func_74760_g("panelHeight"));
    }

    public boolean isValidPos(List<PanelComponent> components, float height, float angle) {
        float h = PanelUtils.getHeightWithComponent(this, angle, height);
        if (h < 0.0f || h > 1.0f) {
            return false;
        }
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        if (aabb.field_72340_a < 0.0 || aabb.field_72336_d > 1.0) {
            return false;
        }
        if (aabb.field_72339_c < 0.0 || aabb.field_72334_f > 1.0) {
            return false;
        }
        for (PanelComponent pc : components) {
            AxisAlignedBB otherBB;
            if (pc == this || !PanelUtils.intersectXZ(aabb, otherBB = pc.getBlockRelativeAABB())) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBox() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        this.panel.getComponents().transformGLForTop(this.panel.getBlockPos());
        RenderGlobal.func_189697_a((AxisAlignedBB)this.getBlockRelativeAABB().func_186662_g(0.002), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void renderInGUI(GuiPanelCreator var1);

    @SideOnly(value=Side.CLIENT)
    public void renderInGUIDefault(GuiPanelCreator gui, int color) {
        color |= 0xFF000000;
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        int left = (int)((double)gui.getX0() + aabb.field_72340_a * (double)gui.panelSize);
        int top = (int)((double)gui.getY0() + aabb.field_72339_c * (double)gui.panelSize);
        int right = (int)((double)gui.getX0() + aabb.field_72336_d * (double)gui.panelSize);
        int bottom = (int)((double)gui.getY0() + aabb.field_72334_f * (double)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PanelComponent that = (PanelComponent)o;
        if (Float.compare(that.panelHeight, this.panelHeight) != 0) {
            return false;
        }
        if (Float.compare(that.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(that.y, this.y) != 0) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.panelHeight != 0.0f ? Float.floatToIntBits(this.panelHeight) : 0;
        result = 31 * result + (this.x != 0.0f ? Float.floatToIntBits(this.x) : 0);
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public void setPanel(TileEntityPanel tile) {
        this.panel = tile;
    }
}

