/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import malte0811.industrialwires.controlpanel.ToggleSwitch;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class CoveredToggleSwitch
extends ToggleSwitch {
    private int color = 0xFF0000;
    private SwitchState state = SwitchState.CLOSED;

    public CoveredToggleSwitch() {
        super("toggle_switch_covered");
        this.sizeY = 0.125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        float[] color = PanelUtils.getFloatColor(true, this.color);
        this.active = this.state.active;
        List<RawQuad> ret = super.getQuads();
        Matrix4 rot = null;
        if (this.state.open) {
            rot = new Matrix4();
            rot.rotate(-1.2566370614359172, 1.0, 0.0, 0.0);
        }
        PanelUtils.addColoredBox(color, color, null, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(this.sizeX, this.getHeight(), this.sizeY), ret, false, rot, true);
        ret.remove(ret.size() - 2);
        ret.remove(ret.size() - 1);
        return ret;
    }

    @Override
    public void interactWith(Vec3d hitRel, EntityPlayerMP player) {
        this.state = player.func_70093_af() && this.state == SwitchState.OPEN ? SwitchState.CLOSED : this.state.next();
        this.setOut(this.state.active);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        super.renderInGUIDefault(gui, 0xFF000000 | this.color);
        super.renderInGUI(gui);
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        super.writeCustomNBT(nbt, toItem);
        if (!toItem) {
            nbt.func_74768_a("state", this.state.ordinal());
        }
        nbt.func_74768_a("color", this.color);
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.state = SwitchState.values()[nbt.func_74762_e("state")];
        this.color = nbt.func_74762_e("color");
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        CoveredToggleSwitch ret = new CoveredToggleSwitch();
        ret.color = this.color;
        ret.state = this.state;
        ret.outputChannel = this.outputChannel;
        ret.active = this.active;
        ret.setX(this.getX());
        ret.setY(this.getY());
        ret.setPanelHeight(this.panelHeight);
        return ret;
    }

    @Override
    public IConfigurableComponent.FloatConfig[] getFloatOptions() {
        float[] color = PanelUtils.getFloatColor(true, this.color);
        int x = 70;
        int yOffset = 10;
        return new IConfigurableComponent.FloatConfig[]{new IConfigurableComponent.FloatConfig("red", x, yOffset, Float.valueOf(color[0]), 60), new IConfigurableComponent.FloatConfig("green", x, yOffset + 20, Float.valueOf(color[1]), 60), new IConfigurableComponent.FloatConfig("blue", x, yOffset + 40, Float.valueOf(color[2]), 60)};
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        super.applyConfigOption(type, id, value);
        if (type == IConfigurableComponent.ConfigType.FLOAT) {
            this.color = PanelUtils.setColor(this.color, id, value);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        if (type == IConfigurableComponent.ConfigType.FLOAT) {
            return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
        }
        return super.fomatConfigName(type, id);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        if (type == IConfigurableComponent.ConfigType.FLOAT) {
            return null;
        }
        return super.fomatConfigDescription(type, id);
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CoveredToggleSwitch that = (CoveredToggleSwitch)o;
        if (this.color != that.color) {
            return false;
        }
        return this.state == that.state;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.color;
        result = 31 * result + this.state.hashCode();
        return result;
    }

    private static enum SwitchState {
        CLOSED(false, false),
        OPEN(false, true),
        ACTIVE(true, true);

        public boolean active;
        public boolean open;

        private SwitchState(boolean active, boolean open) {
            this.open = open;
            this.active = active;
        }

        SwitchState next() {
            return SwitchState.values()[(this.ordinal() + 1) % SwitchState.values().length];
        }
    }
}

