/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.hv;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import javax.annotation.Nonnull;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.TileEntityIWBase;
import malte0811.industrialwires.blocks.hv.TileEntityMarx;
import malte0811.industrialwires.hv.IMarxTarget;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityDischargeMeter
extends TileEntityIWBase
implements IEBlockInterfaces.IPlayerInteraction,
IMarxTarget,
IBlockBoundsIW.IBlockBoundsDirectional,
IEBlockInterfaces.IDirectionalTile {
    private static final String HAS_WIRE = "hasWire";
    private static final String FACING = "facing";
    private static final String LAST_DISCHARGE = "last";
    boolean hasWire;
    EnumFacing facing = EnumFacing.NORTH;
    double lastDischarge = -1.0;
    AxisAlignedBB aabb = null;

    @Override
    public void writeNBT(NBTTagCompound out, boolean updatePacket) {
        out.func_74774_a(FACING, (byte)this.facing.func_176736_b());
        out.func_74757_a(HAS_WIRE, this.hasWire);
        out.func_74780_a(LAST_DISCHARGE, this.lastDischarge);
    }

    @Override
    public void readNBT(NBTTagCompound in, boolean updatePacket) {
        this.hasWire = in.func_74767_n(HAS_WIRE);
        this.facing = EnumFacing.func_176731_b((int)in.func_74771_c(FACING));
        this.lastDischarge = in.func_74769_h(LAST_DISCHARGE);
        this.aabb = null;
    }

    public boolean interact(@Nonnull EnumFacing side, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasWire) {
                return false;
            }
            if (ApiUtils.compareToOreName((ItemStack)heldItem, (String)"wireAluminum")) {
                this.hasWire = true;
                heldItem.func_190918_g(1);
                this.triggerRenderUpdate();
            } else if (this.lastDischarge > 0.0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("industrialwires.chat.marxEnergy", new Object[]{String.format("%.1f", this.lastDischarge / 1000.0)}));
                this.lastDischarge = -1.0;
            }
            this.func_70296_d();
        }
        return true;
    }

    @Override
    public boolean onHit(double energy, TileEntityMarx master) {
        if (this.hasWire) {
            this.hasWire = false;
            this.lastDischarge = energy;
            this.triggerRenderUpdate();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBoxNoRot() {
        return new AxisAlignedBB(0.0625, 0.0, 0.3125, 0.625, (double)((this.hasWire ? 15.0f : 14.0f) / 16.0f), 0.6875);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        if (this.aabb == null) {
            this.aabb = IBlockBoundsIW.IBlockBoundsDirectional.super.getBoundingBox();
        }
        return this.aabb;
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return false;
    }
}

