/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.converter;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration0;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.MapMaker;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IEObjects;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.IBlockBoundsIW;
import malte0811.industrialwires.blocks.ISyncReceiver;
import malte0811.industrialwires.blocks.TileEntityIWMultiblock;
import malte0811.industrialwires.compat.Compat;
import malte0811.industrialwires.mech_mb.EUCapability;
import malte0811.industrialwires.mech_mb.IMBPartElectric;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechMBPart;
import malte0811.industrialwires.mech_mb.Waveform;
import malte0811.industrialwires.network.MessageTileSyncIW;
import malte0811.industrialwires.util.LocalSidedWorld;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2")})
public class TileEntityMechMB
extends TileEntityIWMultiblock
implements ITickable,
ISyncReceiver,
IEnergySource,
IEnergySink,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IRedstoneOutput,
IBlockBoundsIW.IBlockBoundsDirectional {
    private static final double DECAY_BASE = Math.exp(Math.log(0.95) / 72000.0);
    public static final double TICK_ANGLE_PER_SPEED = 2.864788975654116;
    private static final double SYNC_THRESHOLD = 0.95;
    private static final Map<BlockPos, TileEntityMechMB> CLIENT_MASTER_BY_POS = new MapMaker().weakValues().makeMap();
    public MechMBPart[] mechanical = null;
    int[] offsets = null;
    private int[][] electricalStartEnd = null;
    public MechEnergy energyState;
    private double lastSyncedSpeed = 0.0;
    private double decay;
    public double angle;
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> rotatingModel;
    private boolean firstTick = true;
    private int structureVersion = 0;
    private AxisAlignedBB rBB;
    public AxisAlignedBB aabb = null;

    /*
     * WARNING - void declaration
     */
    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking((TileEntity)this);
        if (this.firstTick && !this.field_145850_b.field_72995_K) {
            Compat.loadIC2Tile.accept(this);
            this.firstTick = false;
        }
        if (this.isLogicDummy() || this.mechanical == null || this.mechanical.length == 0) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.angle += this.energyState.getSpeed() * 2.864788975654116;
            this.angle %= 360.0;
            if (this.firstTick) {
                CLIENT_MASTER_BY_POS.put(this.field_174879_c, this);
            }
            if (this.energyState.clientUpdate() || this.firstTick) {
                IndustrialWires.proxy.updateMechMBTurningSound(this, this.energyState);
                TileEntity otherEnd = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177967_a(this.facing, -this.offsets[this.mechanical.length]));
                if (otherEnd instanceof TileEntityMechMB) {
                    IndustrialWires.proxy.updateMechMBTurningSound((TileEntityMechMB)otherEnd, this.energyState);
                }
            }
            return;
        }
        for (MechMBPart mechMBPart : this.mechanical) {
            mechMBPart.createMEnergy(this.energyState);
        }
        double requestSum = 0.0;
        IdentityHashMap<MechMBPart, Double> individualRequests = new IdentityHashMap<MechMBPart, Double>();
        for (MechMBPart part : this.mechanical) {
            double eForPart = part.requestMEnergy(this.energyState);
            requestSum += eForPart;
            individualRequests.put(part, eForPart);
        }
        double d = this.energyState.getEnergy() / 5.0;
        double factor = Math.min(d / requestSum, 1.0);
        this.energyState.extractEnergy(Math.min(requestSum, d));
        for (MechMBPart part : this.mechanical) {
            part.insertMEnergy(factor * (Double)individualRequests.get(part));
        }
        HashSet<MechMBPart> failed = new HashSet<MechMBPart>();
        for (MechMBPart part : this.mechanical) {
            if (!(this.energyState.getSpeed() > part.getMaxSpeed())) continue;
            failed.add(part);
        }
        if (!failed.isEmpty()) {
            this.disassemble(failed);
            return;
        }
        for (int[] section : this.electricalStartEnd) {
            void var18_30;
            int sectionLength = section[1] - section[0];
            double[] available = new double[sectionLength];
            Waveform[] availableWf = new Waveform[sectionLength];
            boolean hasEnergy = false;
            HashSet<Waveform> availableWaveforms = new HashSet<Waveform>();
            int n = section[0];
            while (var18_30 < section[1]) {
                Waveform localWf;
                IMBPartElectric electricalComp = (IMBPartElectric)((Object)this.mechanical[var18_30]);
                availableWf[var18_30 - section[0]] = localWf = electricalComp.getProduced(this.energyState).getForSpeed(this.energyState.getSpeed());
                if (localWf.isEnergyWaveform()) {
                    double availableLocal;
                    available[var18_30 - section[0]] = availableLocal = electricalComp.getAvailableEEnergy(this.energyState);
                    availableWaveforms.add(localWf);
                    if (availableLocal > 0.0) {
                        hasEnergy = true;
                    }
                }
                ++var18_30;
            }
            if (!hasEnergy) continue;
            ArrayList arrayList = new ArrayList(availableWaveforms);
            double[][] requested = new double[arrayList.size()][sectionLength];
            for (int i = 0; i < requested.length; ++i) {
                Waveform wf = (Waveform)arrayList.get(i);
                if (!wf.isEnergyWaveform()) continue;
                for (int j = 0; j < sectionLength; ++j) {
                    requested[i][j] = ((IMBPartElectric)((Object)this.mechanical[j + section[0]])).requestEEnergy(wf, this.energyState);
                }
            }
            int maxId = -1;
            double maxTransferred = 0.0;
            for (int i = 0; i < requested.length; ++i) {
                Waveform wf = (Waveform)arrayList.get(i);
                double transferred = this.transferElectric(section, Arrays.copyOf(available, sectionLength), availableWf, wf, Arrays.copyOf(requested[i], sectionLength), true);
                if (!(transferred > maxTransferred)) continue;
                maxTransferred = transferred;
                maxId = i;
            }
            if (maxId < 0) {
                int i;
                double[] availablePerWf = new double[availableWaveforms.size()];
                for (i = 0; i < availableWf.length; ++i) {
                    if (!availableWf[i].isEnergyWaveform()) continue;
                    int n2 = arrayList.indexOf(availableWf[i]);
                    availablePerWf[n2] = availablePerWf[n2] + available[i];
                }
                for (i = 0; i < availablePerWf.length; ++i) {
                    if (!(availablePerWf[i] > 0.0) || maxId >= 0 && !(availablePerWf[maxId] < availablePerWf[i])) continue;
                    maxId = i;
                }
            }
            if (maxId < 0) continue;
            this.transferElectric(section, available, availableWf, (Waveform)arrayList.get(maxId), requested[maxId], false);
        }
        this.energyState.decaySpeed(this.decay);
        this.func_70296_d();
        if (this.lastSyncedSpeed < this.energyState.getSpeed() * 0.95 || this.lastSyncedSpeed > this.energyState.getSpeed() / 0.95) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74780_a("speed", this.energyState.getSpeed());
            IndustrialWires.packetHandler.sendToDimension((IMessage)new MessageTileSyncIW(this, nBTTagCompound), this.field_145850_b.field_73011_w.getDimension());
            this.lastSyncedSpeed = this.energyState.getSpeed();
        }
    }

    public void func_145834_a(@Nonnull World worldIn) {
        super.func_145834_a(worldIn);
        if (!this.isLogicDummy()) {
            int offset = 1;
            for (MechMBPart part : this.mechanical) {
                part.world.setWorld(this.field_145850_b);
                part.world.setOrigin(MiscUtils.offset(this.field_174879_c, this.facing, this.mirrored, 0, -offset, 0));
                offset += part.getLength();
            }
        }
    }

    public IBlockState getExtState(IBlockState in) {
        TileEntityMechMB master = CLIENT_MASTER_BY_POS.get(this.field_174879_c.func_177973_b(this.offset));
        if (master == null) {
            return in;
        }
        BlockPos offsetDirectional = this.getOffsetDir();
        int id = this.getPart(offsetDirectional.func_177952_p(), master);
        if (id < 0) {
            return in;
        }
        MechMBPart part = master.mechanical[id];
        return part.getExtState(in);
    }

    private double transferElectric(int[] section, double[] available, Waveform[] availableWf, Waveform waveform, double[] requested, boolean simulate) {
        int i0;
        int i;
        int i2;
        double totalAvailable = 0.0;
        double totalRequested = 0.0;
        for (i2 = 0; i2 < available.length; ++i2) {
            if (!availableWf[i2].equals(waveform)) {
                available[i2] = 0.0;
            }
            totalRequested += requested[i2];
        }
        for (i2 = 0; i2 < available.length; ++i2) {
            if (!(available[i2] > 0.0)) continue;
            available[i2] = Math.min(available[i2], totalRequested - requested[i2]);
            totalAvailable += available[i2];
        }
        double[] ins = new double[section[1] - section[0]];
        double[] extracted = new double[section[1] - section[0]];
        if (totalAvailable > 0.0) {
            for (i = section[0]; i < section[1]; ++i) {
                i0 = i - section[0];
                double otherRequests = totalRequested - requested[i0];
                double extractFactor = Math.min(1.0, otherRequests / totalAvailable);
                double extr = available[i0] * extractFactor;
                if (extr == 0.0) continue;
                for (int j = 0; j < section[1] - section[0]; ++j) {
                    if (j == i0) continue;
                    int n = j;
                    ins[n] = ins[n] + extr * (requested[j] / otherRequests);
                }
                extracted[i0] = extr;
                if (simulate) continue;
                IMBPartElectric electric = (IMBPartElectric)((Object)this.mechanical[i]);
                electric.extractEEnergy(extr, this.energyState);
            }
        }
        if (!simulate) {
            for (i = section[0]; i < section[1]; ++i) {
                i0 = i - section[0];
                IMBPartElectric electric = (IMBPartElectric)((Object)this.mechanical[i]);
                electric.insertEEnergy(ins[i0], waveform, this.energyState);
            }
        }
        double totalTransf = 0.0;
        for (int i3 = 0; i3 < section[1] - section[0]; ++i3) {
            totalTransf += Math.abs(ins[i3] - extracted[i3]);
        }
        return totalTransf;
    }

    @Override
    public void writeNBT(NBTTagCompound out, boolean updatePacket) {
        super.writeNBT(out, updatePacket);
        if (this.mechanical != null) {
            NBTTagList mechParts = new NBTTagList();
            for (MechMBPart part : this.mechanical) {
                mechParts.func_74742_a((NBTBase)MechMBPart.toNBT(part));
            }
            out.func_74782_a("parts", (NBTBase)mechParts);
            out.func_74780_a("speed", this.energyState.getSpeed());
        }
        out.func_74768_a("version", this.structureVersion);
    }

    @Override
    public void readNBT(NBTTagCompound in, boolean updatePacket) {
        super.readNBT(in, updatePacket);
        if (in.func_150297_b("parts", 9)) {
            NBTTagList mechParts = in.func_150295_c("parts", 10);
            MechMBPart[] mech = new MechMBPart[mechParts.func_74745_c()];
            int offset = 1;
            for (int i = 0; i < mechParts.func_74745_c(); ++i) {
                mech[i] = MechMBPart.fromNBT(mechParts.func_150305_b(i), new LocalSidedWorld(this.field_145850_b, MiscUtils.offset(this.field_174879_c, this.facing, this.mirrored, 0, -offset, 0), this.facing.func_176734_d(), this.mirrored));
                offset += mech[i].getLength();
            }
            this.setMechanical(mech, in.func_74769_h("speed"));
        }
        this.structureVersion = in.func_74762_e("version");
        this.rBB = null;
        this.aabb = null;
    }

    public void setMechanical(MechMBPart[] mech, double speed) {
        this.mechanical = mech;
        this.offsets = new int[this.mechanical.length + 1];
        double weight = 0.0;
        int offset = 1;
        ArrayList<int[]> electrical = new ArrayList<int[]>();
        int lastEStart = -1;
        for (int i = 0; i < mech.length; ++i) {
            this.offsets[i] = offset;
            weight += this.mechanical[i].getInertia();
            offset += this.mechanical[i].getLength();
            if (lastEStart < 0 && this.mechanical[i] instanceof IMBPartElectric) {
                lastEStart = i;
                continue;
            }
            if (lastEStart < 0 || this.mechanical[i] instanceof IMBPartElectric) continue;
            electrical.add(new int[]{lastEStart, i});
            lastEStart = -1;
        }
        this.offsets[this.mechanical.length] = offset;
        if (lastEStart >= 0) {
            electrical.add(new int[]{lastEStart, this.mechanical.length});
        }
        this.electricalStartEnd = (int[][])electrical.toArray((T[])new int[electrical.size()][]);
        this.decay = Math.pow(DECAY_BASE, this.mechanical.length);
        if (this.energyState != null) {
            this.energyState.invalid = true;
        }
        this.energyState = new MechEnergy(weight, speed);
    }

    private int getPart(int offset, TileEntityMechMB master) {
        if (offset == 0) {
            return -1;
        }
        int pos = 1;
        MechMBPart[] mechMaster = master.mechanical;
        if (mechMaster != null) {
            int mechanical1Length = mechMaster.length;
            for (int i = 0; i < mechanical1Length; ++i) {
                MechMBPart part = mechMaster[i];
                if (pos >= offset) {
                    return i;
                }
                pos += part.getLength();
            }
        }
        return -1;
    }

    @Override
    @Nonnull
    protected BlockPos getOrigin() {
        return this.field_174879_c;
    }

    @Override
    public IBlockState getOriginalBlock() {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public ItemStack getOriginalItem() {
        BlockPos offsetDirectional = this.getOffsetDir();
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(offsetDirectional.func_177952_p(), master);
        if (id < 0) {
            return new ItemStack(IEObjects.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.ordinal());
        }
        MechMBPart part = master.mechanical[id];
        BlockPos offsetPart = new BlockPos(offsetDirectional.func_177958_n(), offsetDirectional.func_177956_o(), offsetDirectional.func_177952_p() - master.offsets[id]);
        return part.getOriginalItem(offsetPart);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSync(NBTTagCompound nbt) {
        this.energyState.setTargetSpeed(nbt.func_74769_h("speed"));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.rBB == null) {
            this.rBB = this.isLogicDummy() ? new AxisAlignedBB(this.field_174879_c, this.field_174879_c) : new AxisAlignedBB(MiscUtils.offset(this.field_174879_c, this.facing, this.mirrored, -2, 0, -2), MiscUtils.offset(this.field_174879_c, this.facing, this.mirrored, 2, -this.mechanical.length, 2));
        }
        return this.rBB;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        BlockPos offsetDirectional = this.getOffsetDir();
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(offsetDirectional.func_177952_p(), master);
        if (id < 0) {
            return false;
        }
        MechMBPart part = master.mechanical[id];
        BlockPos offsetPart = new BlockPos(offsetDirectional.func_177958_n(), offsetDirectional.func_177956_o(), offsetDirectional.func_177952_p() - master.offsets[id]);
        return part.hasCapability(capability, part.world.realToTransformed(facing), offsetPart);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        BlockPos offsetDirectional = this.getOffsetDir();
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(offsetDirectional.func_177952_p(), master);
        if (id < 0) {
            return null;
        }
        MechMBPart part = master.mechanical[id];
        BlockPos offsetPart = new BlockPos(offsetDirectional.func_177958_n(), offsetDirectional.func_177956_o(), offsetDirectional.func_177952_p() - master.offsets[id]);
        return part.getCapability(capability, part.world.realToTransformed(facing), offsetPart);
    }

    @Override
    public void disassemble() {
        TileEntityMechMB master;
        double MIN_BREAK = 0.1;
        double MIN_BREAK_BROKEN = 0.5;
        if (this.formed && (master = this.master(this)) != null) {
            int partId = master.getPart(this.offset.func_177958_n(), master);
            MechMBPart broken = null;
            if (partId >= 0) {
                broken = master.mechanical[partId];
            }
            HashSet<MechMBPart> failed = new HashSet<MechMBPart>();
            for (MechMBPart part : master.mechanical) {
                double d = master.energyState.getSpeed();
                double d2 = part == broken ? 0.5 : 0.1;
                if (!(d > d2 * part.getMaxSpeed())) continue;
                failed.add(part);
            }
            master.disassemble(failed);
            try {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                NonNullList drops = NonNullList.func_191196_a();
                state.func_177230_c().getDrops(drops, (IBlockAccess)this.field_145850_b, this.field_174879_c, state, 0);
                this.field_145850_b.func_175698_g(this.field_174879_c);
                for (ItemStack s : drops) {
                    Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)s);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private void disassemble(Set<MechMBPart> failed) {
        if (!this.field_145850_b.field_72995_K && this.formed) {
            this.formed = false;
            this.field_145850_b.func_175656_a(this.field_174879_c, IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.HEAVY_ENGINEERING));
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.HEAVY_ENGINEERING));
            for (MechMBPart mech : this.mechanical) {
                if (failed.contains(mech)) {
                    this.field_145850_b.func_184133_a(null, mech.world.getOrigin(), IndustrialWires.MMB_BREAKING, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    mech.breakOnFailure(this.energyState);
                } else {
                    mech.disassemble();
                }
                for (int l = 0; l < mech.getLength(); ++l) {
                    short pattern = mech.getFormPattern(l);
                    for (int i = 0; i < 9; ++i) {
                        BlockPos pos;
                        if ((pattern >> i & 1) == 0 || mech.world.getBlockState(pos = new BlockPos(i % 3 - 1, i / 3 - 1, -l)).func_177230_c() != IndustrialWires.mechanicalMB) continue;
                        mech.world.setBlockState(pos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            BlockPos otherEnd = MiscUtils.offset(this.field_174879_c, this.facing.func_176734_d(), this.mirrored, 0, this.offsets[this.mechanical.length], 0);
            this.field_145850_b.func_175656_a(otherEnd, IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.HEAVY_ENGINEERING));
            this.field_145850_b.func_175656_a(otherEnd.func_177977_b(), IEObjects.blockMetalDecoration0.func_176223_P().func_177226_a((IProperty)IEObjects.blockMetalDecoration0.property, (Comparable)BlockTypes_MetalDecoration0.HEAVY_ENGINEERING));
        }
    }

    private EUCapability.IC2EnergyHandler getIC2Cap() {
        return EUCapability.ENERGY_IC2 != null ? this.getCapability(EUCapability.ENERGY_IC2, null) : null;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor output, EnumFacing side) {
        if (EUCapability.ENERGY_IC2 == null) {
            return false;
        }
        BlockPos offsetDirectional = this.getOffsetDir();
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(offsetDirectional.func_177952_p(), master);
        if (id < 0) {
            return false;
        }
        MechMBPart part = master.mechanical[id];
        BlockPos offsetPart = new BlockPos(offsetDirectional.func_177958_n(), offsetDirectional.func_177956_o(), offsetDirectional.func_177952_p() - master.offsets[id]);
        EUCapability.IC2EnergyHandler cap = part.getCapability(EUCapability.ENERGY_IC2, part.world.realToTransformed(side), offsetPart);
        return cap != null;
    }

    public double getDemandedEnergy() {
        EUCapability.IC2EnergyHandler cap = this.getIC2Cap();
        return cap != null ? cap.getDemandedEnergy() : 0.0;
    }

    public int getSinkTier() {
        EUCapability.IC2EnergyHandler cap = this.getIC2Cap();
        return cap != null ? cap.getEnergyTier() : 0;
    }

    public double injectEnergy(EnumFacing enumFacing, double amount, double voltage) {
        EUCapability.IC2EnergyHandler cap = this.getIC2Cap();
        return cap != null ? cap.injectEnergy(enumFacing, amount, voltage) : 0.0;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter input, EnumFacing side) {
        if (EUCapability.ENERGY_IC2 == null) {
            return false;
        }
        BlockPos offsetDirectional = this.getOffsetDir();
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(offsetDirectional.func_177952_p(), master);
        if (id < 0) {
            return false;
        }
        MechMBPart part = master.mechanical[id];
        BlockPos offsetPart = new BlockPos(offsetDirectional.func_177958_n(), offsetDirectional.func_177956_o(), offsetDirectional.func_177952_p() - master.offsets[id]);
        EUCapability.IC2EnergyHandler cap = part.getCapability(EUCapability.ENERGY_IC2, part.world.realToTransformed(side), offsetPart);
        return cap != null;
    }

    public double getOfferedEnergy() {
        EUCapability.IC2EnergyHandler cap = this.getIC2Cap();
        return cap != null ? cap.getOfferedEnergy() : 0.0;
    }

    public void drawEnergy(double amount) {
        EUCapability.IC2EnergyHandler cap = this.getIC2Cap();
        if (cap != null) {
            cap.drawEnergy(amount);
        }
    }

    public int getSourceTier() {
        EUCapability.IC2EnergyHandler cap = this.getIC2Cap();
        return cap != null ? cap.getEnergyTier() : 0;
    }

    @Override
    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && !this.firstTick) {
            Compat.unloadIC2Tile.accept(this);
        } else if (this.field_145850_b.field_72995_K) {
            CLIENT_MASTER_BY_POS.remove(this.field_174879_c);
        }
        this.firstTick = true;
        if (this.energyState != null) {
            this.energyState.invalid = true;
        }
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && !this.firstTick) {
            Compat.unloadIC2Tile.accept(this);
        } else if (this.field_145850_b.field_72995_K) {
            CLIENT_MASTER_BY_POS.remove(this.field_174879_c);
        }
        if (this.energyState != null) {
            this.energyState.invalid = true;
        }
        this.firstTick = true;
    }

    public boolean interact(@Nonnull EnumFacing side, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        MechMBPart part;
        int ret;
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(this.getOffsetDir().func_177952_p(), master);
        if (id >= 0 && (ret = (part = master.mechanical[id]).interact(side = part.world.realToTransformed(side), (Vec3i)this.getOffsetDir().func_177982_a(0, 0, -master.offsets[id]), player, hand, heldItem)) >= 0) {
            if ((ret & 1) != 0) {
                IBlockState state = this.field_145850_b.func_180495_p(master.field_174879_c);
                this.field_145850_b.func_184138_a(master.field_174879_c, state, state, 3);
                this.field_145850_b.func_175641_c(master.field_174879_c, state.func_177230_c(), 255, id);
            }
            return true;
        }
        return false;
    }

    private BlockPos getOffsetDir() {
        BlockPos offset = MiscUtils.getOffset(BlockPos.field_177959_e, this.facing, this.mirrored, this.offset);
        return new BlockPos(offset.func_177958_n(), offset.func_177952_p(), offset.func_177956_o());
    }

    public int getStrongRSOutput(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(this.getOffsetDir().func_177952_p(), master);
        if (id >= 0 && master.mechanical[id] instanceof IEBlockInterfaces.IRedstoneOutput) {
            MechMBPart part = master.mechanical[id];
            return ((IEBlockInterfaces.IRedstoneOutput)part).getStrongRSOutput(state, part.world.realToTransformed(side));
        }
        return 0;
    }

    public boolean canConnectRedstone(@Nonnull IBlockState state, @Nonnull EnumFacing side) {
        TileEntityMechMB master = this.masterOr(this, this);
        int id = this.getPart(this.getOffsetDir().func_177952_p(), master);
        if (id >= 0 && master.mechanical[id] instanceof IEBlockInterfaces.IRedstoneOutput) {
            MechMBPart part = master.mechanical[id];
            return ((IEBlockInterfaces.IRedstoneOutput)part).canConnectRedstone(state, part.world.realToTransformed(side));
        }
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBoxNoRot() {
        BlockPos offset = this.getOffsetDir();
        TileEntityMechMB master = this.masterOr(this, this);
        if (master == this && !offset.equals((Object)Vec3i.field_177959_e)) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        int comp = this.getPart(offset.func_177952_p(), master);
        if (comp < 0) {
            if (offset.func_177952_p() == 0) {
                return new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0 + (double)offset.func_177956_o() * 0.25);
            }
            return new AxisAlignedBB(0.0, 0.0, (double)(-offset.func_177956_o()) * 0.25, 1.0, 1.0, 0.75);
        }
        MechMBPart part = master.mechanical[comp];
        BlockPos offsetPart = new BlockPos(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p() - master.offsets[comp]);
        return part.getBoundingBox(offsetPart);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        if (this.aabb == null || this.aabb.field_72340_a == this.aabb.field_72336_d) {
            this.aabb = IBlockBoundsIW.IBlockBoundsDirectional.super.getBoundingBox();
        }
        return this.aabb;
    }
}

