/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires;

import blusunrize.immersiveengineering.common.Config;
import malte0811.industrialwires.IndustrialWires;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="industrialwires")
@Mod.EventBusSubscriber
public class IWConfig {
    @Config.Comment(value={"The maximum length of a single connection.", "Order: Tin, Copper, Gold, HV, Glass Fiber"})
    public static int[] maxLengthPerConn = new int[]{16, 16, 16, 32, 32};
    @Config.Comment(value={"The maximum length of wire a coil item.", "Order: Tin, Copper, Gold, HV, Glass Fiber (as above)"})
    public static int[] maxLengthOnCoil = new int[]{1024, 1024, 1024, 2048, 2048};
    @Config.Comment(value={"The factor between the IF transfer rate of the wires and the IF transfer rate corresponding to the EU transfer rate.", "The default value results in the same transfer rates as the standard IE wires"})
    public static double wireRatio = 0.5;
    @Config.Comment(value={"The EU IO rates of the wires. Order is Tin, Copper, Gold, HV, Glass Fiber"})
    public static double[] ioRatesEU = new double[]{32.0, 128.0, 512.0, 2048.0, 8192.0};
    @Config.Comment(value={"The EU loss rates of the wires (EU per block). Order is Tin, Copper, Gold, HV, Glass Fiber"})
    public static double[] euLossPerBlock = new double[]{0.2, 0.2, 0.4, 0.8, 0.025};
    @Config.Comment(value={"Set this to false to completely disable any conversion between IF and EU (default: true)"})
    @Config.RequiresMcRestart
    public static boolean enableConversion = true;
    public static MechConversion mech;
    @Config.Comment(value={"The highest number of keys that can be put on one key ring"})
    public static int maxKeysOnRing;
    public static HVStuff hv;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
        if (ev.getModID().equals("industrialwires")) {
            ConfigManager.sync((String)"industrialwires", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        maxKeysOnRing = 10;
    }

    public static class HVStuff {
        @Config.Comment(value={"The amount of EU a Jacobs Ladder uses per tick, sorted by size of the ladder"})
        public static double[] jacobsUsageWatt = new double[]{40.0, 300.0, 2000.0};
        @Config.Comment(value={"The damage dealt by a small Jacobs Ladder. Normal Ladders deal twice this damage, huge ones 3 times as much"})
        public static float jacobsBaseDmg = 5.0f;
        @Config.Comment(value={"The effect of standing somewhat close to a Marx generator discharge.", "0: Tinnitus, 1: Nausea, 2: normal damage"})
        public static int marxSoundDamage = 0;
        @Config.Comment(value={"Set to false to disable shaders. They are used for rendering the Marx generator and the Jacob's ladder."})
        public static boolean enableShaders = true;
    }

    public static class MechConversion {
        @Config.Comment(value={"The amount of EU that would be produced by an ideal converter from 1 IF (default: 0.25)"})
        public static double euPerIf = 0.25;
        @Config.Comment(value={"The amount of IC2 kinetic energy that an ideal converter produces from 1 EU"})
        public static double kinPerEu = 4.0;
        @Config.Comment(value={"The maximum amount of IF that can be converted to rotational energy", "by one motor in one tick (default: 100)"})
        @Config.RequiresWorldRestart
        public static int maxIfToMech = 100;
        @Config.Comment(value={"The efficiency of the IF motor. The default value of 0.9 means that 10% of the energy are lost in the conversion."})
        public static double ifMotorEfficiency = 0.9;
        @Config.Comment(value={"The maximum amount of IE rotational energy that can be converted into IC2 kinetic energy", "by one converter in one tick"})
        @Config.RequiresWorldRestart
        public static double maxRotToKin = 200.0;
        @Config.Comment(value={"The efficiency of the conversion from IE rotational energy to IC2 kinetic energy"})
        public static double rotToKinEfficiency = 0.7;
        @Config.Comment(value={"The maximum amount of IC2 kinetic energy that can be converted into IE rotational energy", "by one converter in one tick"})
        @Config.RequiresWorldRestart
        public static int maxKinToRot = 600;
        @Config.Comment(value={"The efficiency of the conversion from IC2 kinetic energy to IE rotational energy"})
        public static double kinToRotEfficiency = 0.8;
        @Config.Comment(value={"The conversion factor between Joules (the SI unit) and RF. Used for the Marx generator and the rotary converters", "With the default value the IE diesel generator produces 200kW"})
        public static double joulesPerRF = 200000.0 / (double)(20 * Config.IEConfig.Machines.dieselGen_output);
        @Config.Comment(value={"What energy types can be used with the mechanical multiblock. 0: None (Probably useless),", "1: EU (Currently useless), 2: FE, 3:EU and FE (allows conversion, default)"})
        public static int multiblockEnergyType = 3;

        public static boolean allowMBFE() {
            return (multiblockEnergyType & 2) != 0;
        }

        public static boolean allowMBEU() {
            return (multiblockEnergyType & 1) != 0 && IndustrialWires.hasIC2;
        }
    }
}

