/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.command;

import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.command.CommandJED;
import fi.dy.masa.justenoughdimensions.util.MethodHandleUtils;
import fi.dy.masa.justenoughdimensions.world.WorldInfoJED;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CommandTeleportJED
extends CommandBase {
    private MethodHandle methodHandle_Entity_copyDataFromOld;
    private static CommandTeleportJED instance;

    public CommandTeleportJED() {
        try {
            this.methodHandle_Entity_copyDataFromOld = MethodHandleUtils.getMethodHandleVirtual(Entity.class, new String[]{"func_180432_n", "copyDataFromOld"}, Entity.class);
        }
        catch (MethodHandleUtils.UnableToFindMethodHandleException e) {
            JustEnoughDimensions.logger.error("CommandTeleportJED: Failed to get MethodHandle for Entity#copyDataFromOld()", (Throwable)e);
        }
        instance = this;
    }

    public static CommandTeleportJED instance() {
        return instance;
    }

    public String func_71517_b() {
        return "tpj";
    }

    public String func_71518_a(ICommandSender sender) {
        return "jed.commands.usage.tp";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] strArr, BlockPos pos) {
        if (strArr.length == 1 || strArr.length == 2) {
            return CommandTeleportJED.func_71530_a((String[])strArr, (String[])server.func_71213_z());
        }
        return new ArrayList<String>();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        TeleportData data = this.parseArguments(server, sender, args);
        Entity entity = this.teleportEntityToLocation(data.getEntity(), data, server);
        if (entity != null) {
            CommandTeleportJED.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"jed.commands.teleport.success.coordinates", (Object[])new Object[]{entity.func_70005_c_(), String.format("%.1f", entity.field_70165_t), String.format("%.1f", entity.field_70163_u), String.format("%.1f", entity.field_70161_v), entity.func_130014_f_().field_73011_w.getDimension()});
        }
    }

    private TeleportData parseArguments(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            if (sender.func_174793_f() instanceof Entity) {
                int dim = sender.func_174793_f().func_130014_f_().field_73011_w.getDimension();
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.current.dimension", new Object[]{dim}));
            }
            CommandJED.throwUsage("tp", new Object[0]);
        }
        if (args.length == 1) {
            Entity entityDest = null;
            try {
                entityDest = CommandTeleportJED.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entityDest == null && !(sender.func_174793_f() instanceof Entity)) {
                CommandJED.throwUsage("invalid.entity", args[0]);
            }
            if (entityDest != null) {
                return new TeleportData(sender.func_174793_f(), entityDest);
            }
            return new TeleportData(sender.func_174793_f(), CommandTeleportJED.func_175755_a((String)args[0]), true, server);
        }
        Entity target = null;
        int dimension = 0;
        int argIndex = 0;
        try {
            target = CommandTeleportJED.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[argIndex++]);
        }
        catch (Exception e) {
            if (sender.func_174793_f() == null) {
                CommandJED.throwUsage("no.targetentity", new Object[0]);
            }
            --argIndex;
            target = sender.func_174793_f();
        }
        if (argIndex == 1 && args.length == 2) {
            try {
                Entity destEntity = CommandTeleportJED.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                return new TeleportData(target, destEntity);
            }
            catch (Exception destEntity) {
                // empty catch block
            }
        }
        if (args.length >= argIndex + 1) {
            dimension = CommandTeleportJED.func_175755_a((String)args[argIndex++]);
        }
        if (args.length >= argIndex + 3) {
            Vec3d pos = target.func_174791_d();
            double x = CommandTeleportJED.func_175770_a((double)pos.field_72450_a, (String)args[argIndex++], (boolean)true).func_179628_a();
            double y = CommandTeleportJED.func_175770_a((double)pos.field_72448_b, (String)args[argIndex++], (boolean)false).func_179628_a();
            double z = CommandTeleportJED.func_175770_a((double)pos.field_72449_c, (String)args[argIndex++], (boolean)true).func_179628_a();
            float yaw = target.field_70177_z;
            float pitch = target.field_70125_A;
            if (args.length >= argIndex + 1) {
                yaw = (float)CommandTeleportJED.func_175765_c((String)args[argIndex++]);
            }
            if (args.length >= argIndex + 1) {
                pitch = (float)CommandTeleportJED.func_175765_c((String)args[argIndex++]);
            }
            if (args.length > argIndex) {
                CommandJED.throwUsage("tp", new Object[0]);
            }
            return new TeleportData(target, dimension, x, y, z, yaw, pitch);
        }
        if (args.length > argIndex) {
            CommandJED.throwUsage("tp", new Object[0]);
        }
        return new TeleportData(target, dimension, true, server);
    }

    public Entity teleportEntityToLocation(Entity entity, TeleportData data, MinecraftServer server) throws CommandException {
        entity.func_184210_p();
        entity.func_184226_ay();
        if (entity.func_130014_f_().field_73011_w.getDimension() != data.getDimension()) {
            return this.teleportEntityToDimension(entity, data, server);
        }
        return this.teleportEntityInsideSameDimension(entity, data);
    }

    private Entity teleportEntityInsideSameDimension(Entity entity, TeleportData data) {
        Vec3d pos = data.getPosition(entity.func_130014_f_());
        entity.func_130014_f_().func_72964_e((int)Math.floor(pos.field_72450_a / 16.0), (int)Math.floor(pos.field_72449_c / 16.0));
        entity.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, data.getYaw(), data.getPitch());
        entity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        return entity;
    }

    private Entity teleportEntityToDimension(Entity entity, TeleportData data, MinecraftServer server) throws CommandException {
        WorldServer worldDst = server.func_71218_a(data.getDimension());
        if (worldDst == null) {
            CommandJED.throwNumber("unable.to.load.world", data.getDimension());
        }
        Vec3d pos = data.getPosition((World)worldDst);
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        worldDst.func_72964_e((int)Math.floor(x / 16.0), (int)Math.floor(z / 16.0));
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            World worldOld = player.func_130014_f_();
            TeleporterJED teleporter = new TeleporterJED(worldDst, data);
            player.func_70012_b(x, y, z, data.getYaw(), data.getPitch());
            server.func_184103_al().transferPlayerToDimension(player, data.getDimension(), (Teleporter)teleporter);
            if (worldOld.field_73011_w.getDimension() == 1) {
                worldDst.func_72838_d((Entity)player);
            }
            if (worldOld.field_73011_w instanceof WorldProviderEnd) {
                this.removeDragonBossBarHack(player, (WorldProviderEnd)worldOld.field_73011_w);
            }
            player.func_70634_a(x, y, z);
            worldDst.func_72866_a((Entity)player, false);
            player.func_71023_q(0);
            player.func_71118_n();
        } else {
            WorldServer worldSrc = (WorldServer)entity.func_130014_f_();
            worldSrc.func_72900_e(entity);
            entity.field_70128_L = false;
            worldSrc.func_72866_a(entity, false);
            Entity entityNew = EntityList.func_191304_a(entity.getClass(), (World)worldDst);
            if (entityNew != null) {
                this.copyDataFromOld(entityNew, entity);
                entityNew.func_70012_b(x, y, z, data.getYaw(), data.getPitch());
                boolean flag = entityNew.field_98038_p;
                entityNew.field_98038_p = true;
                worldDst.func_72838_d(entityNew);
                entityNew.field_98038_p = flag;
                worldDst.func_72866_a(entityNew, false);
                entity.field_70128_L = true;
                worldSrc.func_82742_i();
                worldDst.func_82742_i();
            }
            entity = entityNew;
        }
        return entity;
    }

    public static Vec3d getClampedDestinationPosition(Vec3d posIn, World worldDst) {
        return CommandTeleportJED.getClampedDestinationPosition(posIn.field_72450_a, posIn.field_72448_b, posIn.field_72449_c, worldDst);
    }

    public static Vec3d getClampedDestinationPosition(double x, double y, double z, World worldDst) {
        WorldBorder border = worldDst.func_175723_af();
        x = MathHelper.func_151237_a((double)x, (double)(border.func_177726_b() + 2.0), (double)(border.func_177728_d() - 2.0));
        z = MathHelper.func_151237_a((double)z, (double)(border.func_177736_c() + 2.0), (double)(border.func_177733_e() - 2.0));
        return new Vec3d(x, y, z);
    }

    private void removeDragonBossBarHack(EntityPlayerMP player, WorldProviderEnd provider) {
        DragonFightManager manager = provider.func_186063_s();
        if (manager != null) {
            try {
                BossInfoServer bossInfo = (BossInfoServer)ReflectionHelper.getPrivateValue(DragonFightManager.class, (Object)manager, (String[])new String[]{"field_186109_c", "bossInfo"});
                if (bossInfo != null) {
                    bossInfo.func_186761_b(player);
                }
            }
            catch (ReflectionHelper.UnableToAccessFieldException e) {
                JustEnoughDimensions.logger.warn("tpj: Failed to get DragonFightManager#bossInfo");
            }
        }
    }

    private void copyDataFromOld(Entity target, Entity old) {
        try {
            this.methodHandle_Entity_copyDataFromOld.invokeExact(target, old);
        }
        catch (Throwable e) {
            JustEnoughDimensions.logger.error("Error while trying invoke Entity#copyDataFromOld()", e);
        }
    }

    private static class TeleporterJED
    extends Teleporter {
        private final WorldServer world;
        private final TeleportData data;

        public TeleporterJED(WorldServer worldIn, TeleportData data) {
            super(worldIn);
            this.world = worldIn;
            this.data = data;
        }

        public boolean func_85188_a(Entity entityIn) {
            return true;
        }

        public boolean func_180620_b(Entity entityIn, float rotationYaw) {
            Vec3d pos = this.data.getPosition(entityIn.func_130014_f_());
            entityIn.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.data.getYaw(), this.data.getPitch());
            return true;
        }

        public void func_85189_a(long worldTime) {
        }

        public void func_180266_a(Entity entityIn, float rotationYaw) {
            BlockPos spawnCoord = this.world.field_73011_w.func_177496_h();
            if ((this.world.field_73011_w.func_186058_p().func_186068_a() == 1 || this.world.field_73011_w instanceof WorldProviderEnd) && this.world.func_175694_M().equals((Object)spawnCoord)) {
                IBlockState obsidian = Blocks.field_150343_Z.func_176223_P();
                IBlockState air = Blocks.field_150350_a.func_176223_P();
                int spawnX = spawnCoord.func_177958_n();
                int spawnY = spawnCoord.func_177956_o();
                int spawnZ = spawnCoord.func_177952_p();
                for (int zOff = -2; zOff <= 2; ++zOff) {
                    for (int xOff = -2; xOff <= 2; ++xOff) {
                        for (int yOff = -1; yOff < 3; ++yOff) {
                            this.world.func_175656_a(new BlockPos(spawnX + xOff, spawnY + yOff, spawnZ + zOff), yOff < 0 ? obsidian : air);
                        }
                    }
                }
                entityIn.func_70012_b((double)spawnX, (double)spawnY, (double)spawnZ, entityIn.field_70177_z, 0.0f);
                entityIn.field_70159_w = 0.0;
                entityIn.field_70181_x = 0.0;
                entityIn.field_70179_y = 0.0;
            }
        }
    }

    public static class TeleportData {
        private final Entity entity;
        private int dimension;
        private double posX;
        private double posY;
        private double posZ;
        private float yaw;
        private float pitch;

        public TeleportData(Entity entity, int dimension, boolean useSpawn, MinecraftServer server) {
            WorldServer world;
            this.entity = entity;
            this.dimension = dimension;
            this.posX = entity.field_70165_t;
            this.posY = entity.field_70163_u;
            this.posZ = entity.field_70161_v;
            this.yaw = entity.field_70177_z;
            this.pitch = entity.field_70125_A;
            if (useSpawn && (world = server.func_71218_a(dimension)) != null) {
                BlockPos spawn = world.func_180504_m();
                if (spawn == null || !world.func_175694_M().equals((Object)spawn) && world.func_72912_H() instanceof WorldInfoJED) {
                    spawn = world.func_175694_M();
                }
                if (spawn != null) {
                    this.posX = (double)spawn.func_177958_n() + 0.5;
                    this.posY = spawn.func_177956_o();
                    this.posZ = (double)spawn.func_177952_p() + 0.5;
                }
            }
        }

        public TeleportData(Entity entity, int dimension, double x, double y, double z) {
            this.entity = entity;
            this.dimension = dimension;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.yaw = entity.field_70177_z;
            this.pitch = entity.field_70125_A;
        }

        public TeleportData(Entity entity, int dimension, double x, double y, double z, float yaw, float pitch) {
            this.entity = entity;
            this.dimension = dimension;
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public TeleportData(Entity entity, Entity otherEntity) {
            this.entity = entity;
            this.dimension = otherEntity.func_130014_f_().field_73011_w.getDimension();
            this.posX = otherEntity.field_70165_t;
            this.posY = otherEntity.field_70163_u;
            this.posZ = otherEntity.field_70161_v;
            this.yaw = otherEntity.field_70177_z;
            this.pitch = otherEntity.field_70125_A;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public int getDimension() {
            return this.dimension;
        }

        public double getX() {
            return this.posX;
        }

        public double getY() {
            return this.posY;
        }

        public double getZ() {
            return this.posZ;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public Vec3d getPosition(World world) {
            return CommandTeleportJED.getClampedDestinationPosition(this.posX, this.posY, this.posZ, world);
        }

        public String toString() {
            return String.format("TeleportData:{dim=%d,x=%.2f,y=%.2f,z=%.2f,yaw=%.2f,pitch=%.2f,entity=%s}\n", this.dimension, this.posX, this.posY, this.posZ, Float.valueOf(this.yaw), Float.valueOf(this.pitch), this.entity.func_70005_c_());
        }
    }
}

