/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.thermalexpansion.recipehandler;

import cofh.thermalexpansion.block.machine.TileCentrifuge;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.capability.recipehandler.TransformedRecipeHandlerAdapter;

public class TileCentrifugeRecipeHandler
extends TransformedRecipeHandlerAdapter<CentrifugeManager.CentrifugeRecipe> {
    private final TileCentrifuge tile;

    public TileCentrifugeRecipeHandler(TileCentrifuge tile) {
        super(Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.FLUIDSTACK, IngredientComponent.ITEMSTACK}));
        this.tile = tile;
    }

    protected boolean isAugmentMobs() {
        return this.tile.augmentMobs();
    }

    @Override
    protected String getRecipeCacheKey() {
        return "thermalexpansion:centrifuge:" + this.isAugmentMobs();
    }

    @Override
    protected IRecipeDefinition transformRecipe(CentrifugeManager.CentrifugeRecipe recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, recipe.getInput(), 15)}))}));
        ArrayList outputItems = Lists.newArrayList();
        for (int i = 0; i < recipe.getOutput().size(); ++i) {
            if ((Integer)recipe.getChance().get(i) != 1) continue;
            outputItems.add(recipe.getOutput().get(i));
        }
        if (!outputItems.isEmpty()) {
            outputs.put(IngredientComponent.ITEMSTACK, outputItems);
        }
        if (recipe.getFluid() != null) {
            outputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new FluidStack[]{recipe.getFluid()}));
        }
        return new RecipeDefinition(inputs, new MixedIngredients(outputs));
    }

    @Override
    protected CentrifugeManager.CentrifugeRecipe findRecipe(IMixedIngredients input) {
        if (this.isAugmentMobs()) {
            return CentrifugeManager.getRecipeMob((ItemStack)((ItemStack)Iterables.getFirst(input.getInstances(IngredientComponent.ITEMSTACK), null)));
        }
        return CentrifugeManager.getRecipe((ItemStack)((ItemStack)Iterables.getFirst(input.getInstances(IngredientComponent.ITEMSTACK), null)));
    }

    @Override
    protected Collection<CentrifugeManager.CentrifugeRecipe> getRecipesRaw() {
        return Lists.newArrayList((Object[])(this.isAugmentMobs() ? CentrifugeManager.getRecipeListMobs() : CentrifugeManager.getRecipeList()));
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.ITEMSTACK && size == 1;
    }
}

