/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.core.recipes.RecipePair;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.recipehandler.CraftingProviderRecipeHandlerAdapter;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaCraftingTableRecipeHandler;

public class TileCarpenterRecipeHandler
extends CraftingProviderRecipeHandlerAdapter<ICarpenterRecipe> {
    public TileCarpenterRecipeHandler() {
        super(new CarpenterRecipeManager(), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK, IngredientComponent.FLUIDSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}));
    }

    @Override
    protected IRecipeDefinition transformRecipe(ICarpenterRecipe recipe) {
        IDescriptiveRecipe description = recipe.getCraftingGridRecipe();
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        ArrayList itemStackInputs = Lists.newArrayList();
        itemStackInputs.add(new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, recipe.getBox(), 15)})));
        itemStackInputs.addAll(description.getRawIngredients().stream().map(alternatives -> new PrototypedIngredientAlternativesList(alternatives.stream().map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, 15)).collect(Collectors.toList()))).collect(Collectors.toList()));
        inputs.put(IngredientComponent.ITEMSTACK, itemStackInputs);
        inputs.put(IngredientComponent.FLUIDSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, recipe.getFluidResource(), 7)}))}));
        outputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{description.getOutput()}));
        return new RecipeDefinition(inputs, new MixedIngredients(outputs));
    }

    @Override
    protected ICarpenterRecipe findRecipe(IMixedIngredients input) {
        List<ItemStack> itemStacks = input.getInstances(IngredientComponent.ITEMSTACK);
        ItemStack box = ItemStack.field_190927_a;
        int dimension = (int)Math.ceil(Math.sqrt((float)itemStacks.size() - 1.0f));
        InventoryCrafting grid = new InventoryCrafting(VanillaCraftingTableRecipeHandler.DUMMY_CONTAINTER, dimension, dimension);
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (i == 0) {
                box = itemStacks.get(i);
                continue;
            }
            grid.func_70299_a(i - 1, itemStacks.get(i));
        }
        FluidStack fluidStack = (FluidStack)Iterables.getFirst(input.getInstances(IngredientComponent.FLUIDSTACK), null);
        RecipePair recipePair = CarpenterRecipeManager.findMatchingRecipe((FluidStack)fluidStack, (ItemStack)box, (IInventory)grid);
        return recipePair == null ? null : (ICarpenterRecipe)recipePair.getRecipe();
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.FLUIDSTACK && size <= 1 || component == IngredientComponent.ITEMSTACK && size <= 10;
    }
}

