/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public interface IMixedIngredients
extends Comparable<IMixedIngredients> {
    public Set<IngredientComponent<?, ?>> getComponents();

    public <T> List<T> getInstances(IngredientComponent<T, ?> var1);

    public static NBTTagCompound serialize(IMixedIngredients ingredients) {
        NBTTagCompound tag = new NBTTagCompound();
        for (IngredientComponent<?, ?> component : ingredients.getComponents()) {
            NBTTagList instances = new NBTTagList();
            IIngredientSerializer<?, ?> serializer = component.getSerializer();
            for (Object instance : ingredients.getInstances(component)) {
                instances.func_74742_a(serializer.serializeInstance(instance));
            }
            tag.func_74782_a(component.getRegistryName().toString(), (NBTBase)instances);
        }
        return tag;
    }

    public static MixedIngredients deserialize(NBTTagCompound tag) throws IllegalArgumentException {
        IdentityHashMap ingredients = Maps.newIdentityHashMap();
        for (String componentName : tag.func_150296_c()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            NBTBase subTag = tag.func_74781_a(componentName);
            if (!(subTag instanceof NBTTagList)) {
                throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid list of instances");
            }
            NBTTagList instancesTag = (NBTTagList)subTag;
            IIngredientSerializer serializer = component.getSerializer();
            ArrayList instances = Lists.newArrayList();
            for (NBTBase instanceTag : instancesTag) {
                instances.add(serializer.deserializeInstance(instanceTag));
            }
            ingredients.put(component, instances);
        }
        return new MixedIngredients(ingredients);
    }
}

