/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection.type.hanginglights;

import com.pau101.fairylights.server.block.FLBlocks;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.FeatureType;
import com.pau101.fairylights.server.fastener.connection.type.ConnectionHangingFeature;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.ColoredLightVariant;
import com.pau101.fairylights.server.fastener.connection.type.hanginglights.Light;
import com.pau101.fairylights.server.item.ItemLight;
import com.pau101.fairylights.server.item.LightVariant;
import com.pau101.fairylights.server.jingle.Jingle;
import com.pau101.fairylights.server.jingle.JingleLibrary;
import com.pau101.fairylights.server.jingle.JinglePlayer;
import com.pau101.fairylights.server.sound.FLSounds;
import com.pau101.fairylights.util.OreDictUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public final class ConnectionHangingLights
extends ConnectionHangingFeature<Light> {
    private static final int LIGHT_VALUE = 15;
    private static final int LIGHT_UPDATE_WAIT = 400;
    private static final int LIGHT_UPDATE_RATE = 10;
    private List<ColoredLightVariant> pattern;
    private boolean twinkle;
    private JinglePlayer jinglePlayer = new JinglePlayer();
    private boolean wasPlaying = false;
    private boolean isOn = true;
    private Set<BlockPos> litBlocks = new HashSet<BlockPos>();
    private Set<BlockPos> oldLitBlocks = new HashSet<BlockPos>();
    private int lightUpdateTime = (int)(Math.random() * 400.0 / 2.0);
    private int lightUpdateIndex;

    public ConnectionHangingLights(World world, Fastener<?> fastener, UUID uuid, Fastener<?> destination, boolean isOrigin, NBTTagCompound compound) {
        super(world, fastener, uuid, destination, isOrigin, compound);
    }

    public ConnectionHangingLights(World world, Fastener<?> fastenerOrigin, UUID uuid) {
        super(world, fastenerOrigin, uuid);
        this.pattern = new ArrayList<ColoredLightVariant>();
    }

    @Override
    public ConnectionType getType() {
        return ConnectionType.HANGING_LIGHTS;
    }

    @Nullable
    public Jingle getPlayingJingle() {
        return this.jinglePlayer.getJingle();
    }

    public void play(JingleLibrary library, Jingle jingle, int lightOffset) {
        this.jinglePlayer.play(library, jingle, lightOffset);
    }

    @Override
    public boolean interact(EntityPlayer player, Vec3d hit, FeatureType featureType, int feature, ItemStack heldStack, EnumHand hand) {
        float pitch;
        SoundEvent lightSnd;
        if (featureType == FEATURE && OreDictUtils.isDye(heldStack)) {
            int index = feature % this.pattern.size();
            ColoredLightVariant light = this.pattern.get(index);
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)OreDictUtils.getDyeMetadata(heldStack));
            if (light.getColor() != color) {
                this.pattern.set(index, light.withColor(color));
                this.dataUpdateState = true;
                heldStack.func_190918_g(1);
                this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, FLSounds.FEATURE_COLOR_CHANGE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        if (super.interact(player, hit, featureType, feature, heldStack, hand)) {
            return true;
        }
        boolean bl = this.isOn = !this.isOn;
        if (this.isOn) {
            lightSnd = FLSounds.FEATURE_LIGHT_TURNON;
            pitch = 0.6f;
        } else {
            lightSnd = FLSounds.FEATURE_LIGHT_TURNOFF;
            pitch = 0.5f;
        }
        this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, lightSnd, SoundCategory.BLOCKS, 1.0f, pitch);
        this.computeCatenary();
        return true;
    }

    @Override
    public void onUpdateLate() {
        this.jinglePlayer.tick(this.world, this.fastener.getConnectionPoint(), (Light[])this.features, this.world.field_72995_K);
        boolean playing = this.jinglePlayer.isPlaying();
        if (playing || this.wasPlaying) {
            this.updateNeighbors(this.fastener);
            if (this.getDestination().isLoaded(this.world)) {
                this.updateNeighbors(this.getDestination().get(this.world));
            }
        }
        this.wasPlaying = playing;
        boolean on = !this.isDynamic() && this.isOn;
        for (int i = 0; i < ((Light[])this.features).length; ++i) {
            Light light = ((Light[])this.features)[i];
            light.tick(this, this.twinkle, on);
        }
        if (on && this.isOrigin() && ((Light[])this.features).length > 0) {
            ++this.lightUpdateTime;
            if (this.lightUpdateTime > 400 && this.lightUpdateTime % 10 == 0) {
                if (this.lightUpdateIndex >= ((Light[])this.features).length) {
                    this.lightUpdateIndex = 0;
                    this.lightUpdateTime = this.world.field_73012_v.nextInt(200);
                } else {
                    this.setLight(new BlockPos(((Light[])this.features)[this.lightUpdateIndex++].getAbsolutePoint(this.fastener)), 15);
                }
            }
        }
    }

    private void updateNeighbors(Fastener<?> fastener) {
        this.world.func_175666_e(fastener.getPos(), (Block)FLBlocks.FASTENER);
    }

    protected Light[] createFeatures(int length) {
        return new Light[length];
    }

    @Override
    protected Light createFeature(int index, Vec3d point, Vec3d rotation) {
        boolean on = !this.isDynamic() && this.isOn;
        Light light = new Light(index, point, rotation, on);
        if (on && this.isOrigin()) {
            BlockPos pos = new BlockPos(light.getAbsolutePoint(this.fastener));
            this.litBlocks.add(pos);
            this.setLight(pos, 15);
        }
        if (this.pattern.size() > 0) {
            ColoredLightVariant lightData = this.pattern.get(index % this.pattern.size());
            light.setVariant(lightData.getVariant());
            light.setColor(ItemLight.getColorValue(lightData.getColor()));
        }
        return light;
    }

    @Override
    protected float getFeatureSpacing() {
        if (this.pattern.isEmpty()) {
            return LightVariant.FAIRY.getSpacing();
        }
        float spacing = 0.0f;
        for (ColoredLightVariant patternLightData : this.pattern) {
            float lightSpacing = patternLightData.getVariant().getSpacing();
            if (!(lightSpacing > spacing)) continue;
            spacing = lightSpacing;
        }
        return spacing;
    }

    @Override
    protected void onBeforeUpdateFeatures(int size) {
        Iterator<BlockPos> litIter = this.litBlocks.iterator();
        while (litIter.hasNext()) {
            this.oldLitBlocks.add(litIter.next());
            litIter.remove();
        }
    }

    @Override
    protected void onAfterUpdateFeatures(int size) {
        this.oldLitBlocks.removeAll(this.litBlocks);
        Iterator<BlockPos> oldIter = this.oldLitBlocks.iterator();
        while (oldIter.hasNext()) {
            this.world.func_180500_c(EnumSkyBlock.BLOCK, oldIter.next());
            oldIter.remove();
        }
    }

    @Override
    public void onRemove() {
        for (BlockPos pos : this.litBlocks) {
            this.world.func_180500_c(EnumSkyBlock.BLOCK, pos);
        }
    }

    private void setLight(BlockPos pos, int value) {
        if (this.world.func_175623_d(pos) && this.world.func_175642_b(EnumSkyBlock.BLOCK, pos) != value) {
            this.world.func_175653_a(EnumSkyBlock.BLOCK, pos, value);
            for (EnumFacing dir : EnumFacing.values()) {
                this.updateLight(pos.func_177972_a(dir), value);
            }
        }
    }

    private void updateLight(BlockPos pos, int value) {
        if (this.world.func_175642_b(EnumSkyBlock.BLOCK, pos) != value) {
            this.world.func_180500_c(EnumSkyBlock.BLOCK, pos);
        }
    }

    public boolean canCurrentlyPlayAJingle() {
        return !this.jinglePlayer.isPlaying();
    }

    public float getJingleProgress() {
        return this.jinglePlayer.getProgress();
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound compound = super.serialize();
        compound.func_74782_a("jinglePlayer", (NBTBase)this.jinglePlayer.serialize());
        compound.func_74757_a("isOn", this.isOn);
        return compound;
    }

    @Override
    public void deserialize(NBTTagCompound compound) {
        super.deserialize(compound);
        if (this.jinglePlayer == null) {
            this.jinglePlayer = new JinglePlayer();
        }
        if (!this.jinglePlayer.isPlaying()) {
            this.jinglePlayer.deserialize(compound.func_74775_l("jinglePlayer"));
        }
        this.isOn = compound.func_74767_n("isOn");
    }

    @Override
    public NBTTagCompound serializeLogic() {
        NBTTagCompound compound = super.serializeLogic();
        NBTTagList tagList = new NBTTagList();
        for (ColoredLightVariant light : this.pattern) {
            tagList.func_74742_a((NBTBase)light.serialize());
        }
        compound.func_74782_a("pattern", (NBTBase)tagList);
        compound.func_74757_a("twinkle", this.twinkle);
        compound.func_74757_a("tight", this.slack == 0.0f);
        return compound;
    }

    @Override
    public void deserializeLogic(NBTTagCompound compound) {
        super.deserializeLogic(compound);
        NBTTagList patternList = compound.func_150295_c("pattern", 10);
        this.pattern = new ArrayList<ColoredLightVariant>();
        for (int i = 0; i < patternList.func_74745_c(); ++i) {
            NBTTagCompound lightCompound = patternList.func_150305_b(i);
            this.pattern.add(ColoredLightVariant.from(lightCompound));
        }
        this.twinkle = compound.func_74767_n("twinkle");
        if (compound.func_74767_n("tight")) {
            this.slack = 0.0f;
        }
    }
}

