/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener.connection;

import com.pau101.fairylights.server.fastener.connection.Segment;
import com.pau101.fairylights.util.CatenaryUtils;
import com.pau101.fairylights.util.CubicBezier;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public final class Catenary {
    private static final int MIN_VERTEX_COUNT = 8;
    private static final int SCALE = 16;
    private final Vec3d vector;
    private final Segment[] segments;
    private final float length;

    private Catenary(Vec3d vector, Segment[] segments, float length) {
        this.vector = vector;
        this.segments = segments;
        this.length = length;
    }

    public Vec3d getVector() {
        return this.vector;
    }

    public Segment[] getSegments() {
        return this.segments;
    }

    public float getLength() {
        return this.length;
    }

    public static Catenary from(Vec3d direction, CubicBezier bezier, float slack) {
        float dist = (float)direction.func_72433_c();
        float length = (double)slack < 0.01 || Math.abs(direction.field_72450_a) < 1.0E-6 && Math.abs(direction.field_72449_c) < 1.0E-6 ? dist : dist + (Catenary.lengthFunc(bezier, dist) - dist) * slack;
        return Catenary.from(direction, length);
    }

    private static float lengthFunc(CubicBezier bezier, double length) {
        return bezier.eval(MathHelper.func_76131_a((float)((float)length / 32.0f), (float)0.0f, (float)1.0f)) * 32.0f;
    }

    public static Catenary from(Vec3d direction, float ropeLength) {
        float rotation = (float)MathHelper.func_181159_b((double)direction.field_72449_c, (double)direction.field_72450_a);
        int vertexCount = (int)(ropeLength * 3.0f);
        if (vertexCount < 8) {
            vertexCount = 8;
        }
        float endX = MathHelper.func_76133_a((double)(direction.field_72450_a * direction.field_72450_a + direction.field_72449_c * direction.field_72449_c));
        float[][] result = CatenaryUtils.catenary(0.0f, 0.0f, endX, (float)direction.field_72448_b, ropeLength, vertexCount);
        float[] xs = result[0];
        float[] ys = result[1];
        Segment[] segments = new Segment[xs.length - 1];
        float rotationCos = MathHelper.func_76134_b((float)rotation);
        float rotationSin = MathHelper.func_76126_a((float)rotation);
        float length = 0.0f;
        Segment prev = null;
        int i = 0;
        int end = xs.length - 1;
        while (true) {
            Vec3d vertex = new Vec3d((double)(xs[i] * rotationCos * 16.0f), (double)(ys[i] * 16.0f), (double)(xs[i] * rotationSin * 16.0f));
            if (i > 0) {
                prev.connectTo(vertex);
                length = (float)((double)length + prev.getLength());
            }
            if (i == end) break;
            segments[i] = prev = new Segment(vertex);
            ++i;
        }
        return new Catenary(direction, segments, length);
    }
}

