/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.client.model;

import com.pau101.fairylights.client.renderer.block.FastenerStateMapper;
import com.pau101.fairylights.server.block.FLBlocks;
import com.pau101.fairylights.server.item.FLItems;
import com.pau101.fairylights.server.item.LightVariant;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="fairylights")
public final class FLModels {
    private FLModels() {
    }

    @SubscribeEvent
    public static void register(ModelRegistryEvent event) {
        LightVariant[] lightVariants = LightVariant.values();
        for (int var = 0; var < lightVariants.length; ++var) {
            LightVariant variant = lightVariants[var];
            ModelResourceLocation model = new ModelResourceLocation("fairylights:light_" + variant.getName(), "inventory");
            int meta = var * 16;
            for (int color = 0; color < 16; ++color) {
                FLModels.setModel((Item)FLItems.LIGHT, meta, model);
                ++meta;
            }
        }
        FLModels.setModel(FLItems.HANGING_LIGHTS, "hanging_lights");
        FLModels.setModel(FLItems.GARLAND, "garland");
        FLModels.setModel(FLItems.TINSEL, "tinsel");
        FLModels.setModel(FLItems.PENNANT_BUNTING, "pennant_bunting");
        FLModels.setModel(FLItems.LETTER_BUNTING, "letter_bunting");
        for (int meta = 0; meta < 16; ++meta) {
            FLModels.setModel(FLItems.PENNANT, meta, "pennant");
        }
        FLModels.setModel(FLItems.LADDER, "ladder");
        ModelLoader.setCustomStateMapper((Block)FLBlocks.FASTENER, (IStateMapper)new FastenerStateMapper());
    }

    private static void setModel(Item item, String id) {
        FLModels.setModel(item, 0, id);
    }

    private static void setModel(Item item, int meta, String id) {
        FLModels.setModel(item, meta, new ModelResourceLocation("fairylights:" + id, "inventory"));
    }

    private static void setModel(Item item, int meta, ModelResourceLocation model) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)model);
    }
}

