/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;

public class CargoRecipeSerializer
extends ShapelessRecipe.Serializer {
    private static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonArray.get(i));
            if (ingredient.func_203189_d()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    @Nonnull
    public ShapelessRecipe func_199425_a_(@Nonnull ResourceLocation recipeId, JsonObject json) {
        CargoModule cargoModule;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = CargoRecipeSerializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        JsonObject result = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        if (result.has("cargo")) {
            ResourceLocation cargoName = new ResourceLocation(result.get("cargo").getAsString());
            cargoModule = TransportAPI.getCargo(cargoName);
            if (cargoModule == null) {
                throw new JsonParseException("Failed to find Cargo for name: " + cargoName);
            }
        } else {
            throw new JsonParseException("Failed to find Cargo String on Result");
        }
        ItemStack itemStack = ShapedRecipe.func_199798_a((JsonObject)result);
        itemStack.func_190925_c("cargo").func_74778_a("name", Objects.requireNonNull(cargoModule.getRegistryName()).toString());
        return new ShapelessRecipe(recipeId, s, itemStack, ingredients);
    }
}

