/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.MinecartItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.item.IModularItem;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportModuleSlots;
import xyz.brassgoggledcoders.transport.entity.CargoCarrierMinecartEntity;

public class CargoCarrierMinecartItem
extends MinecartItem
implements IModularItem<CargoCarrierMinecartEntity> {
    public CargoCarrierMinecartItem() {
        this(new Item.Properties().func_200919_a(Items.field_151143_au).func_200916_a(Transport.ITEM_GROUP));
    }

    public CargoCarrierMinecartItem(Item.Properties properties) {
        super(AbstractMinecartEntity.Type.CHEST, properties);
        this.func_185043_a(new ResourceLocation("transport", "cargo"), (itemStack, world, livingEntity) -> Optional.ofNullable(CargoCarrierMinecartItem.getCargo(itemStack.func_179543_a("cargo"))).map(ForgeRegistryEntry::getRegistryName).map(arg_0 -> ((ForgeRegistry)((ForgeRegistry)TransportAPI.CARGO.get())).getID(arg_0)).map(id -> Float.valueOf((float)id.intValue() / 1000.0f)).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public static CargoModule getCargo(@Nullable CompoundNBT cargo) {
        return Optional.ofNullable(cargo).map(compoundNBT -> compoundNBT.func_74779_i("name")).map(TransportAPI::getCargo).orElse(null);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockPos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockPos = context.func_195995_a());
        if (!blockstate.func_203425_a(BlockTags.field_203437_y)) {
            return ActionResultType.FAIL;
        }
        ItemStack itemStack = context.func_195996_i();
        if (!world.field_72995_K) {
            CargoModule cargoModule;
            CompoundNBT cargoNBT;
            RailShape railshape = blockstate.func_177230_c() instanceof AbstractRailBlock ? ((AbstractRailBlock)blockstate.func_177230_c()).getRailDirection(blockstate, (IBlockReader)world, blockPos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.func_208092_c()) {
                d0 = 0.5;
            }
            CargoCarrierMinecartEntity cargoCarrierMinecartEntity = new CargoCarrierMinecartEntity(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.0625 + d0, (double)blockPos.func_177952_p() + 0.5);
            if (itemStack.func_82837_s()) {
                cargoCarrierMinecartEntity.func_200203_b(itemStack.func_200301_q());
            }
            LazyOptional modularEntity = cargoCarrierMinecartEntity.getCapability(TransportAPI.MODULAR_ENTITY);
            CompoundNBT moduleNBT = itemStack.func_179543_a("modules");
            if (moduleNBT != null) {
                modularEntity.ifPresent(value -> value.deserializeNBT((INBT)moduleNBT));
            }
            if ((cargoNBT = itemStack.func_179543_a("cargo")) != null && cargoNBT.func_74764_b("name") && (cargoModule = TransportAPI.getCargo(cargoNBT.func_74779_i("name"))) != null) {
                modularEntity.ifPresent(value -> {
                    ModuleInstance<CargoModule> moduleInstance = value.add(cargoModule, (ModuleSlot)TransportModuleSlots.CARGO.get(), false);
                    if (moduleInstance != null && cargoNBT.func_74764_b("instance")) {
                        moduleInstance.deserializeNBT(cargoNBT.func_74775_l("instance"));
                    }
                });
            }
            if (context.func_195999_j() != null) {
                cargoCarrierMinecartEntity.setOriginalPushes(context.func_195999_j());
            }
            world.func_217376_c((Entity)cargoCarrierMinecartEntity);
        }
        itemStack.func_190918_g(1);
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ListNBT moduleInstancesNBT;
        CompoundNBT modulesNBT = stack.func_179543_a("modules");
        if (modulesNBT != null && (moduleInstancesNBT = modulesNBT.func_150295_c("moduleInstances", 10)).size() > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("text.transport.installed_modules", new Object[0]));
            for (int x = 0; x < moduleInstancesNBT.size(); ++x) {
                CompoundNBT moduleInstanceNBT = moduleInstancesNBT.func_150305_b(x);
                Module<?> module = Module.fromCompoundNBT(moduleInstanceNBT);
                ModuleSlot moduleSlot = TransportAPI.getModuleSlot(moduleInstanceNBT.func_74779_i("moduleSlot"));
                if (module == null || moduleSlot == null) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent("text.transport.installed_module", new Object[]{moduleSlot.getDisplayName(), module.getDisplayName()}));
            }
        }
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        CargoModule cargoModule = CargoCarrierMinecartItem.getCargo(stack.func_179543_a("cargo"));
        if (cargoModule != null) {
            return new TranslationTextComponent("text.transport.with", new Object[]{Items.field_151143_au.func_200295_i(stack), cargoModule.getDisplayName()});
        }
        return super.func_200295_i(stack);
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ((ForgeRegistry)TransportAPI.CARGO.get()).getValues().stream().filter(cargo -> !cargo.isEmpty()).map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).map(resourceLocation -> {
                ItemStack itemStack = new ItemStack((IItemProvider)this);
                itemStack.func_190925_c("cargo").func_74778_a("name", resourceLocation);
                return itemStack;
            }).forEach(arg_0 -> items.add(arg_0));
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    @Override
    public EntityType<CargoCarrierMinecartEntity> getEntityType() {
        return (EntityType)TransportEntities.CARGO_MINECART.get();
    }
}

