/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.network.PacketReturnScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetScreenData {
    private String modid;
    private GlobalCoordinate pos;
    private long millis;

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.modid);
        buf.func_179255_a(this.pos.getCoordinate());
        buf.writeInt(this.pos.getDimension().func_186068_a());
        buf.writeLong(this.millis);
    }

    public PacketGetScreenData() {
    }

    public PacketGetScreenData(PacketBuffer buf) {
        this.modid = buf.func_150789_c(Short.MAX_VALUE);
        this.pos = new GlobalCoordinate(buf.func_179259_c(), DimensionType.func_186069_a((int)buf.readInt()));
        this.millis = buf.readLong();
    }

    public PacketGetScreenData(String modid, GlobalCoordinate pos, long millis) {
        this.modid = modid;
        this.pos = pos;
        this.millis = millis;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            TileEntity te = (world = WorldTools.getWorld((World)world, (DimensionType)this.pos.getDimension())).func_175625_s(this.pos.getCoordinate());
            if (!(te instanceof ScreenTileEntity)) {
                Logging.logError((String)"PacketGetScreenData: TileEntity is not a SimpleScreenTileEntity!");
                return;
            }
            Map<Integer, IModuleData> screenData = ((ScreenTileEntity)te).getScreenData(this.millis);
            PacketReturnScreenData msg = new PacketReturnScreenData(this.pos, screenData);
            RFToolsUtilityMessages.INSTANCE.sendTo((Object)msg, ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        });
        ctx.setPacketHandled(true);
    }
}

