/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.part.block;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.misc.Banner;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.part.block.WeightedRandomBlock;
import xiroc.dungeoncrawl.util.IBlockPlacementHandler;

public class Spawner
implements IBlockPlacementHandler {
    public static final EntityType<?>[] ENTITIES = new EntityType[]{EntityType.field_200725_aD, EntityType.field_200741_ag, EntityType.field_200748_an, EntityType.field_200794_h, EntityType.field_200763_C};
    public static final EntityType<?>[] ENTITIES_RARE = new EntityType[]{EntityType.field_200740_af, EntityType.field_200797_k, EntityType.field_200750_ap, EntityType.field_200803_q};
    public static final EntityType<?>[] ENTITIES_SPECIAL = new EntityType[]{EntityType.field_200792_f};
    public static final Set<EntityType<?>> INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.field_200725_aD).add((Object)EntityType.field_200741_ag).add((Object)EntityType.field_200763_C).add((Object)EntityType.field_200750_ap).build();
    public static final Set<EntityType<?>> RANGED_INVENTORY_ENTITIES = ImmutableSet.builder().add((Object)EntityType.field_200741_ag).add((Object)EntityType.field_200750_ap).build();

    @Override
    public void setupBlock(IWorld world, BlockState state, BlockPos pos, Random rand, Treasure.Type treasureType, int theme, int stage) {
        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof MobSpawnerTileEntity) {
            MobSpawnerTileEntity tile = (MobSpawnerTileEntity)tileentity;
            EntityType<?> type = Spawner.getRandomEntityType(rand);
            tile.func_145881_a().func_200876_a(type);
            if (!((Boolean)Config.VANILLA_SPAWNERS.get()).booleanValue() && INVENTORY_ENTITIES.contains(type)) {
                CompoundNBT spawnerNBT = tile.func_145881_a().func_189530_b(new CompoundNBT());
                ListNBT potentialSpawns = new ListNBT();
                for (int i = 0; i < (Integer)Config.SPAWNER_ENTITIES.get(); ++i) {
                    CompoundNBT nbt = new CompoundNBT();
                    CompoundNBT spawnData = Spawner.createSpawnData(type, null, rand, stage);
                    nbt.func_218657_a("Entity", (INBT)spawnData);
                    nbt.func_74768_a("Weight", 1);
                    nbt.func_74777_a("MinSpawnDelay", (short)200);
                    nbt.func_74777_a("MaxSpawnDelay", (short)800);
                    nbt.func_74777_a("SpawnCount", (short)1);
                    if (i == 0) {
                        spawnerNBT.func_218657_a("SpawnData", (INBT)spawnData);
                    }
                    potentialSpawns.add((Object)nbt);
                }
                spawnerNBT.func_218657_a("SpawnPotentials", (INBT)potentialSpawns);
                tile.func_145881_a().func_98270_a(spawnerNBT);
            }
        } else {
            DungeonCrawl.LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    public static CompoundNBT createSpawnData(@Nullable EntityType<?> type, @Nullable CompoundNBT spawnData, Random rand, int stage) {
        if (type == null) {
            type = Spawner.getRandomEntityType(rand);
        }
        if (spawnData == null) {
            spawnData = new CompoundNBT();
        }
        spawnData.func_74778_a("id", type.getRegistryName().toString());
        if (INVENTORY_ENTITIES.contains(type)) {
            ItemStack mainHand;
            ItemStack[] armor = Spawner.getArmor(rand, stage);
            ListNBT armorList = new ListNBT();
            for (ItemStack stack : armor) {
                if (stack == ItemStack.field_190927_a) continue;
                armorList.add((Object)stack.func_77955_b(new CompoundNBT()));
            }
            if (armorList.size() > 0) {
                spawnData.func_218657_a("ArmorItems", (INBT)armorList);
            }
            ListNBT handItems = new ListNBT();
            ItemStack itemStack = mainHand = RANGED_INVENTORY_ENTITIES.contains(type) ? RandomEquipment.getRangedWeapon(WeightedRandomBlock.RANDOM, stage) : RandomEquipment.getMeleeWeapon(WeightedRandomBlock.RANDOM, stage);
            if (mainHand != ItemStack.field_190927_a) {
                handItems.add((Object)mainHand.func_77955_b(new CompoundNBT()));
            }
            handItems.add((Object)(rand.nextDouble() < (Double)Config.SHIELD_PROBABILITY.get() ? Banner.createShield(rand).func_77955_b(new CompoundNBT()) : ItemStack.field_190927_a.func_77955_b(new CompoundNBT())));
            spawnData.func_218657_a("HandItems", (INBT)handItems);
        }
        return spawnData;
    }

    public static void equipMonster(MonsterEntity entity, Random rand, int stage) {
        if (INVENTORY_ENTITIES.contains(entity.func_200600_R())) {
            ItemStack[] armor = Spawner.getArmor(rand, stage);
            entity.func_184201_a(EquipmentSlotType.FEET, armor[0]);
            entity.func_184201_a(EquipmentSlotType.LEGS, armor[1]);
            entity.func_184201_a(EquipmentSlotType.CHEST, armor[2]);
            entity.func_184201_a(EquipmentSlotType.HEAD, armor[3]);
            ItemStack mainHand = RANGED_INVENTORY_ENTITIES.contains(entity.func_200600_R()) ? RandomEquipment.getRangedWeapon(WeightedRandomBlock.RANDOM, stage) : RandomEquipment.getMeleeWeapon(WeightedRandomBlock.RANDOM, stage);
            entity.func_184201_a(EquipmentSlotType.MAINHAND, mainHand);
            if (rand.nextDouble() < (Double)Config.SHIELD_PROBABILITY.get()) {
                entity.func_184201_a(EquipmentSlotType.OFFHAND, Banner.createShield(rand));
            }
        }
    }

    public static ItemStack[] getArmor(Random rand, int stage) {
        switch (stage) {
            case 0: {
                return RandomEquipment.ARMOR_1.roll(rand);
            }
            case 1: {
                return RandomEquipment.ARMOR_2.roll(rand);
            }
            case 2: {
                return RandomEquipment.ARMOR_3.roll(rand);
            }
        }
        return RandomEquipment.ARMOR_1.roll(rand);
    }

    public static EntityType<?> getRandomEntityType(Random rand) {
        return (double)rand.nextFloat() < 0.04 ? ENTITIES_RARE[rand.nextInt(ENTITIES_RARE.length)] : ENTITIES[rand.nextInt(ENTITIES.length)];
    }
}

